/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.output;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLArray;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.gfrn.GFRN;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class AnnotationsFileWriter {
    public static final String SYSTEM_ID = "http://wwwcs.uni-paderborn.de/cs/fujaba/DTDs/StructuralAnnotations.dtd";
    public static final String STRUCTURAL_ANNOTATIONS_TAG = "StructuralAnnotations";
    public static final String STRUCTURAL_ANNOTATION_TAG = "StructuralAnnotation";
    public static final String BOUND_OBJECT_TAG = "BoundObject";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String NAME_ATTRIBUTE = "name";
    private StringBuffer buffer;
    private final GFRN gfrn;

    public AnnotationsFileWriter(GFRN gfrn) {
        this.gfrn = gfrn;
    }

    public boolean save(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            String traceDefinitionDocument = this.generateXMLDocument();
            fileWriter.write(traceDefinitionDocument);
            fileWriter.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public String generateXMLDocument() {
        this.buffer = new StringBuffer();
        this.buffer.append("<?xml version=\"1.0\" standalone=\"no\"?>\n\n");
        this.buffer.append("<!DOCTYPE ");
        this.buffer.append(STRUCTURAL_ANNOTATIONS_TAG);
        this.buffer.append(" SYSTEM \"");
        this.buffer.append(SYSTEM_ID);
        this.buffer.append("\">\n\n");
        this.generateXMLTagForGFRN();
        return this.buffer.toString();
    }

    private void generateXMLTagForGFRN() {
        this.buffer.append("<");
        this.buffer.append(STRUCTURAL_ANNOTATIONS_TAG);
        this.buffer.append(">\n\n");
        Iterator iter = this.gfrn.iteratorOfResults();
        while (iter.hasNext()) {
            this.generateXMLTagForGFRNAnnotation((GFRNAnnotation)((Object)iter.next()));
        }
        this.buffer.append("</");
        this.buffer.append(STRUCTURAL_ANNOTATIONS_TAG);
        this.buffer.append(">\n");
    }

    private void generateXMLTagForGFRNAnnotation(GFRNAnnotation annotation) {
        this.buffer.append("  <");
        this.buffer.append(STRUCTURAL_ANNOTATION_TAG);
        this.buffer.append(" ");
        this.buffer.append(NAME_ATTRIBUTE);
        this.buffer.append("=\"");
        this.buffer.append(annotation.getName());
        this.buffer.append("\">\n");
        Iterator iter = annotation.entriesOfBoundObjects();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!(entry.getValue() instanceof UMLClass) && !(entry.getValue() instanceof UMLMethod)) continue;
            this.generateXMLTagForBinding((String)entry.getKey(), (FElement)entry.getValue());
        }
        this.buffer.append("  </");
        this.buffer.append(STRUCTURAL_ANNOTATION_TAG);
        this.buffer.append(">\n\n");
    }

    private void generateXMLTagForBinding(String key, FElement value) {
        this.buffer.append("    <");
        this.buffer.append(BOUND_OBJECT_TAG);
        this.buffer.append(" ");
        this.buffer.append(KEY_ATTRIBUTE);
        this.buffer.append("=\"");
        this.buffer.append(key);
        this.buffer.append("\" ");
        this.buffer.append(NAME_ATTRIBUTE);
        this.buffer.append("=\"");
        if (value instanceof UMLClass) {
            UMLClass umlClass = (UMLClass)value;
            this.buffer.append(umlClass.getFullClassName());
        } else if (value instanceof UMLMethod) {
            this.appendUMLMethodSignature((UMLMethod)value);
        }
        this.buffer.append("\"/>\n");
    }

    private void appendUMLMethodSignature(UMLMethod method) {
        this.buffer.append(method.getName());
        this.buffer.append("(");
        Iterator iter = method.iteratorOfParam();
        while (iter.hasNext()) {
            UMLParam umlParam = (UMLParam)iter.next();
            UMLType paramType = umlParam.getParamType();
            String paramTypeName = paramType instanceof UMLBaseTypes ? ((UMLBaseTypes)paramType).getProgLangType() : this.getParamTypeName(paramType).toString();
            this.buffer.append(paramTypeName);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    private StringBuffer getParamTypeName(UMLType paramType) {
        StringBuffer paramTypeName = new StringBuffer();
        if (paramType instanceof UMLClass) {
            UMLClass umlClass = (UMLClass)paramType;
            paramTypeName.append(umlClass.getFullClassName());
        } else if (paramType instanceof UMLArray) {
            UMLArray umlArray = (UMLArray)paramType;
            paramTypeName.append(umlArray.getArrayType());
            paramTypeName.append("[]");
        } else {
            paramTypeName.append(paramType.getName());
        }
        return paramTypeName;
    }
}

