/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn.strategies;

import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.GFRNEdge;
import de.upb.inferenceengine.gfrn.ImplToPredEdge;
import de.upb.inferenceengine.gfrn.PredToImplEdge;
import de.upb.inferenceengine.gfrn.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class RuleRankDeterminationStrategy {
    public void calculateAndSetRuleRanks(GFRN gfrn) {
        HashMap nodes = this.createDependencyGraphForRuleRankCalculation(gfrn);
        this.calculateAndSetRuleRanksUsingDependencyGraph(nodes);
    }

    private void calculateAndSetRuleRanksUsingDependencyGraph(HashMap graphNodes) {
        Iterator nodeIter = graphNodes.values().iterator();
        while (nodeIter.hasNext()) {
            Node node = (Node)nodeIter.next();
            if (!node.getSuccessors().isEmpty()) continue;
            node.calculateRank();
        }
    }

    private HashMap createDependencyGraphForRuleRankCalculation(GFRN gfrn) {
        GFRNEdge edge2;
        GFRNEdge edge1;
        Node node;
        Predicate rule;
        HashMap<Predicate, Node> nodes = new HashMap<Predicate, Node>();
        Iterator iter = gfrn.iteratorOfPredicates();
        while (iter.hasNext()) {
            rule = (Predicate)iter.next();
            node = new Node(rule);
            nodes.put(rule, node);
        }
        iter = gfrn.iteratorOfPredicates();
        while (iter.hasNext()) {
            rule = (Predicate)iter.next();
            node = (Node)nodes.get(rule);
            Iterator consequentEdgesIter1 = rule.iteratorOfConsequentEdges();
            while (consequentEdgesIter1.hasNext()) {
                edge1 = (PredToImplEdge)consequentEdgesIter1.next();
                Iterator consequentEdgesIter2 = ((PredToImplEdge)edge1).getImplication().iteratorOfConsequentEdges();
                while (consequentEdgesIter2.hasNext()) {
                    edge2 = (ImplToPredEdge)consequentEdgesIter2.next();
                    Predicate consequentRule = ((ImplToPredEdge)edge2).getPredicate();
                    Node consequentNode = (Node)nodes.get(consequentRule);
                    node.addToSuccessors(consequentNode);
                }
            }
        }
        iter = gfrn.iteratorOfPredicates();
        while (iter.hasNext()) {
            rule = (Predicate)iter.next();
            node = (Node)nodes.get(rule);
            Iterator antecedentEdgesIter1 = rule.iteratorOfAntecedentEdges();
            while (antecedentEdgesIter1.hasNext()) {
                edge1 = (ImplToPredEdge)antecedentEdgesIter1.next();
                Iterator antecedentEdgesIter2 = ((ImplToPredEdge)edge1).getImplication().iteratorOfAntecedentEdges();
                while (antecedentEdgesIter2.hasNext()) {
                    edge2 = (PredToImplEdge)antecedentEdgesIter2.next();
                    Predicate antecedentRule = ((PredToImplEdge)edge2).getPredicate();
                    this.createAdditionalEdgesForEachSpecialization(nodes, node, antecedentRule);
                }
            }
        }
        return nodes;
    }

    private void createAdditionalEdgesForEachSpecialization(HashMap nodes, Node successorNode, Predicate ruleWithSpecializations) {
        Iterator specializationIter = ruleWithSpecializations.iteratorOfSpecializations();
        while (specializationIter.hasNext()) {
            Predicate specialization = (Predicate)specializationIter.next();
            Node specializationNode = (Node)nodes.get(specialization);
            if (specializationNode != successorNode) {
                specializationNode.addToSuccessors(successorNode);
            }
            this.createAdditionalEdgesForEachSpecialization(nodes, successorNode, specialization);
        }
    }

    private class Node {
        private ArrayList predeccessors = null;
        private ArrayList successors = null;
        private Predicate rule;

        public Node(Predicate rule) {
            if (rule == null) {
                throw new NullPointerException("Rule must not be null.");
            }
            this.rule = rule;
        }

        public Predicate getRule() {
            return this.rule;
        }

        private ArrayList getPredeccessors() {
            if (this.predeccessors == null) {
                this.predeccessors = new ArrayList();
            }
            return this.predeccessors;
        }

        ArrayList getSuccessors() {
            if (this.successors == null) {
                this.successors = new ArrayList();
            }
            return this.successors;
        }

        public void addToPredeccessors(Node node) {
            this.getPredeccessors().add(node);
            if (!node.hasInSuccessors(this)) {
                node.addToSuccessors(this);
            }
        }

        public void addToSuccessors(Node node) {
            this.getSuccessors().add(node);
            if (!node.hasInPredeccessors(this)) {
                node.addToPredeccessors(this);
            }
        }

        public boolean hasInPredeccessors(Node node) {
            if (this.predeccessors == null) {
                return false;
            }
            return this.getPredeccessors().contains(node);
        }

        public boolean hasInSuccessors(Node node) {
            if (this.successors == null) {
                return false;
            }
            return this.getSuccessors().contains(node);
        }

        public Iterator iteratorOfPredeccessors() {
            return this.getPredeccessors().iterator();
        }

        public Iterator iteratorOfSuccessors() {
            return this.getSuccessors().iterator();
        }

        public int calculateRank() {
            if (this.getRule().isAxiom()) {
                this.getRule().setRank(-1);
            } else if (this.getPredeccessors().isEmpty()) {
                this.getRule().setRank(0);
            } else {
                int max = 0;
                Iterator nodeIter = this.getPredeccessors().iterator();
                while (nodeIter.hasNext()) {
                    Node predNode = (Node)nodeIter.next();
                    int rank = predNode.calculateRank();
                    if (rank <= max) continue;
                    max = rank;
                }
                this.getRule().setRank(max + 1);
            }
            return this.getRule().getRank();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.valueOf(this.getRule().getName()) + ", rank=" + this.getRule().getRank() + ", successors: (");
            Iterator iter = this.iteratorOfSuccessors();
            while (iter.hasNext()) {
                Node successor = (Node)iter.next();
                buffer.append(successor.getRule().getName());
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

