/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn.strategies;

import de.upb.inferenceengine.gfrn.strategies.ContextRulePair;
import de.upb.inferenceengine.gfrn.strategies.ContextRulePairList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class PriorityQueue {
    private TreeMap sortedListEntries;
    private int highestAvailableRank = Integer.MIN_VALUE;
    private int lowestAvailableRank = Integer.MAX_VALUE;
    private int elementCount = 0;
    private boolean dequeueHighestFirst = true;

    public PriorityQueue(boolean dequeueHighestFirst) {
        this.dequeueHighestFirst = dequeueHighestFirst;
        this.sortedListEntries = new TreeMap();
    }

    public void enqueue(ContextRulePair pair) {
        Integer rank = new Integer(pair.getRule().getRank());
        ContextRulePairList list = (ContextRulePairList)this.sortedListEntries.get(rank);
        if (list == null) {
            list = new ContextRulePairList();
            this.sortedListEntries.put(rank, list);
        }
        if (!list.contains(pair)) {
            list.add(pair);
            ++this.elementCount;
            if (rank > this.highestAvailableRank) {
                this.highestAvailableRank = rank;
            }
            if (rank < this.lowestAvailableRank) {
                this.lowestAvailableRank = rank;
            }
        }
    }

    public ContextRulePair dequeue() {
        if (this.elementCount == 0) {
            return null;
        }
        ContextRulePairList list = null;
        list = this.dequeueHighestFirst ? (ContextRulePairList)this.sortedListEntries.get(new Integer(this.highestAvailableRank)) : (ContextRulePairList)this.sortedListEntries.get(new Integer(this.lowestAvailableRank));
        ContextRulePair contextRulePair = list.getFirst();
        list.remove(contextRulePair);
        --this.elementCount;
        if (list.isEmpty()) {
            this.findAndSetTheHighestAndLowestAvailableRanks();
        }
        return contextRulePair;
    }

    public boolean contains(ContextRulePair pair) {
        Integer rank = new Integer(pair.getRule().getRank());
        ContextRulePairList list = (ContextRulePairList)this.sortedListEntries.get(rank);
        return list != null && list.contains(pair);
    }

    private void findAndSetTheHighestAndLowestAvailableRanks() {
        this.highestAvailableRank = Integer.MIN_VALUE;
        this.lowestAvailableRank = Integer.MAX_VALUE;
        if (this.elementCount > 0) {
            ContextRulePairList list;
            Integer rank;
            Set ranks = this.sortedListEntries.keySet();
            Iterator rankIter = ranks.iterator();
            ArrayList rankList = new ArrayList(ranks.size());
            while (rankIter.hasNext()) {
                rankList.add(rankIter.next());
            }
            Collections.sort(rankList);
            int i = 0;
            while (i < rankList.size()) {
                rank = (Integer)rankList.get(i);
                list = (ContextRulePairList)this.sortedListEntries.get(rank);
                if (!list.isEmpty()) {
                    this.lowestAvailableRank = rank;
                    break;
                }
                ++i;
            }
            i = rankList.size() - 1;
            while (i >= 0) {
                rank = (Integer)rankList.get(i);
                list = (ContextRulePairList)this.sortedListEntries.get(rank);
                if (!list.isEmpty()) {
                    this.highestAvailableRank = rank;
                    break;
                }
                --i;
            }
        }
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int getHighestRank() {
        return this.highestAvailableRank;
    }

    public int getLowestRank() {
        return this.lowestAvailableRank;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public void clear() {
        this.sortedListEntries.clear();
        this.highestAvailableRank = Integer.MIN_VALUE;
        this.lowestAvailableRank = Integer.MAX_VALUE;
        this.elementCount = 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{ }";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("{ ");
        Set keys = this.sortedListEntries.keySet();
        Object[] ranks = (Integer[])keys.toArray();
        Arrays.sort(ranks);
        int i = 0;
        while (i < ranks.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("[");
            buffer.append((Integer)ranks[i]);
            buffer.append(": ");
            ContextRulePairList list = (ContextRulePairList)this.sortedListEntries.get(ranks[i]);
            buffer.append(list.toString());
            buffer.append("]");
            ++i;
        }
        buffer.append(" }");
        return null;
    }
}

