/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.fpn;

import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.FPNEdge;
import de.upb.inferenceengine.fpn.PlaceToTransitionEdge;
import de.upb.inferenceengine.fpn.Transition;
import de.upb.inferenceengine.fpn.TransitionToPlaceEdge;
import de.upb.inferenceengine.gfrn.ImplToPredEdge;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.inferenceengine.gfrn.Predicate;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;

public class Place {
    private int posBelief;
    private int negBelief;
    private boolean userDefined = false;
    private int userBelief = -1;
    private FHashSet antecedentEdges;
    private FHashSet consequentEdges;
    private FPN fpn;
    private Predicate predicate;
    private transient GFRNAnnotation annotation;

    public Place() {
        this.setPosBelief(0);
        this.setNegBelief(0);
    }

    public Place(int posBelief, int negBelief) {
        this.setPosBelief(posBelief);
        this.setNegBelief(negBelief);
    }

    public String getName() {
        return this.getAnnotation().getName();
    }

    public int getCalPosBelief() {
        return this.posBelief;
    }

    public int getPosBelief() {
        int result = this.isUserDefined() ? this.getUserBelief() : this.posBelief;
        return result;
    }

    public int setPosBelief(int posBelief) {
        if (this.posBelief != posBelief) {
            this.posBelief = posBelief;
        }
        return this.posBelief;
    }

    public int getNegBelief() {
        return this.negBelief;
    }

    public int setNegBelief(int negBelief) {
        if (this.negBelief != negBelief) {
            this.negBelief = negBelief;
        }
        return this.negBelief;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public int getUserBelief() {
        return this.userBelief;
    }

    public int setUserBelief(int userBelief) {
        if (this.userBelief != userBelief) {
            this.userBelief = userBelief;
            if (userBelief < 0) {
                this.setUserDefined(false);
            } else {
                this.setUserDefined(true);
            }
        }
        return this.userBelief;
    }

    public void initialize() {
        if (this.sizeOfAntecedentEdges() != 0) {
            this.setPosBelief(0);
            this.setNegBelief(0);
        } else {
            Predicate predicate = this.getPredicate();
            Iterator iter = predicate.iteratorOfAntecedentEdges();
            if (iter.hasNext()) {
                ImplToPredEdge implToPredEdge = (ImplToPredEdge)iter.next();
                Implication implication = implToPredEdge.getImplication();
                if (implToPredEdge.isPositive()) {
                    this.setPosBelief(implication.getConfidence());
                    this.setNegBelief(0);
                } else {
                    this.setPosBelief(0);
                    this.setNegBelief(implication.getConfidence());
                }
            }
        }
    }

    public boolean calculateFBMarkings() {
        boolean changed = false;
        if (this.sizeOfAntecedentEdges() != 0) {
            int posMaximum = Integer.MIN_VALUE;
            int negMaximum = Integer.MIN_VALUE;
            Iterator iter = this.iteratorOfAntecedentEdges();
            while (iter.hasNext()) {
                FPNEdge edge = (FPNEdge)iter.next();
                Transition transition = edge.getTransition();
                if (edge.isPositive()) {
                    posMaximum = Math.max(posMaximum, transition.getFuzzyTruthToken());
                    continue;
                }
                negMaximum = Math.max(negMaximum, transition.getFuzzyTruthToken());
            }
            if (posMaximum != Integer.MIN_VALUE && posMaximum != this.getCalPosBelief()) {
                this.setPosBelief(posMaximum);
                changed = true;
            }
            if (negMaximum != Integer.MIN_VALUE && negMaximum != this.getNegBelief()) {
                this.setNegBelief(negMaximum);
                changed = true;
            }
        }
        return changed;
    }

    void writeResultsToAnnotations() {
        GFRNAnnotation gfrnAnnotation = this.getAnnotation();
        gfrnAnnotation.setPosBelief(this.getPosBelief());
        gfrnAnnotation.setNegBelief(this.getNegBelief());
    }

    public boolean hasInAntecedentEdges(TransitionToPlaceEdge value) {
        return this.antecedentEdges != null && value != null && this.antecedentEdges.contains((Object)value);
    }

    public Iterator iteratorOfAntecedentEdges() {
        return this.antecedentEdges == null ? FEmptyIterator.get() : this.antecedentEdges.iterator();
    }

    public int sizeOfAntecedentEdges() {
        return this.antecedentEdges == null ? 0 : this.antecedentEdges.size();
    }

    public boolean addToAntecedentEdges(TransitionToPlaceEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.antecedentEdges == null) {
                this.antecedentEdges = new FHashSet();
            }
            if (changed = this.antecedentEdges.add((Object)value)) {
                value.setPlace(this);
            }
        }
        return changed;
    }

    public boolean removeFromAntecedentEdges(TransitionToPlaceEdge value) {
        boolean changed = false;
        if (this.antecedentEdges != null && value != null && (changed = this.antecedentEdges.remove((Object)value))) {
            value.setPlace(null);
        }
        return changed;
    }

    public void removeAllFromAntecedentEdges() {
        Iterator iter = this.iteratorOfAntecedentEdges();
        while (iter.hasNext()) {
            TransitionToPlaceEdge tmpValue = (TransitionToPlaceEdge)iter.next();
            this.removeFromAntecedentEdges(tmpValue);
        }
    }

    public boolean hasInConsequentEdges(PlaceToTransitionEdge value) {
        return this.consequentEdges != null && value != null && this.consequentEdges.contains((Object)value);
    }

    public Iterator iteratorOfConsequentEdges() {
        return this.consequentEdges == null ? FEmptyIterator.get() : this.consequentEdges.iterator();
    }

    public int sizeOfConsequentEdges() {
        return this.consequentEdges == null ? 0 : this.consequentEdges.size();
    }

    public boolean addToConsequentEdges(PlaceToTransitionEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.consequentEdges == null) {
                this.consequentEdges = new FHashSet();
            }
            if (changed = this.consequentEdges.add((Object)value)) {
                value.setPlace(this);
            }
        }
        return changed;
    }

    public boolean removeFromConsequentEdges(PlaceToTransitionEdge value) {
        boolean changed = false;
        if (this.consequentEdges != null && value != null && (changed = this.consequentEdges.remove((Object)value))) {
            value.setPlace(null);
        }
        return changed;
    }

    public void removeAllFromConsequentEdges() {
        Iterator iter = this.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            PlaceToTransitionEdge tmpValue = (PlaceToTransitionEdge)iter.next();
            this.removeFromConsequentEdges(tmpValue);
        }
    }

    public boolean setFpn(FPN value) {
        boolean changed = false;
        if (this.fpn != value) {
            if (this.fpn != null) {
                FPN oldValue = this.fpn;
                this.fpn = null;
                oldValue.removeFromPlaces(this);
            }
            this.fpn = value;
            if (value != null) {
                value.addToPlaces(this);
            }
            changed = true;
        }
        return changed;
    }

    public FPN getFpn() {
        return this.fpn;
    }

    public boolean setPredicate(Predicate value) {
        boolean changed = false;
        if (this.predicate != value) {
            if (this.predicate != null) {
                Predicate oldValue = this.predicate;
                this.predicate = null;
                oldValue.removeFromPlaces(this);
            }
            this.predicate = value;
            if (value != null) {
                value.addToPlaces(this);
            }
            changed = true;
        }
        return changed;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean setAnnotation(GFRNAnnotation value) {
        if (this.annotation != value) {
            if (this.annotation != null) {
                GFRNAnnotation oldValue = this.annotation;
                this.annotation = null;
                oldValue.setPlace(null);
            }
            this.annotation = value;
            if (value != null) {
                this.annotation.setPlace(this);
            }
            return true;
        }
        return false;
    }

    public GFRNAnnotation getAnnotation() {
        return this.annotation;
    }

    public void removeYou() {
        FPNEdge edge;
        Iterator iter = this.iteratorOfAntecedentEdges();
        while (iter.hasNext()) {
            edge = (TransitionToPlaceEdge)iter.next();
            ((TransitionToPlaceEdge)edge).removeYou();
        }
        iter = this.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            edge = (PlaceToTransitionEdge)iter.next();
            ((PlaceToTransitionEdge)edge).removeYou();
        }
        this.setFpn(null);
        this.setPredicate(null);
        GFRNAnnotation annotation = this.getAnnotation();
        if (annotation != null) {
            annotation.removeYou();
        }
    }
}

