/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.fpn;

import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.fpn.FPNEdge;
import de.upb.inferenceengine.fpn.FTTStrategy;
import de.upb.inferenceengine.fpn.FTTStrategyHeitbreder;
import de.upb.inferenceengine.fpn.FTTStrategyJahnke;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.fpn.PlaceToTransitionEdge;
import de.upb.inferenceengine.fpn.Transition;
import de.upb.inferenceengine.fpn.TransitionToPlaceEdge;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;

public class FPN {
    private RuleCatalog catalog;
    private FHashSet places;
    private FHashSet transitions;
    private FTTStrategy fttStrategy;

    public void evaluate() {
        boolean changed = true;
        switch (InferenceEnginePreferences.get().getFTTStrategy()) {
            case 0: {
                this.setFttStrategy(new FTTStrategyJahnke());
                break;
            }
            case 1: {
                this.setFttStrategy(new FTTStrategyHeitbreder());
                break;
            }
            default: {
                this.setFttStrategy(new FTTStrategyJahnke());
            }
        }
        Iterator iter = this.iteratorOfPlaces();
        while (iter.hasNext()) {
            Place place = (Place)iter.next();
            place.initialize();
        }
        int counter = 1;
        while (changed) {
            changed = false;
            iter = this.iteratorOfTransitions();
            while (iter.hasNext()) {
                Transition transition = (Transition)iter.next();
                transition.calculateFTT();
            }
            iter = this.iteratorOfPlaces();
            while (iter.hasNext()) {
                Place place = (Place)iter.next();
                boolean placeChanged = place.calculateFBMarkings();
                boolean bl = changed = changed || placeChanged;
            }
            ++counter;
        }
        this.writeResultsToAnnotations();
    }

    private void writeResultsToAnnotations() {
        Iterator iter = this.iteratorOfPlaces();
        while (iter.hasNext()) {
            Place place = (Place)iter.next();
            place.writeResultsToAnnotations();
        }
    }

    public Place createPlace(int posFuzzyBelief, int negFuzzyBelief) {
        Place place = new Place(posFuzzyBelief, negFuzzyBelief);
        this.addToPlaces(place);
        return place;
    }

    public Transition createTransition(int confidence) {
        Transition transition = new Transition(confidence);
        this.addToTransitions(transition);
        return transition;
    }

    public FPNEdge createEdge(Place place, Transition transition, boolean positive) {
        PlaceToTransitionEdge edge = null;
        Iterator iter = place.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            PlaceToTransitionEdge currentEdge = (PlaceToTransitionEdge)iter.next();
            if (currentEdge.getTransition() != transition) continue;
            edge = currentEdge;
        }
        if (edge == null) {
            edge = new PlaceToTransitionEdge(place, transition, positive);
        }
        return edge;
    }

    public FPNEdge createEdge(Transition transition, Place place, boolean positive) {
        TransitionToPlaceEdge edge = null;
        Iterator iter = transition.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            TransitionToPlaceEdge currentEdge = (TransitionToPlaceEdge)iter.next();
            if (currentEdge.getPlace() != place) continue;
            edge = currentEdge;
        }
        if (edge == null) {
            edge = new TransitionToPlaceEdge(transition, place, positive);
        }
        return edge;
    }

    public RuleCatalog getCatalog() {
        return this.catalog;
    }

    public boolean setCatalog(RuleCatalog value) {
        boolean changed = false;
        if (this.catalog != value) {
            if (this.catalog != null) {
                RuleCatalog oldValue = this.catalog;
                this.catalog = null;
                oldValue.setFpn(null);
            }
            this.catalog = value;
            if (value != null) {
                value.setFpn(this);
            }
            changed = true;
        }
        return changed;
    }

    public boolean hasInPlaces(Place value) {
        return this.places != null && value != null && this.places.contains((Object)value);
    }

    public Iterator iteratorOfPlaces() {
        return this.places == null ? FEmptyIterator.get() : this.places.iterator();
    }

    public int sizeOfPlaces() {
        return this.places == null ? 0 : this.places.size();
    }

    public boolean addToPlaces(Place value) {
        boolean changed = false;
        if (value != null) {
            if (this.places == null) {
                this.places = new FHashSet();
            }
            if (changed = this.places.add((Object)value)) {
                value.setFpn(this);
            }
        }
        return changed;
    }

    public boolean removeFromPlaces(Place value) {
        boolean changed = false;
        if (this.places != null && value != null && (changed = this.places.remove((Object)value))) {
            value.setFpn(null);
        }
        return changed;
    }

    public void removeAllFromPlaces() {
        Iterator iter = this.iteratorOfPlaces();
        while (iter.hasNext()) {
            Place tmpValue = (Place)iter.next();
            this.removeFromPlaces(tmpValue);
        }
    }

    public boolean hasInTransitions(Transition value) {
        return this.transitions != null && value != null && this.transitions.contains((Object)value);
    }

    public Iterator iteratorOfTransitions() {
        return this.transitions == null ? FEmptyIterator.get() : this.transitions.iterator();
    }

    public int sizeOfTransitions() {
        return this.transitions == null ? 0 : this.transitions.size();
    }

    public boolean addToTransitions(Transition value) {
        boolean changed = false;
        if (value != null) {
            if (this.transitions == null) {
                this.transitions = new FHashSet();
            }
            if (changed = this.transitions.add((Object)value)) {
                value.setFpn(this);
            }
        }
        return changed;
    }

    public boolean removeFromTransitions(Transition value) {
        boolean changed = false;
        if (this.transitions != null && value != null && (changed = this.transitions.remove((Object)value))) {
            value.setFpn(null);
        }
        return changed;
    }

    public void removeAllFromTransitions() {
        Iterator iter = this.iteratorOfTransitions();
        while (iter.hasNext()) {
            Transition tmpValue = (Transition)iter.next();
            this.removeFromTransitions(tmpValue);
        }
    }

    public boolean setFttStrategy(FTTStrategy value) {
        boolean changed = false;
        if (this.fttStrategy != value) {
            if (this.fttStrategy != null) {
                FTTStrategy oldValue = this.fttStrategy;
                this.fttStrategy = null;
                oldValue.setFpn(null);
            }
            this.fttStrategy = value;
            if (value != null) {
                value.setFpn(this);
            }
            changed = true;
        }
        return changed;
    }

    public FTTStrategy getFttStrategy() {
        return this.fttStrategy;
    }

    public void removeYou() {
        FTTStrategy tmpFttStrategy;
        Iterator iter = this.iteratorOfPlaces();
        while (iter.hasNext()) {
            Place place = (Place)iter.next();
            place.removeYou();
        }
        iter = this.iteratorOfTransitions();
        while (iter.hasNext()) {
            Transition transition = (Transition)iter.next();
            transition.removeYou();
        }
        RuleCatalog tmpCatalog = this.getCatalog();
        if (tmpCatalog != null) {
            this.setCatalog(null);
        }
        if ((tmpFttStrategy = this.getFttStrategy()) != null) {
            this.setFttStrategy(null);
        }
    }
}

