/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.statistics.StatisticRecord;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class GFRNEngine {
    private RuleCatalog catalog;
    private FHashMap failedApplications;
    private String name;
    private FHashSet statisticRecords;

    public RuleCatalog getCatalog() {
        return this.catalog;
    }

    public boolean setCatalog(RuleCatalog value) {
        boolean changed = false;
        if (this.catalog != value) {
            if (this.catalog != null) {
                RuleCatalog oldValue = this.catalog;
                this.catalog = null;
                oldValue.removeFromEngines(this);
            }
            this.catalog = value;
            if (value != null) {
                value.addToEngines(this);
            }
            changed = true;
        }
        return changed;
    }

    public boolean addToFailedApplications(Map.Entry entry) {
        return this.addToFailedApplications((String)entry.getKey(), (ASGElement)entry.getValue());
    }

    public boolean addToFailedApplications(String key, ASGElement value) {
        boolean changed = false;
        if (value != null && key != null) {
            ASGElement oldValue;
            if (this.failedApplications == null) {
                this.failedApplications = new FHashMap();
            }
            if ((oldValue = (ASGElement)this.failedApplications.put((Object)key, (Object)value)) != value) {
                changed = true;
            }
        }
        return changed;
    }

    public Iterator entriesOfFailedApplications() {
        return this.failedApplications == null ? FEmptyIterator.get() : this.failedApplications.entrySet().iterator();
    }

    public ASGElement getFromFailedApplications(String key) {
        return this.failedApplications == null || key == null ? null : (ASGElement)this.failedApplications.get((Object)key);
    }

    public boolean hasInFailedApplications(ASGElement value) {
        return this.failedApplications != null && value != null && this.failedApplications.containsValue((Object)value);
    }

    public boolean hasInFailedApplications(String key, ASGElement value) {
        return this.failedApplications != null && value != null && key != null && this.failedApplications.get((Object)key) == value;
    }

    public boolean hasKeyInFailedApplications(String key) {
        return this.failedApplications != null && key != null && this.failedApplications.containsKey((Object)key);
    }

    public Iterator iteratorOfFailedApplications() {
        return this.failedApplications == null ? FEmptyIterator.get() : this.failedApplications.values().iterator();
    }

    public Iterator keysOfFailedApplications() {
        return this.failedApplications == null ? FEmptyIterator.get() : this.failedApplications.keySet().iterator();
    }

    public void removeAllFromFailedApplications() {
        Iterator iter = this.entriesOfFailedApplications();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.removeFromFailedApplications((String)entry.getKey(), (ASGElement)entry.getValue());
        }
    }

    public boolean removeFromFailedApplications(ASGElement value) {
        boolean changed = false;
        if (this.failedApplications != null && value != null) {
            Iterator iter = this.entriesOfFailedApplications();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value) continue;
                boolean bl = changed = this.removeFromFailedApplications((String)entry.getKey(), value) || changed;
            }
        }
        return changed;
    }

    public boolean removeFromFailedApplications(String key, ASGElement value) {
        ASGElement oldValue;
        boolean changed = false;
        if (this.failedApplications != null && value != null && key != null && (oldValue = (ASGElement)this.failedApplications.get((Object)key)) == value) {
            this.failedApplications.remove((Object)key);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromFailedApplications(String key) {
        ASGElement tmpValue;
        boolean changed = false;
        if (this.failedApplications != null && key != null && (tmpValue = (ASGElement)this.failedApplications.get((Object)key)) != null) {
            this.failedApplications.remove((Object)key);
            changed = true;
        }
        return changed;
    }

    public int sizeOfFailedApplications() {
        return this.failedApplications == null ? 0 : this.failedApplications.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean addToStatisticRecords(StatisticRecord value) {
        boolean changed = false;
        if (value != null) {
            if (this.statisticRecords == null) {
                this.statisticRecords = new FHashSet();
            }
            if (changed = this.statisticRecords.add((Object)value)) {
                value.setEngine(this);
            }
        }
        return changed;
    }

    public boolean hasInStatisticRecords(StatisticRecord value) {
        return this.statisticRecords != null && value != null && this.statisticRecords.contains((Object)value);
    }

    public Iterator iteratorOfStatisticRecords() {
        return this.statisticRecords == null ? FEmptyIterator.get() : this.statisticRecords.iterator();
    }

    public void removeAllFromStatisticRecords() {
        Iterator iter = this.iteratorOfStatisticRecords();
        while (iter.hasNext()) {
            StatisticRecord tmpValue = (StatisticRecord)iter.next();
            this.removeFromStatisticRecords(tmpValue);
        }
    }

    public boolean removeFromStatisticRecords(StatisticRecord value) {
        boolean changed = false;
        if (this.statisticRecords != null && value != null && (changed = this.statisticRecords.remove((Object)value))) {
            value.setEngine(null);
        }
        return changed;
    }

    public int sizeOfStatisticRecords() {
        return this.statisticRecords == null ? 0 : this.statisticRecords.size();
    }

    public abstract GFRNAnnotation annotate(ASGElement var1);

    public abstract boolean applicationAlreadyFailed(ASGElement var1);

    public abstract Iterator getTrigger(ASGElement var1, String var2);

    public String getUniqueName() {
        return String.valueOf(this.getCatalog().getName()) + ":" + this.getName();
    }

    public void removeYou() {
        this.removeAllFromFailedApplications();
        RuleCatalog tmpCatalog = this.getCatalog();
        if (tmpCatalog != null) {
            this.setCatalog(null);
        }
    }
}

