/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.dialogs;

import de.upb.inferenceengine.IProgressDialog;
import de.upb.inferenceengine.InferenceEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProgressDialog
extends JDialog
implements Runnable,
IProgressDialog {
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JProgressBar progressBar;
    JButton pauseButton;
    private JButton abortButton;
    private JButton closeButton;
    boolean halted = false;
    boolean aborted = false;
    private boolean done = false;
    private int progress = 0;

    public ProgressDialog() {
        this.setTitle("Pattern Recognition Inference");
        this.setModal(false);
        GridBagLayout gridBag = new GridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(gridBag);
        this.textArea = new JTextArea(20, 50);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        GridBagConstraints constraints = new GridBagConstraints(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 0, 8), 0, 0);
        gridBag.setConstraints(this.scrollPane, constraints);
        progressPanel.add(this.scrollPane);
        this.progressBar = new JProgressBar();
        this.progressBar.setValue(this.progress);
        this.progressBar.setStringPainted(true);
        constraints = new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0);
        gridBag.setConstraints(this.progressBar, constraints);
        progressPanel.add(this.progressBar);
        panel.add((Component)progressPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new PauseButtonListener());
        buttonPanel.add(this.pauseButton);
        this.abortButton = new JButton("Abort");
        this.abortButton.addActionListener(new AbortButtonListener());
        buttonPanel.add(this.abortButton);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new CloseButtonListener());
        this.closeButton.setEnabled(false);
        buttonPanel.add(this.closeButton);
        panel.add((Component)buttonPanel, "South");
        this.getContentPane().add(panel);
        this.pack();
        this.centerDialog();
    }

    public void init() {
        this.progress = 0;
        this.textArea.setText(null);
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(0);
        Thread progressDialogThread = new Thread(this);
        progressDialogThread.start();
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        int y = (screenSize.height - size.height) / 2;
        int x = (screenSize.width - size.width) / 2;
        this.setLocation(x, y);
    }

    public void run() {
        this.pauseButton.setEnabled(true);
        this.abortButton.setEnabled(true);
        this.closeButton.setEnabled(false);
        this.setVisible(true);
        while (!this.aborted && !this.done) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.pauseButton.setEnabled(false);
        this.abortButton.setEnabled(false);
        this.closeButton.setEnabled(true);
    }

    public synchronized void allDone() {
        this.done = true;
    }

    public synchronized void suspended() {
        this.appendToOutput("Inference suspended...");
    }

    public synchronized void setText(String text) {
        this.progressBar.setString(text);
    }

    public synchronized void appendToOutput(String text) {
        this.textArea.append(text);
        JScrollBar adjustable = this.scrollPane.getVerticalScrollBar();
        adjustable.setValue(adjustable.getMaximum());
    }

    public synchronized void setMaximum(int maximum) {
        this.progressBar.setMaximum(maximum);
    }

    public int getProgress() {
        return this.progress;
    }

    public synchronized void increment() {
        ++this.progress;
        this.progressBar.setValue(this.progress);
        int percentDone = this.progress * 100 / this.progressBar.getMaximum();
        this.progressBar.setString(String.valueOf(percentDone) + "% (" + this.progress + "/" + this.progressBar.getMaximum() + ")");
    }

    private class PauseButtonListener
    implements ActionListener {
        PauseButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProgressDialog.this.halted) {
                InferenceEngine.setHalted(false);
                ProgressDialog.this.halted = false;
                ProgressDialog.this.pauseButton.setText("Suspend");
            } else {
                InferenceEngine.setHalted(true);
                ProgressDialog.this.halted = true;
                ProgressDialog.this.pauseButton.setText("Resume");
            }
        }
    }

    private class AbortButtonListener
    implements ActionListener {
        AbortButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            InferenceEngine.abort();
            ProgressDialog.this.aborted = true;
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        CloseButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ProgressDialog.this.setVisible(false);
        }
    }
}

