/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.dialogs;

import de.uni_paderborn.fujaba.gui.AbstractDialog;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.fpn.Place;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class EditBeliefDialog
extends AbstractDialog {
    private JTextField posBeliefTextField;
    private JTextField userBeliefTextField;
    GFRNAnnotation gfrnAnnotation;

    public EditBeliefDialog(JFrame frame, GFRNAnnotation gfrnAnnotation) {
        super(frame, true);
        this.setTitle("GFRNAnnotation Editor");
        this.gfrnAnnotation = gfrnAnnotation;
        this.createUserInterface();
        this.initialize();
    }

    protected JPanel createMainPanel() {
        GridBagLayout gridBag = new GridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(gridBag);
        panel.setBorder(new TitledBorder("User Belief"));
        JLabel calcBeliefLabel = new JLabel("Calculated Belief:");
        GridBagConstraints constraints = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 8, 8), 0, 0);
        gridBag.setConstraints(calcBeliefLabel, constraints);
        panel.add(calcBeliefLabel);
        this.posBeliefTextField = new JTextField(3);
        this.posBeliefTextField.setEditable(false);
        constraints = new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 10, 1, new Insets(4, 0, 8, 0), 0, 0);
        gridBag.setConstraints(this.posBeliefTextField, constraints);
        panel.add(this.posBeliefTextField);
        JLabel userBeliefLabel = new JLabel("User Defined Belief:");
        constraints = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 8, 8), 0, 0);
        gridBag.setConstraints(userBeliefLabel, constraints);
        panel.add(userBeliefLabel);
        this.userBeliefTextField = new JTextField(3);
        this.userBeliefTextField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                boolean result = false;
                JTextField textField = (JTextField)input;
                try {
                    int value = Integer.valueOf(textField.getText());
                    result = value >= 0 && value <= 100;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return result;
            }
        });
        constraints = new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 8, 0), 0, 0);
        gridBag.setConstraints(this.userBeliefTextField, constraints);
        panel.add(this.userBeliefTextField);
        return panel;
    }

    protected void unparse() {
        this.posBeliefTextField.setText(String.valueOf(this.gfrnAnnotation.getPlace().getPosBelief()));
        this.userBeliefTextField.setText(String.valueOf(this.gfrnAnnotation.getPlace().getUserBelief()));
    }

    protected void parse() {
        int userBelief;
        try {
            userBelief = Integer.valueOf(this.userBeliefTextField.getText());
        }
        catch (NumberFormatException e) {
            userBelief = this.gfrnAnnotation.getPlace().getUserBelief();
        }
        Place place = this.gfrnAnnotation.getPlace();
        place.setUserBelief(userBelief);
        place.getFpn().evaluate();
        UMLProject.get().refreshDisplay();
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = super.createButtonPanel();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Place place = EditBeliefDialog.this.gfrnAnnotation.getPlace();
                place.setUserBelief(-1);
                place.getFpn().evaluate();
                UMLProject.get().refreshDisplay();
                EditBeliefDialog.this.unparse();
            }
        });
        buttonPanel.add(resetButton);
        this.getRootPane().setDefaultButton(null);
        return buttonPanel;
    }
}

