/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.adaptation;

import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.Place;
import java.util.HashMap;
import java.util.Iterator;

public class FPNDataSet {
    private FPN theNet = null;
    private HashMap data = null;
    public static final int POS_BELIEF = 0;
    public static final int NEG_BELIEF = 1;
    public static final int USER_BELIEF = 2;

    public FPNDataSet(FPN net) {
        this.theNet = net;
        this.data = new HashMap();
        this.backup();
    }

    public Iterator iteratorOfPlaces() {
        return this.data.keySet().iterator();
    }

    public int getValue(Place place, int which) {
        return ((int[])this.data.get(place))[which];
    }

    public void backup() {
        Iterator iter = this.theNet.iteratorOfPlaces();
        while (iter.hasNext()) {
            Place place = (Place)iter.next();
            int[] valueArray = new int[]{place.getCalPosBelief(), place.getNegBelief(), place.getUserBelief()};
            this.data.put(place, valueArray);
        }
    }

    public void restore() {
        Iterator iter = this.data.keySet().iterator();
        while (iter.hasNext()) {
            Place place = (Place)iter.next();
            int[] valueArray = (int[])this.data.get(place);
            place.setPosBelief(valueArray[0]);
            place.setNegBelief(valueArray[1]);
            place.setUserBelief(valueArray[2]);
        }
    }
}

