/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.adaptation;

import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.fpn.PlaceToTransitionEdge;
import de.upb.inferenceengine.fpn.Transition;
import de.upb.inferenceengine.fpn.TransitionToPlaceEdge;
import de.upb.inferenceengine.gfrn.ImplToPredEdge;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.inferenceengine.gfrn.Predicate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class Calculator {
    public static final int RECURSIVE = -1;
    public static final int ALL_PLACES = 0;
    public static final int CHANGED_PLACES = 1;

    public static void adaptNet(FPN net, int numberOfLevels, int averageMode) {
        HashMap changeValues = new HashMap();
        Iterator placeIter = net.iteratorOfPlaces();
        while (placeIter.hasNext()) {
            Place place = (Place)placeIter.next();
            if ((!place.isUserDefined() || averageMode != 1) && averageMode != 0) continue;
            int value = place.isUserDefined() ? place.getUserBelief() : place.getPosBelief();
            Calculator.propagateChangeValue(changeValues, place, value, 1.0, numberOfLevels);
        }
        Calculator.adaptConfidence(changeValues, averageMode);
    }

    private static void propagateChangeValue(HashMap changeValues, Place place, int value, double weight, int numberOfLevels) {
        if (numberOfLevels == 0) {
            return;
        }
        Predicate pred = place.getPredicate();
        double[] weights = (double[])changeValues.get(pred);
        if (weights == null) {
            weights = new double[101];
            changeValues.put(pred, weights);
            Arrays.fill(weights, 0.0);
        }
        weights[value] = weights[value] + weight;
        Iterator transIter = place.iteratorOfAntecedentEdges();
        while (transIter.hasNext()) {
            TransitionToPlaceEdge tpEdge = (TransitionToPlaceEdge)transIter.next();
            Transition transition = tpEdge.getTransition();
            Iterator placeIter = transition.iteratorOfAntecedentEdges();
            while (placeIter.hasNext()) {
                PlaceToTransitionEdge ptEdge = (PlaceToTransitionEdge)placeIter.next();
                Place antPlace = ptEdge.getPlace();
                if (antPlace.isUserDefined()) continue;
                double belief = place.getCalPosBelief();
                double antBelief = antPlace.getCalPosBelief();
                double newWeight = weight * Calculator.maximumLikelihood(-0.2, 25.0, antBelief - belief);
                Calculator.propagateChangeValue(changeValues, antPlace, value, newWeight, numberOfLevels - 1);
            }
        }
    }

    private static double calculateConfidence(double[] values, double initValue, double initWeight) {
        double weightSum = initWeight;
        double result = initValue * weightSum;
        int i = 0;
        while (i < values.length) {
            weightSum += values[i];
            result += (double)i * values[i];
            ++i;
        }
        return result / weightSum;
    }

    private static double maximumLikelihood(double B, double M, double x) {
        return 1.0 / (1.0 + Math.pow(Math.E, -B * (x - M)));
    }

    private static void adaptConfidence(HashMap changeValues, int mode) {
        Iterator predIter = changeValues.keySet().iterator();
        while (predIter.hasNext()) {
            Predicate pred = (Predicate)predIter.next();
            Implication implication = ((ImplToPredEdge)pred.iteratorOfAntecedentEdges().next()).getImplication();
            double[] values = (double[])changeValues.get(pred);
            double confidence = 0.0;
            confidence = mode == 0 ? Calculator.calculateConfidence(values, 0.0, 0.0) : Calculator.calculateConfidence(values, implication.getConfidence(), Math.PI * 2);
            Iterator implIter = pred.iteratorOfAntecedentEdges();
            while (implIter.hasNext()) {
                ImplToPredEdge edge = (ImplToPredEdge)implIter.next();
                Implication impl = edge.getImplication();
                impl.setConfidence((int)Math.round(confidence));
            }
        }
    }
}

