/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.adaptation;

import de.upb.inferenceengine.adaptation.CloseListener;
import de.upb.inferenceengine.adaptation.FPNDataSet;
import de.upb.inferenceengine.adaptation.TableSorter;
import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.Predicate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AdaptationToolkit {
    public static final int ALL_PLACES = 0;
    public static final int ALTERED_PLACES = 1;

    public static JDialog createGFRNSummaryDialog(JFrame frame, GFRN net) {
        String title = "Found Pattern Instances Calculated Belief Statistic";
        String[] columnNames = new String[]{"Rule name", "0%", ">0%-9%", "10%-19%", "20%-29%", "30%-39%", "40%-49%", "50%-59%", "60%-69%", "70%-79%", "80%-89%", "90%-99%", "100%"};
        Object[][] data = AdaptationToolkit.calculateData(net);
        return AdaptationToolkit.createTableDialog(frame, title, columnNames, data);
    }

    public static JDialog createTableDialog(JFrame frame, String title, String[] columnNames, Object[][] data) {
        JDialog dialog = new JDialog(frame);
        dialog.setTitle(title);
        dialog.setDefaultCloseOperation(2);
        JPanel mainJP = new JPanel(new BorderLayout());
        DefaultTableModel tableModel = new DefaultTableModel(data, columnNames);
        TableSorter sorter = new TableSorter(tableModel);
        JTable table = new JTable(sorter);
        sorter.setTableHeader(table.getTableHeader());
        sorter.setSortingStatus(0, 1);
        JScrollPane pane = new JScrollPane(table, 20, 31);
        mainJP.add((Component)pane, "Center");
        JPanel buttonJP = new JPanel(new FlowLayout());
        JButton closeJB = new JButton("Close");
        closeJB.addActionListener(new CloseListener(dialog));
        mainJP.add((Component)buttonJP, "South");
        dialog.setContentPane(mainJP);
        dialog.pack();
        AdaptationToolkit.initColumnSizes(table);
        return dialog;
    }

    private static Object[][] calculateData(GFRN net) {
        int countRows = 0;
        Iterator predIter = net.iteratorOfPredicates();
        while (predIter.hasNext()) {
            Predicate pred = (Predicate)predIter.next();
            if (pred.isAxiom() || pred.isAbstract()) continue;
            ++countRows;
        }
        Object[][] data = new Object[countRows][13];
        int[][] intdata = new int[countRows][12];
        int i = 0;
        while (i < countRows) {
            Arrays.fill(intdata[i], 0);
            ++i;
        }
        int row = 0;
        predIter = net.iteratorOfPredicates();
        while (predIter.hasNext()) {
            Predicate pred = (Predicate)predIter.next();
            if (pred.isAxiom() || pred.isAbstract()) continue;
            data[row][0] = !pred.isTopLevel() ? pred.getName() : String.valueOf(pred.getName()) + "(*)";
            Iterator placeIter = pred.iteratorOfPlaces();
            while (placeIter.hasNext()) {
                Place place = (Place)placeIter.next();
                int posBelief = place.getPosBelief();
                if (posBelief == 0) {
                    int[] nArray = intdata[row];
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                if (posBelief == 100) {
                    int[] nArray = intdata[row];
                    nArray[11] = nArray[11] + 1;
                    continue;
                }
                int[] nArray = intdata[row];
                int n = posBelief / 10 + 1;
                nArray[n] = nArray[n] + 1;
            }
            ++row;
        }
        int i2 = 0;
        while (i2 < countRows) {
            int j = 0;
            while (j < 12) {
                data[i2][j + 1] = new Integer(intdata[i2][j]);
                ++j;
            }
            ++i2;
        }
        return data;
    }

    private static void initColumnSizes(JTable table) {
        TableModel model = table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < model.getColumnCount()) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            int maxCellWidth = 0;
            int j = 0;
            while (j < model.getRowCount()) {
                comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, model.getValueAt(j, i), false, false, 0, i);
                cellWidth = comp.getPreferredSize().width;
                maxCellWidth = Math.max(cellWidth, maxCellWidth);
                ++j;
            }
            column.setMinWidth(Math.max(headerWidth, maxCellWidth));
            ++i;
        }
    }

    public static void alterTopLevelInstances(FPN net, int value) {
        Iterator placeIter = net.iteratorOfPlaces();
        int i = 0;
        while (placeIter.hasNext()) {
            Place place = (Place)placeIter.next();
            if (!place.getPredicate().isTopLevel()) continue;
            place.setUserBelief(value);
            ++i;
        }
    }

    static void resetUserBeliefs(FPN net) {
        Iterator placeIter = net.iteratorOfPlaces();
        while (placeIter.hasNext()) {
            Place place = (Place)placeIter.next();
            place.setUserBelief(-1);
        }
    }

    public static Object[][] calculateMeanSquareError(FPNDataSet original, FPNDataSet adapted, int mode) {
        HashMap<Predicate, double[]> map = new HashMap<Predicate, double[]>();
        Iterator placeIter = adapted.iteratorOfPlaces();
        while (placeIter.hasNext()) {
            Place place = (Place)placeIter.next();
            int adaptedValue = adapted.getValue(place, 0);
            int userValue = original.getValue(place, 2);
            if ((userValue <= -1 || mode != 1) && mode != 0) continue;
            Predicate pred = place.getPredicate();
            double[] values = (double[])map.get(pred);
            if (values == null) {
                values = new double[2];
                map.put(pred, values);
            }
            values[0] = values[0] + Math.pow(adaptedValue - userValue, 2.0);
            values[1] = values[1] + 1.0;
        }
        double overallError = 0.0;
        double overallNumber = 0.0;
        Object[][] result = new Object[map.size() + 1][2];
        int i = 0;
        Iterator predIter = map.keySet().iterator();
        while (predIter.hasNext()) {
            Predicate pred = (Predicate)predIter.next();
            double[] values = (double[])map.get(pred);
            result[i][0] = pred.getName();
            result[i][1] = new Double(Math.sqrt(values[0] / values[1]));
            overallError += values[0];
            overallNumber += values[1];
            ++i;
        }
        overallError = Math.sqrt(overallError / overallNumber);
        result[map.size()][0] = "   Average";
        result[map.size()][1] = new Double(overallError);
        return result;
    }
}

