/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine;

import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.engines.GFRNEngine;
import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.GFRNLoader;
import de.upb.inferenceengine.gfrn.Predicate;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class RuleCatalog {
    private UPBClassLoader classLoader;
    private File catalogFile;
    private FHashMap engines;
    private FPN fpn;
    private GFRN gfrn;
    private InferenceEngine inferenceEngine;
    private String name;
    private boolean initialized = false;
    private HashMap axiomClasses;

    public RuleCatalog(File catalogJarFile, UPBClassLoader parentClassLoader) {
        if (!catalogJarFile.exists()) {
            throw new IllegalArgumentException("Rule catalog doesn't exist!");
        }
        this.catalogFile = catalogJarFile;
        this.setName(catalogJarFile.getName());
        this.classLoader = UPBClassLoader.get((String)("RuleCatalog:" + this.getName()));
        this.classLoader.addClassPath(catalogJarFile.getAbsolutePath());
        this.classLoader.addToClassLoaderChain(parentClassLoader);
    }

    public File getCatalogFile() {
        return this.catalogFile;
    }

    public boolean addToEngines(GFRNEngine value) {
        boolean changed = false;
        if (value != null && value.getName() != null) {
            GFRNEngine oldValue;
            if (this.engines == null) {
                this.engines = new FHashMap();
            }
            if ((oldValue = (GFRNEngine)this.engines.put((Object)value.getName(), (Object)value)) != value) {
                if (oldValue != null) {
                    oldValue.setCatalog(null);
                }
                value.setCatalog(this);
                changed = true;
            }
        }
        return changed;
    }

    public Iterator entriesOfEngines() {
        return this.engines == null ? FEmptyIterator.get() : this.engines.entrySet().iterator();
    }

    public GFRNEngine getFromEngines(String key) {
        return this.engines == null || key == null ? null : (GFRNEngine)this.engines.get((Object)key);
    }

    public boolean hasInEngines(GFRNEngine value) {
        return this.engines != null && value != null && value.getName() != null && this.engines.get((Object)value.getName()) == value;
    }

    public boolean hasKeyInEngines(String key) {
        return this.engines != null && key != null && this.engines.containsKey((Object)key);
    }

    public Iterator iteratorOfEngines() {
        return this.engines == null ? FEmptyIterator.get() : this.engines.values().iterator();
    }

    public Iterator keysOfEngines() {
        return this.engines == null ? FEmptyIterator.get() : this.engines.keySet().iterator();
    }

    public void removeAllFromEngines() {
        Iterator iter = this.iteratorOfEngines();
        while (iter.hasNext()) {
            GFRNEngine tmpValue = (GFRNEngine)iter.next();
            this.removeFromEngines(tmpValue);
        }
    }

    public boolean removeFromEngines(GFRNEngine value) {
        GFRNEngine oldValue;
        boolean changed = false;
        if (this.engines != null && value != null && value.getName() != null && (oldValue = (GFRNEngine)this.engines.get((Object)value.getName())) == value) {
            this.engines.remove((Object)value.getName());
            value.setCatalog(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromEngines(String key) {
        GFRNEngine tmpValue;
        boolean changed = false;
        if (this.engines != null && key != null && (tmpValue = (GFRNEngine)this.engines.get((Object)key)) != null) {
            this.engines.remove((Object)key);
            tmpValue.setCatalog(null);
            changed = true;
        }
        return changed;
    }

    public int sizeOfEngines() {
        return this.engines == null ? 0 : this.engines.size();
    }

    public FPN getFpn() {
        return this.fpn;
    }

    public boolean setFpn(FPN value) {
        boolean changed = false;
        if (this.fpn != value) {
            if (this.fpn != null) {
                FPN oldValue = this.fpn;
                this.fpn = null;
                oldValue.setCatalog(null);
            }
            this.fpn = value;
            if (value != null) {
                value.setCatalog(this);
            }
            changed = true;
        }
        return changed;
    }

    public GFRN getGfrn() {
        return this.gfrn;
    }

    public boolean setGfrn(GFRN value) {
        boolean changed = false;
        if (this.gfrn != value) {
            if (this.gfrn != null) {
                GFRN oldValue = this.gfrn;
                this.gfrn = null;
                oldValue.setCatalog(null);
            }
            this.gfrn = value;
            if (value != null) {
                value.setCatalog(this);
            }
            changed = true;
        }
        return changed;
    }

    public InferenceEngine getInferenceEngine() {
        return this.inferenceEngine;
    }

    public boolean setInferenceEngine(InferenceEngine value) {
        boolean changed = false;
        if (this.inferenceEngine != value) {
            if (this.inferenceEngine != null) {
                InferenceEngine oldValue = this.inferenceEngine;
                this.inferenceEngine = null;
                oldValue.removeFromCatalogs(this);
            }
            this.inferenceEngine = value;
            if (value != null) {
                value.addToCatalogs(this);
            }
            changed = true;
        }
        return changed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean initialize() {
        FPN oldFpn;
        if (!this.initialized) {
            boolean gfrnLoaded = this.loadGFRN();
            boolean enginesLoaded = false;
            if (gfrnLoaded) {
                enginesLoaded = this.loadEngines();
            }
            boolean bl = this.initialized = gfrnLoaded && enginesLoaded;
        }
        if ((oldFpn = this.getFpn()) != null) {
            oldFpn.removeYou();
        }
        this.setFpn(new FPN());
        return this.initialized;
    }

    private boolean loadGFRN() {
        boolean success = false;
        try {
            JarFile jarFile = new JarFile(this.catalogFile);
            JarEntry gfrnJarEntry = jarFile.getJarEntry("GFRN.xml");
            GFRN gfrn = GFRNLoader.loadGFRN(new BufferedInputStream(jarFile.getInputStream(gfrnJarEntry)));
            if (gfrn.isValid()) {
                this.setGfrn(gfrn);
                success = true;
            } else {
                InferenceEngine.appendToOutput("Dependency Net is not valid:\n");
                InferenceEngine.appendToOutput(gfrn.getValidationErrors());
            }
        }
        catch (IOException e) {
            InferenceEngine.appendToOutput("IOException loading Dependency Net:\n" + e.getMessage() + "\n");
        }
        catch (ParserConfigurationException e) {
            InferenceEngine.appendToOutput("ParserConfigurationException loading Dependency Net:\n" + e.getMessage() + "\n");
        }
        catch (SAXException e) {
            InferenceEngine.appendToOutput("SAXException loading Dependency Net:\n" + e.getMessage() + "\n");
        }
        return success;
    }

    private boolean loadEngines() {
        boolean success = true;
        Iterator iter = this.getGfrn().iteratorOfPredicates();
        while (iter.hasNext()) {
            Predicate predicate = (Predicate)iter.next();
            if (predicate.isAxiom() || predicate.isAbstract() || this.hasKeyInEngines(predicate.getName())) continue;
            try {
                String engineClassName = predicate.getClassName();
                Class engineClass = this.classLoader.loadClass(engineClassName);
                Method getMethod = engineClass.getMethod("get", null);
                GFRNEngine engine = (GFRNEngine)getMethod.invoke(null, null);
                engine.setName(predicate.getName());
                this.addToEngines(engine);
            }
            catch (ClassNotFoundException e) {
                success = false;
                InferenceEngine.appendToOutput("ClassNotFoundException during loading Dependency Net:\n" + e.getMessage() + "\n");
            }
            catch (SecurityException e) {
                success = false;
                InferenceEngine.appendToOutput("SecurityException during loading Dependency Net:\n" + e.getMessage() + "\n");
            }
            catch (NoSuchMethodException e) {
                success = false;
                InferenceEngine.appendToOutput("NoSuchMethodException during loading Dependency Net:\n" + e.getMessage() + "\n");
            }
            catch (IllegalArgumentException e) {
                success = false;
                InferenceEngine.appendToOutput("IllegalArgumentException during loading Dependency Net:\n" + e.getMessage() + "\n");
            }
            catch (IllegalAccessException e) {
                success = false;
                InferenceEngine.appendToOutput("IllegalAccessException during loading Dependency Net:\n" + e.getMessage() + "\n");
            }
            catch (InvocationTargetException e) {
                success = false;
                InferenceEngine.appendToOutput("InvocationTargetException during loading Dependency Net:\n" + e.getMessage() + "\n");
            }
        }
        return success;
    }

    public HashMap getAxiomClasses() {
        if (this.axiomClasses == null) {
            this.axiomClasses = new HashMap();
            Iterator iter = this.getGfrn().iteratorOfPredicates();
            while (iter.hasNext()) {
                Predicate predicate = (Predicate)iter.next();
                if (!predicate.isAxiom()) continue;
                String className = predicate.getClassName();
                try {
                    Class axiomClass = this.classLoader.loadClass(className);
                    this.axiomClasses.put(className, axiomClass);
                }
                catch (ClassNotFoundException e) {
                    InferenceEngine.appendToOutput("Class " + className + " not found!\n");
                }
            }
        }
        return this.axiomClasses;
    }

    public String toString() {
        return this.getName();
    }

    public void removeYou() {
        GFRN tmpGfrn;
        FPN tmpFpn;
        InferenceEngine tmpInferenceEngine = this.getInferenceEngine();
        if (tmpInferenceEngine != null) {
            this.setInferenceEngine(null);
        }
        if ((tmpFpn = this.getFpn()) != null) {
            this.setFpn(null);
            tmpFpn.removeYou();
        }
        if ((tmpGfrn = this.getGfrn()) != null) {
            this.setGfrn(null);
            tmpGfrn.removeYou();
        }
        this.removeAllFromEngines();
    }
}

