/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGProject;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.inferenceengine.IProgressDialog;
import de.upb.inferenceengine.ITriggerElementsCollector;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.dialogs.ProgressDialog;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.engines.GFRNEngine;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.strategies.AbstractInferenceStrategy;
import de.upb.inferenceengine.gfrn.strategies.RecursiveStrategy;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import de.upb.inferenceengine.visitors.CollectASGElementsVisitor;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class InferenceEngine
implements Runnable {
    public static final String ENGINES_SUFFIX = "Engine";
    private static final String PROTOCOL_FILENAME = "Inference.log";
    private static volatile InferenceEngine gfrnInferenceEngine;
    private static volatile InferenceEngine gfrnInferenceEngineSingleton;
    private ITriggerElementsCollector triggerElementsCollector;
    private FHashMap catalogs;
    private RuleCatalog currentCatalog;
    private static IProgressDialog progressDialog;
    private boolean showProgress = true;
    private boolean addResultsToDiagram = true;
    private static boolean halted;
    private static boolean aborted;
    private static boolean allDone;
    private GFRN lastGFRNUsed;
    private static long startTime;
    private static StringBuffer protocol;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        halted = false;
        aborted = false;
        allDone = false;
        protocol = new StringBuffer();
    }

    private InferenceEngine() {
        this(null);
    }

    private InferenceEngine(IProgressDialog aProgressDialog) {
        progressDialog = aProgressDialog;
    }

    public static InferenceEngine get() {
        if (gfrnInferenceEngine == null) {
            return InferenceEngine.get(new ProgressDialog());
        }
        return gfrnInferenceEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InferenceEngine get(IProgressDialog aProgressDialog) {
        if (gfrnInferenceEngine != null) return gfrnInferenceEngine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.upb.inferenceengine.InferenceEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (gfrnInferenceEngineSingleton == null) {
                gfrnInferenceEngineSingleton = new InferenceEngine(aProgressDialog);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            gfrnInferenceEngine = gfrnInferenceEngineSingleton;
            return gfrnInferenceEngine;
        }
    }

    public ITriggerElementsCollector getTriggerElementsCollector() {
        if (this.triggerElementsCollector == null) {
            this.triggerElementsCollector = new CollectASGElementsVisitor();
        }
        return this.triggerElementsCollector;
    }

    public void setTriggerElementsCollector(ITriggerElementsCollector triggerElementsCollector) {
        this.triggerElementsCollector = triggerElementsCollector;
    }

    public boolean addToCatalogs(RuleCatalog value) {
        boolean changed = false;
        if (value != null && value.getName() != null) {
            RuleCatalog oldValue;
            if (this.catalogs == null) {
                this.catalogs = new FHashMap();
            }
            if ((oldValue = (RuleCatalog)this.catalogs.put((Object)value.getName(), (Object)value)) != value) {
                if (oldValue != null) {
                    oldValue.setInferenceEngine(null);
                }
                value.setInferenceEngine(this);
                changed = true;
            }
        }
        return changed;
    }

    public Iterator entriesOfCatalogs() {
        return this.catalogs == null ? FEmptyIterator.get() : this.catalogs.entrySet().iterator();
    }

    public RuleCatalog getFromCatalogs(String key) {
        return this.catalogs == null || key == null ? null : (RuleCatalog)this.catalogs.get((Object)key);
    }

    public boolean hasInCatalogs(RuleCatalog value) {
        return this.catalogs != null && value != null && value.getName() != null && this.catalogs.get((Object)value.getName()) == value;
    }

    public boolean hasKeyInCatalogs(String key) {
        return this.catalogs != null && key != null && this.catalogs.containsKey((Object)key);
    }

    public Iterator iteratorOfCatalogs() {
        return this.catalogs == null ? FEmptyIterator.get() : this.catalogs.values().iterator();
    }

    public Iterator keysOfCatalogs() {
        return this.catalogs == null ? FEmptyIterator.get() : this.catalogs.keySet().iterator();
    }

    public void removeAllFromCatalogs() {
        Iterator iter = this.iteratorOfCatalogs();
        while (iter.hasNext()) {
            RuleCatalog tmpValue = (RuleCatalog)iter.next();
            this.removeFromCatalogs(tmpValue);
        }
    }

    public boolean removeFromCatalogs(RuleCatalog value) {
        RuleCatalog oldValue;
        boolean changed = false;
        if (this.catalogs != null && value != null && value.getName() != null && (oldValue = (RuleCatalog)this.catalogs.get((Object)value.getName())) == value) {
            this.catalogs.remove((Object)value.getName());
            value.setInferenceEngine(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromCatalogs(String key) {
        RuleCatalog tmpValue;
        boolean changed = false;
        if (this.catalogs != null && key != null && (tmpValue = (RuleCatalog)this.catalogs.get((Object)key)) != null) {
            this.catalogs.remove((Object)key);
            tmpValue.setInferenceEngine(null);
            changed = true;
        }
        return changed;
    }

    public int sizeOfCatalogs() {
        return this.catalogs == null ? 0 : this.catalogs.size();
    }

    public void setCurrentCatalog(RuleCatalog newCurrentCatalog) {
        if (newCurrentCatalog != null && !this.hasInCatalogs(newCurrentCatalog)) {
            throw new IllegalArgumentException("Catalog is not in the catalog list!");
        }
        this.currentCatalog = newCurrentCatalog;
    }

    public RuleCatalog getCurrentCatalog() {
        return this.currentCatalog;
    }

    public IProgressDialog getProgressDialog() {
        return progressDialog;
    }

    public void setShowProgress(boolean showProgess) {
        this.showProgress = showProgess;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setAddResultsToDiagram(boolean addResultsToDiagram) {
        this.addResultsToDiagram = addResultsToDiagram;
    }

    public boolean isAddResultsToDiagram() {
        return this.addResultsToDiagram;
    }

    public static synchronized void setHalted(boolean value) {
        halted = value;
    }

    public static synchronized boolean isHalted() {
        return halted;
    }

    public static synchronized void abort() {
        aborted = true;
    }

    public static synchronized boolean isAborted() {
        return aborted;
    }

    public static synchronized boolean isAllDone() {
        return allDone;
    }

    public void execute() {
        Thread inferenceThread = new Thread(this);
        inferenceThread.start();
    }

    private void setProgress(String aProgressString) {
        if (progressDialog != null && this.isShowProgress()) {
            progressDialog.setText(aProgressString);
            progressDialog.appendToOutput(String.valueOf(aProgressString) + "\n");
        }
    }

    public void run() {
        RuleCatalog currentCatalog;
        boolean initialized;
        allDone = false;
        UMLProject umlProject = UMLProject.get();
        if (this.isShowProgress()) {
            progressDialog.init();
            this.setProgress("Initializing catalog, engines and FPN...");
        }
        if (initialized = (currentCatalog = this.getCurrentCatalog()).initialize()) {
            HashMap axiomClasses = currentCatalog.getAxiomClasses();
            startTime = System.currentTimeMillis();
            List triggerElements = this.collectTriggerElements(axiomClasses.values());
            AbstractInferenceStrategy inferenceStrategy = this.getSelectedInferenceStrategy(currentCatalog);
            this.lastGFRNUsed = currentCatalog.getGfrn();
            inferenceStrategy.runInference(triggerElements);
            this.evaluateFPN(this.lastGFRNUsed, currentCatalog);
            Iterator iter = currentCatalog.iteratorOfEngines();
            while (iter.hasNext()) {
                GFRNEngine gfrnEngine = (GFRNEngine)iter.next();
                gfrnEngine.removeAllFromFailedApplications();
            }
            if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
                this.setProgress("Finished");
            }
        } else {
            this.setProgress("Initializing rules catalog failed.\nRules catalog will be removed.\n");
            this.removeFromCatalogs(currentCatalog);
            this.setCurrentCatalog(null);
        }
        if (this.isShowProgress()) {
            progressDialog.allDone();
        }
        allDone = true;
        umlProject.refreshDisplay();
        if (InferenceEnginePreferences.get().isDebugMode()) {
            this.writeProtocol();
        }
    }

    private AbstractInferenceStrategy getSelectedInferenceStrategy(RuleCatalog currentCatalog) {
        AbstractInferenceStrategy inferenceStrategy;
        block13: {
            Class strategyClass = InferenceEnginePreferences.get().getInferenceStrategy();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("de.upb.inferenceengine.RuleCatalog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] paramTypes = classArray;
            Object[] params = new Object[]{currentCatalog};
            inferenceStrategy = null;
            try {
                inferenceStrategy = (AbstractInferenceStrategy)strategyClass.getConstructor(paramTypes).newInstance(params);
                if (this.isShowProgress()) {
                    progressDialog.setText("Selected strategy " + strategyClass.getName() + " ");
                    progressDialog.appendToOutput("Selected strategy " + strategyClass.getName() + "\n");
                }
            }
            catch (Exception e) {
                inferenceStrategy = new RecursiveStrategy(currentCatalog);
                if (!this.isShowProgress()) break block13;
                StringBuffer stringBuffer = new StringBuffer("Error: Selected default strategy ");
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("de.upb.inferenceengine.gfrn.strategies.RecursiveStrategy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                progressDialog.setText(stringBuffer.append(clazz2.getName()).append(" ").toString());
                StringBuffer stringBuffer2 = new StringBuffer("Error: Selected default strategy ");
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("de.upb.inferenceengine.gfrn.strategies.RecursiveStrategy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                progressDialog.appendToOutput(stringBuffer2.append(clazz3.getName()).append("\n").toString());
            }
        }
        return inferenceStrategy;
    }

    protected List collectTriggerElements(Collection axiomClasses) {
        if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
            progressDialog.setText("Collecting trigger elements ...");
            progressDialog.appendToOutput("Collecting trigger elements ...\n");
        }
        return this.getTriggerElementsCollector().getTriggerElements((ASGProject)UMLProject.get(), axiomClasses);
    }

    public void evaluateFPN(GFRN gfrn, RuleCatalog ruleCatalog) {
        if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
            this.setProgress("Evaluating FPN...");
        }
        ruleCatalog.getFpn().evaluate();
        if (InferenceEngine.get().isAddResultsToDiagram()) {
            if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
                this.setProgress("Adding annotations to diagrams...");
            }
            gfrn.addResultsToDiagrams();
        }
    }

    public Iterator iteratorOfResults() {
        return this.lastGFRNUsed != null ? this.lastGFRNUsed.iteratorOfResults() : FEmptyIterator.get();
    }

    private void writeProtocol() {
        try {
            FileWriter fileWriter = new FileWriter(PROTOCOL_FILENAME);
            fileWriter.write(protocol.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            System.err.println("Error writing inference protocol document `Inference.log`!");
            e.printStackTrace();
        }
    }

    public static void appendToProtocol(String text) {
        long timeDifference = System.currentTimeMillis() - startTime;
        protocol.append(timeDifference).append("ms: ").append(text);
    }

    public static void appendToProtocol(GFRNAnnotation annotation, String indent) {
        InferenceEngine.appendToProtocol(String.valueOf(indent) + "annotated elements:\n");
        Iterator keyIter = annotation.keysOfElements();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            StringBuffer output = new StringBuffer();
            output.append(String.valueOf(indent) + "[" + key + "]: ");
            Iterator elemIter = annotation.iteratorOfElements(key);
            while (elemIter.hasNext()) {
                ASGElement elem = (ASGElement)elemIter.next();
                output.append(String.valueOf(elem.toString()) + " / ");
            }
            InferenceEngine.appendToProtocol(String.valueOf(output.substring(0, output.length() - 3)) + "\n");
        }
        InferenceEngine.appendToProtocol(String.valueOf(indent) + "\n\n");
    }

    public static void appendToOutput(String text) {
        if (progressDialog != null) {
            progressDialog.appendToOutput(text);
        }
    }

    public static void appendToOutput(GFRNAnnotation annotation) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(annotation.getName());
        buffer.append(" (");
        Iterator connections = annotation.keysOfElements();
        while (connections.hasNext()) {
            String annotedElementName = (String)connections.next();
            Iterator iter = annotation.iteratorOfElements(annotedElementName);
            while (iter.hasNext()) {
                FElement annotedElement = (FElement)iter.next();
                buffer.append(annotedElementName);
                buffer.append("=");
                buffer.append(annotedElement.getName());
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            if (!connections.hasNext()) continue;
            buffer.append("; ");
        }
        buffer.append(")\n");
        InferenceEngine.appendToOutput(buffer.toString());
    }

    public void removeYou() {
        this.removeAllFromCatalogs();
    }
}

