/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.fop.apps.Document;
import org.apache.fop.fo.extensions.svg.SVGUserAgent;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSGraphics2D;
import org.apache.fop.render.ps.PSTextElementBridge;
import org.apache.fop.render.ps.PSTextPainter;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PSXMLHandler
implements XMLHandler {
    public static final String PS_GENERATOR = "psGenerator";
    public static final String PS_FONT_INFO = "psFontInfo";
    public static final String PS_WIDTH = "width";
    public static final String PS_HEIGHT = "height";
    public static final String PS_XPOS = "xpos";
    public static final String PS_YPOS = "ypos";

    public static PSInfo getPSInfo(RendererContext context) {
        PSInfo psi = new PSInfo();
        psi.psGenerator = (PSGenerator)context.getProperty(PS_GENERATOR);
        psi.fontInfo = (Document)context.getProperty(PS_FONT_INFO);
        psi.width = (Integer)context.getProperty(PS_WIDTH);
        psi.height = (Integer)context.getProperty(PS_HEIGHT);
        psi.currentXPosition = (Integer)context.getProperty(PS_XPOS);
        psi.currentYPosition = (Integer)context.getProperty(PS_YPOS);
        return psi;
    }

    public void handleXML(RendererContext context, org.w3c.dom.Document doc, String ns) throws Exception {
        PSInfo psi = PSXMLHandler.getPSInfo(context);
        String svg = "http://www.w3.org/2000/svg";
        if (svg.equals(ns)) {
            SVGHandler svghandler = new SVGHandler();
            svghandler.renderSVGDocument(context, doc, psi);
        }
    }

    public static class PSInfo {
        private PSGenerator psGenerator;
        private Document fontInfo;
        private int width;
        private int height;
        private int currentXPosition;
        private int currentYPosition;

        static /* synthetic */ Document access$2(PSInfo $0) {
            return $0.fontInfo;
        }

        static /* synthetic */ int access$4(PSInfo $0) {
            return $0.width;
        }

        static /* synthetic */ int access$6(PSInfo $0) {
            return $0.height;
        }

        public int getCurrentXPosition() {
            return this.currentXPosition;
        }

        public int getCurrentYPosition() {
            return this.currentYPosition;
        }

        public Document getFontInfo() {
            return this.fontInfo;
        }

        public int getHeight() {
            return this.height;
        }

        public PSGenerator getPSGenerator() {
            return this.psGenerator;
        }

        public int getWidth() {
            return this.width;
        }

        public void setCurrentXPosition(int currentXPosition) {
            this.currentXPosition = currentXPosition;
        }

        public void setCurrentYPosition(int currentYPosition) {
            this.currentYPosition = currentYPosition;
        }

        public void setFontInfo(Document fontInfo) {
            this.fontInfo = fontInfo;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setPsGenerator(PSGenerator psGenerator) {
            this.psGenerator = psGenerator;
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }

    protected class SVGHandler {
        protected SVGHandler() {
        }

        protected void renderSVGDocument(RendererContext context, org.w3c.dom.Document doc, PSInfo psInfo) {
            GraphicsNode root;
            int xOffset = psInfo.currentXPosition;
            int yOffset = psInfo.currentYPosition;
            PSGenerator gen = psInfo.psGenerator;
            SVGUserAgent ua = new SVGUserAgent(context.getUserAgent(), new AffineTransform());
            GVTBuilder builder = new GVTBuilder();
            BridgeContext ctx = new BridgeContext((UserAgent)ua);
            PSTextElementBridge tBridge = new PSTextElementBridge(psInfo.getFontInfo());
            ctx.putBridge((Bridge)tBridge);
            AffineTransform transform = gen.getCurrentState().getTransform();
            transform.translate((float)xOffset / 1000.0f, (float)yOffset / 1000.0f);
            PSTextPainter textPainter = new PSTextPainter(psInfo.getFontInfo());
            ctx.setTextPainter((TextPainter)textPainter);
            try {
                root = builder.build(ctx, doc);
            }
            catch (Exception e) {
                context.getUserAgent().getLogger().error("SVG graphic could not be built: " + e.getMessage(), e);
                return;
            }
            float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
            float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
            float sx = (float)psInfo.getWidth() / w;
            float sy = (float)psInfo.getHeight() / h;
            ctx = null;
            builder = null;
            try {
                gen.writeln("%SVG graphic start ---");
                gen.saveGraphicsState();
                gen.concatMatrix(sx, 0.0, 0.0, sy, xOffset, yOffset);
                SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
                AffineTransform at = ViewBox.getPreserveAspectRatioTransform((Element)svg, (float)(w / 1000.0f), (float)(h / 1000.0f));
                if (!at.isIdentity()) {
                    double[] vals = new double[6];
                    at.getMatrix(vals);
                    gen.concatMatrix(vals);
                }
                PSGraphics2D graphics = new PSGraphics2D(true, gen);
                graphics.setGraphicContext(new GraphicContext());
                transform = new AffineTransform();
                transform.translate(xOffset, yOffset);
                gen.getCurrentState().concatMatrix(transform);
                try {
                    root.paint((Graphics2D)((Object)graphics));
                }
                catch (Exception e) {
                    context.getUserAgent().getLogger().error("SVG graphic could not be rendered: " + e.getMessage(), e);
                }
                psInfo.psGenerator.restoreGraphicsState();
                gen.writeln("%SVG graphic end ---");
            }
            catch (IOException ioe) {
                context.getUserAgent().getLogger().error("SVG graphic could not be rendered: " + ioe.getMessage(), ioe);
            }
        }
    }
}

