/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.svggen.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.svggen.preferences.SVGGenPreferences;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateSVGAction
extends AbstractAction {
    public void actionPerformed(ActionEvent e) {
        FrameMain myFrame = FrameMain.get();
        FSALayeredPane rootFSA = myFrame.getCurrentInternalFrame().getDiagramRoot();
        JComponent comp = null;
        if (rootFSA != null) {
            comp = rootFSA.getJComponent();
        }
        if (comp == null) {
            return;
        }
        String lastFolder = SVGGenPreferences.get().getLastFolder();
        File file = new File(lastFolder);
        String ending = this.getEnding();
        JFileChooser fileChooser = new JFileChooser();
        MyFileFilter filter = new MyFileFilter(new String[]{ending});
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle("Generate " + ending + " - Save as...");
        String initialFileName = "." + ending;
        initialFileName = UMLProject.get() == null ? "default" + initialFileName : (UMLProject.get().getCurrentDiagram() == null ? UMLProject.get() + initialFileName : String.valueOf(UMLProject.get().getCurrentDiagram().getName()) + initialFileName);
        fileChooser.setSelectedFile(new File(file, initialFileName));
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showSaveDialog(myFrame.getFrame()) == 0) {
            myFrame.setCursorWait();
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            if (filename.length() == 0) {
                filename = String.valueOf(System.getProperty("user.dir")) + "noname." + ending;
            } else if (!filename.toLowerCase().endsWith("." + ending)) {
                filename = String.valueOf(filename) + "." + ending;
            }
            String path = filename.substring(0, filename.lastIndexOf(File.separator));
            SVGGenPreferences.get().setLastFolder(path);
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = impl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            RepaintManager manager = RepaintManager.currentManager(comp);
            manager.markCompletelyDirty(comp);
            manager.paintDirtyRegions();
            svgGenerator.setSVGCanvasSize(comp.getPreferredSize());
            comp.print((Graphics)svgGenerator);
            try {
                Transcoder transcoder = this.getTranscoder();
                if (transcoder == null) {
                    boolean useCSS = true;
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
                    svgGenerator.stream((Writer)out, useCSS);
                    ((Writer)out).close();
                } else {
                    Element root = document.getDocumentElement();
                    svgGenerator.getRoot(root);
                    TranscoderInput input = new TranscoderInput(document);
                    FileOutputStream ostream = new FileOutputStream(filename);
                    TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                    transcoder.transcode(input, output);
                    ostream.flush();
                    ((OutputStream)ostream).close();
                }
            }
            catch (Exception f) {
                myFrame.setCursorDefault();
                JOptionPane.showMessageDialog(null, "Generate SVG raised Exception: " + f, "ERROR", 0);
            }
            myFrame.setCursorDefault();
        }
    }

    protected Transcoder getTranscoder() {
        return null;
    }

    protected String getEnding() {
        return "svg";
    }

    public class MyFileFilter
    extends FileFilter {
        String[] endings = new String[0];

        public MyFileFilter(String[] endings) {
            if (endings == null) {
                this.endings = new String[0];
            }
            this.endings = endings;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                int i = 0;
                while (i < this.endings.length) {
                    if (extension.equals(this.endings[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        public String getDescription() {
            String endingsList = "";
            int i = 0;
            while (i < this.endings.length) {
                endingsList = String.valueOf(endingsList) + this.endings[i] + " ";
                ++i;
            }
            return String.valueOf(endingsList) + "Images";
        }
    }
}

