/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.tools.util;

import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.tools.util.TextUtil;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class MethodDeclaration {
    public static final String VALID_DECLARATION = "Valid declaration";
    public static final String EMPTY_DECLARATION = "Nothing defined";
    public static final String INVALID_METHOD_DECLARATION = "Invalid method declaration";
    public static final String NO_METHOD_NAME_DECLARED = "No method name declared";
    public static final String METHOD_IS_KEYWORD = "The name of the method is a Java keyword";
    public static final String ILLEGAL_RETURN_TYPE_DECLARATION = "Illegal return type declaration";
    public static final String ILLEGAL_PARAMETER_DECLARATION = "Illegal parameter declaration";
    public static final String ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION = "Illegal parameter and return type declaration";
    private String original = "";
    private String methodError = "Nothing defined";
    private boolean isParsed = false;
    private boolean isPublic = false;
    private boolean isPackage = false;
    private boolean isProtected = false;
    private boolean isPrivate = false;
    private boolean isFinal = false;
    private boolean isAbstract = false;
    private boolean isStatic = false;
    private boolean isSynchronized = false;
    private boolean isTransient = false;
    private boolean isVolatile = false;
    private boolean isNative = false;
    private String name = "";
    private String rType = "";
    private String[] param = new String[0];
    private String[] var = new String[0];

    public MethodDeclaration(String declaration) {
        if (declaration == null) {
            throw new NullPointerException("Parameter declaration is null");
        }
        this.original = declaration;
        this.parse();
    }

    private void parse() {
        this.parseJavaMethod();
        this.parseUMLMethod();
    }

    private void parseJavaMethod() {
        if (this.original.length() == 0) {
            return;
        }
        String s = this.original.trim();
        if (s.length() == 0) {
            this.methodError = EMPTY_DECLARATION;
            this.isParsed = true;
            return;
        }
        Vector<String> vector = new Vector<String>();
        int mark = 0;
        int parOn = -1;
        int parOff = -1;
        int state = 0;
        int i = 0;
        while (i < s.length()) {
            switch (state) {
                case 0: {
                    if (s.charAt(i) == '(' || s.charAt(i) == ')' || s.charAt(i) == ';') {
                        state = 6;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    if (s.charAt(i) == ' ') {
                        state = 2;
                        vector.add(s.substring(mark, i));
                        mark = i + 1;
                        break;
                    }
                    if (s.charAt(i) == ';') {
                        state = 5;
                        vector.add(s.substring(mark, i));
                        break;
                    }
                    if (s.charAt(i) == '(') {
                        state = 3;
                        parOn = i + 1;
                        vector.add(s.substring(mark, i));
                        break;
                    }
                    if (s.charAt(i) != ')') break;
                    state = 6;
                    break;
                }
                case 2: {
                    if (s.charAt(i) == ')') {
                        state = 6;
                        break;
                    }
                    if (s.charAt(i) == '(') {
                        state = 3;
                        parOn = i + 1;
                        break;
                    }
                    if (s.charAt(i) == ';') {
                        state = 5;
                        break;
                    }
                    if (s.charAt(i) == ' ') break;
                    state = 1;
                    mark = i;
                    break;
                }
                case 3: {
                    if (s.charAt(i) != ')') break;
                    state = 4;
                    parOff = i;
                    break;
                }
                case 4: {
                    if (s.charAt(i) == ';') {
                        state = 5;
                        break;
                    }
                    state = 6;
                    break;
                }
                case 5: {
                    state = 6;
                }
            }
            if (state == 6) {
                this.methodError = INVALID_METHOD_DECLARATION;
                return;
            }
            ++i;
        }
        if (state == 3) {
            this.methodError = INVALID_METHOD_DECLARATION;
            return;
        }
        String method = "";
        String param = "";
        String rType = "";
        if (state == 1) {
            vector.add(s.substring(mark));
        }
        if ((state == 4 || state == 5) && parOn >= 0) {
            param = s.substring(parOn, parOff);
        }
        if (vector.size() == 1) {
            method = ((String)vector.get(0)).trim();
            this.methodError = VALID_DECLARATION;
        } else if (vector.size() == 2) {
            method = ((String)vector.get(1)).trim();
            String str = ((String)vector.get(0)).trim();
            rType = this.setSignifierMethod(str, false) ? "" : str;
            this.methodError = VALID_DECLARATION;
        } else if (vector.size() > 2) {
            int i2 = 0;
            while (i2 < vector.size() - 2) {
                String str = ((String)vector.get(i2)).trim();
                if (!this.setSignifierMethod(str, true)) {
                    return;
                }
                ++i2;
            }
            method = ((String)vector.get(vector.size() - 1)).trim();
            rType = ((String)vector.get(vector.size() - 2)).trim();
            this.methodError = VALID_DECLARATION;
        }
        if (TextUtil.isJavaKeyword(method)) {
            this.methodError = METHOD_IS_KEYWORD;
            return;
        }
        if (!TextUtil.isJavaIdentifier(method)) {
            this.methodError = INVALID_METHOD_DECLARATION;
            return;
        }
        if (param.trim().length() != 0) {
            this.parseJavaParam(param.trim());
        }
        String rTypeToCheck = rType;
        if (rType.endsWith("[]")) {
            rTypeToCheck = rType.substring(0, rType.length() - 2);
        }
        if (rType.lastIndexOf(".") != -1) {
            int iIndex = rType.lastIndexOf(".");
            rTypeToCheck = rType.substring(iIndex + 1);
        }
        if (!TextUtil.isJavaSuitable(rTypeToCheck) || rType.endsWith("[]") && rTypeToCheck.length() == 0) {
            this.methodError = this.methodError == ILLEGAL_PARAMETER_DECLARATION ? ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION : ILLEGAL_RETURN_TYPE_DECLARATION;
            rType = "";
        }
        this.name = method;
        this.rType = rType;
        this.isParsed = true;
    }

    private void parseUMLMethod() {
        if (this.original.length() == 0 || this.isParsed) {
            return;
        }
        String s = this.original.trim();
        if (s.length() == 0) {
            this.methodError = EMPTY_DECLARATION;
            return;
        }
        char vis = '\u0000';
        String method = "";
        String param = "";
        String rType = "";
        int mark = 0;
        if (s.charAt(0) == '+' || s.charAt(0) == '-' || s.charAt(0) == '#' || s.charAt(0) == '~') {
            vis = s.charAt(0);
            mark = 1;
        }
        int i = 1;
        while (i < s.length()) {
            if (s.charAt(i) == '(') {
                method = s.substring(mark, i).trim();
                mark = i + 1;
            } else if (s.charAt(i) == ')') {
                param = s.substring(mark, i).trim();
                rType = s.substring(i + 1, s.length()).trim();
                if (!rType.startsWith(":")) {
                    this.methodError = INVALID_METHOD_DECLARATION;
                    return;
                }
                rType = s.substring(i + 2, s.length()).trim();
                mark = -1;
                break;
            }
            if (s.charAt(i) == ':' && mark <= 1) {
                method = s.substring(mark, i);
                rType = s.substring(i + 1, s.length()).trim();
                mark = -2;
                break;
            }
            ++i;
        }
        if (mark == 0) {
            method = s;
        } else if (mark == 1) {
            method = s.substring(1);
        }
        if (method.length() == 0) {
            this.methodError = NO_METHOD_NAME_DECLARED;
            return;
        }
        if (!TextUtil.isJavaIdentifier(method)) {
            this.methodError = INVALID_METHOD_DECLARATION;
            return;
        }
        if (TextUtil.isJavaKeyword(method)) {
            this.methodError = METHOD_IS_KEYWORD;
            return;
        }
        this.methodError = VALID_DECLARATION;
        if (param.length() != 0) {
            this.parseUMLParam(param);
        }
        if (rType.endsWith("[]")) {
            if (rType.length() == 2 || rType.length() > 2 && !TextUtil.isJavaSuitable(rType.substring(0, rType.length() - 2))) {
                this.methodError = this.methodError == ILLEGAL_PARAMETER_DECLARATION ? ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION : ILLEGAL_RETURN_TYPE_DECLARATION;
                rType = "";
            }
        } else if (!TextUtil.isJavaSuitable(rType)) {
            this.methodError = this.methodError == ILLEGAL_PARAMETER_DECLARATION ? ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION : ILLEGAL_RETURN_TYPE_DECLARATION;
            rType = "";
        }
        if (vis == '~') {
            this.isPackage = true;
        } else if (vis == '#') {
            this.isProtected = true;
        } else if (vis == '+') {
            this.isPublic = true;
        } else if (vis == '-') {
            this.isPrivate = true;
        }
        this.rType = rType;
        this.name = method;
        this.isParsed = true;
    }

    private void parseUMLParam(String str) {
        StringTokenizer token = new StringTokenizer(str, ";,");
        String[] p = new String[token.countTokens()];
        String[] v = new String[token.countTokens()];
        int counter = 0;
        while (token.hasMoreTokens()) {
            String s = token.nextToken().trim();
            int put = -1;
            int state = 0;
            int i = 0;
            while (i < s.length()) {
                switch (state) {
                    case 0: {
                        if (s.charAt(i) == ':') {
                            this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                            this.param = new String[0];
                            this.var = new String[0];
                            return;
                        }
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (s.charAt(i) == ' ') {
                            state = 2;
                            break;
                        }
                        if (s.charAt(i) != ':') break;
                        put = i;
                        break;
                    }
                    case 2: {
                        if (s.charAt(i) == ':') {
                            put = i;
                            break;
                        }
                        if (s.charAt(i) == ' ') break;
                        this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                        this.param = new String[0];
                        this.var = new String[0];
                        return;
                    }
                }
                if (put != -1) break;
                ++i;
            }
            if (put != -1) {
                v[counter] = s.substring(0, put).trim();
                p[counter] = s.substring(put + 1).trim();
            } else {
                p[counter] = s;
                v[counter] = "";
            }
            if (v[counter].length() != 0 && TextUtil.isJavaKeyword(v[counter])) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (p[counter].equals("void") || p[counter].equals("void[]")) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (p[counter].endsWith("[]")) {
                if (p[counter].length() == 2 || p[counter].length() > 2 && !TextUtil.isJavaSuitable(p[counter].substring(0, p[counter].length() - 2))) {
                    this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                    this.param = new String[0];
                    this.var = new String[0];
                    return;
                }
            } else if (!TextUtil.isJavaSuitable(p[counter])) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (p[counter].length() <= 0) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (v[counter].length() > 0 && !TextUtil.isJavaIdentifier(v[counter])) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            ++counter;
        }
        this.param = p;
        this.var = v;
    }

    private void parseJavaParam(String str) {
        StringTokenizer token = new StringTokenizer(str, ";,");
        String[] p = new String[token.countTokens()];
        String[] v = new String[token.countTokens()];
        int counter = 0;
        while (token.hasMoreTokens()) {
            StringTokenizer st = new StringTokenizer(token.nextToken());
            if (st.countTokens() > 2 || st.countTokens() <= 0) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (st.countTokens() == 2) {
                p[counter] = st.nextToken();
                v[counter] = st.nextToken();
            } else if (st.countTokens() == 1) {
                p[counter] = st.nextToken();
                v[counter] = "";
            }
            if (p[counter].equals("void")) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (TextUtil.isJavaKeyword(v[counter])) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (p[counter].endsWith("[]")) {
                if (p[counter].length() == 2 || p[counter].length() > 2 && !TextUtil.isJavaSuitable(p[counter].substring(0, p[counter].length() - 2))) {
                    this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                    this.param = new String[0];
                    this.var = new String[0];
                    return;
                }
            } else if (!TextUtil.isJavaSuitable(p[counter])) {
                int iIndex = p[counter].lastIndexOf(".");
                if (iIndex == -1) {
                    this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                    this.param = new String[0];
                    this.var = new String[0];
                    return;
                }
                String paramType = p[counter].substring(iIndex + 1);
                if (!TextUtil.isJavaSuitable(paramType)) {
                    this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                    this.param = new String[0];
                    this.var = new String[0];
                    return;
                }
            }
            if (p[counter].length() <= 0) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            if (v[counter].length() > 0 && !TextUtil.isJavaIdentifier(v[counter])) {
                this.methodError = ILLEGAL_PARAMETER_DECLARATION;
                this.param = new String[0];
                this.var = new String[0];
                return;
            }
            ++counter;
        }
        this.param = p;
        this.var = v;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String fullMethodName = this.name;
        fullMethodName = String.valueOf(fullMethodName) + "(";
        String[] param = this.getParameters();
        int i = 0;
        while (i < param.length) {
            fullMethodName = String.valueOf(fullMethodName) + TextUtil.getNameWithoutPackage(param[i]);
            if (i != param.length - 1) {
                fullMethodName = String.valueOf(fullMethodName) + ",";
            }
            ++i;
        }
        fullMethodName = String.valueOf(fullMethodName) + ")";
        return fullMethodName;
    }

    public String getReturnType() {
        return this.rType;
    }

    public String[] getParameters() {
        return this.param;
    }

    public String[] getParameterVariables() {
        return this.var;
    }

    public String getStatus() {
        StringBuffer buff = new StringBuffer();
        buff.append("Name: ");
        if (this.name.length() == 0) {
            buff.append("<<empty>>");
        } else {
            buff.append(this.name);
        }
        buff.append("\n\n");
        buff.append("Type:\n");
        if (this.isEmpty()) {
            buff.append("EMPTY").append("\n");
        } else {
            buff.append("Method -- ").append(this.getMethodError()).append("\n");
        }
        buff.append("\n");
        if (this.isPublic) {
            buff.append("public ");
        }
        if (this.isProtected) {
            buff.append("protected ");
        }
        if (this.isPackage) {
            buff.append("package ");
        }
        if (this.isPrivate) {
            buff.append("private ");
        }
        if (this.isStatic) {
            buff.append("static ");
        }
        if (this.isFinal) {
            buff.append("final ");
        }
        if (this.isAbstract) {
            buff.append("abstract ");
        }
        if (this.isNative) {
            buff.append("native ");
        }
        if (this.isTransient) {
            buff.append("transient ");
        }
        if (this.isVolatile) {
            buff.append("volatile ");
        }
        if (this.isSynchronized) {
            buff.append("synchronized ");
        }
        buff.append("\nReturn type: ");
        if (this.getReturnType().length() == 0) {
            buff.append("<<empty>>");
        } else {
            buff.append(this.getReturnType());
        }
        buff.append("\n\nParameters:\n");
        if (this.param.length == 0) {
            buff.append("<<empty>>");
        } else {
            int i = 0;
            while (i < this.param.length) {
                if (this.var[i].length() != 0) {
                    buff.append(this.var[i]).append(" : ").append(this.param[i]);
                } else {
                    buff.append(this.param[i]);
                }
                if (i != this.param.length - 1) {
                    buff.append(", ");
                }
                ++i;
            }
        }
        return buff.toString();
    }

    public void showStatus() {
        JOptionPane.showMessageDialog(null, this.getStatus());
    }

    public String getMethodError() {
        if (this.methodError == EMPTY_DECLARATION) {
            return "Not a method declaration";
        }
        return this.methodError;
    }

    public int getVisibility() {
        if (this.isPublic) {
            return 1;
        }
        if (this.isPackage) {
            return 3;
        }
        if (this.isProtected) {
            return 2;
        }
        if (this.isPrivate) {
            return 0;
        }
        return 0;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isEmpty() {
        return this.methodError == EMPTY_DECLARATION;
    }

    private boolean setSignifierMethod(String str, boolean adjustType) {
        if (str.equalsIgnoreCase("public")) {
            boolean bl = this.isPublic = !this.isPrivate && !this.isProtected && !this.isPackage;
            if (!this.isPublic) {
                if (adjustType) {
                    this.methodError = INVALID_METHOD_DECLARATION;
                }
                return false;
            }
        } else if (str.equalsIgnoreCase("protected")) {
            boolean bl = this.isProtected = !this.isPublic && !this.isPackage && !this.isPrivate;
            if (!this.isProtected) {
                if (adjustType) {
                    this.methodError = INVALID_METHOD_DECLARATION;
                }
                return false;
            }
        } else if (str.equalsIgnoreCase("package")) {
            boolean bl = this.isPackage = !this.isPublic && !this.isProtected && !this.isPrivate;
            if (!this.isPackage) {
                if (adjustType) {
                    this.methodError = INVALID_METHOD_DECLARATION;
                }
                return false;
            }
        } else if (str.equalsIgnoreCase("private")) {
            boolean bl = this.isPrivate = !this.isPublic && !this.isProtected && !this.isPackage;
            if (!this.isPrivate) {
                if (adjustType) {
                    this.methodError = INVALID_METHOD_DECLARATION;
                }
                return false;
            }
        } else if (str.equalsIgnoreCase("static")) {
            this.isStatic = true;
        } else if (str.equalsIgnoreCase("native")) {
            this.isNative = true;
        } else if (str.equalsIgnoreCase("synchronized")) {
            this.isSynchronized = true;
        } else if (str.equalsIgnoreCase("abstract")) {
            if (this.isFinal) {
                if (adjustType) {
                    this.methodError = "Method is declared to be abstract AND final";
                }
                return false;
            }
            this.isAbstract = true;
        } else if (str.equalsIgnoreCase("final")) {
            if (this.isAbstract) {
                if (adjustType) {
                    this.methodError = "Method is declared to be abstract AND final";
                }
                return false;
            }
            this.isFinal = true;
        } else {
            if (adjustType) {
                this.methodError = INVALID_METHOD_DECLARATION;
            }
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.methodError != EMPTY_DECLARATION && this.methodError != INVALID_METHOD_DECLARATION;
    }

    public static String userReadableSignature(UMLMethod method) {
        String signature = null;
        Iterator it = method.iteratorOfParam();
        while (it.hasNext()) {
            UMLParam param = (UMLParam)it.next();
            String paramText = String.valueOf(param.getName()) + ": " + param.getParamType().getName();
            signature = signature != null ? String.valueOf(signature) + ", " + paramText : paramText;
        }
        signature = signature == null ? String.valueOf(method.getName()) + "(): " : String.valueOf(method.getName()) + "( " + signature + " ): ";
        signature = String.valueOf(signature) + method.getResultType().getName();
        return signature;
    }
}

