/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.tools.generators;

import de.uni_paderborn.fujaba.basic.TemplateCodeBlock;
import de.uni_paderborn.fujaba.basic.TemplateFile;
import de.uni_paderborn.fujaba.basic.TemplateManager;
import de.upb.tools.fca.FHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AssocsDocGenerator {
    private static final transient Logger log;
    private TemplateFile assocsTemplate = TemplateManager.get().getTemplate("Templates/AssocTemplateFCA.tpl");
    private TemplateFile htmlTemplate = TemplateManager.get().getTemplate("Templates/AssocsDocumentation.tpl");
    private FHashMap parameter;
    private static String PATH;
    private static String INDEX_FILENAME;
    private static String SHORTCUTS_FILENAME;
    private static String MAIN_FILENAME;
    private static String ONE_FILENAME;
    private static String MANY_FILENAME;
    private static String ATTR_QUAL_ONE_FILENAME;
    private static String QUAL_ONE_FILENAME;
    private static String ATTR_QUAL_MANY_FILENAME;
    private static String QUAL_MANY_FILENAME;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.tools.generators.AssocsDocGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        PATH = "";
        INDEX_FILENAME = "Index.html";
        SHORTCUTS_FILENAME = "Shortcuts.html";
        MAIN_FILENAME = "Main.html";
        ONE_FILENAME = "One.html";
        MANY_FILENAME = "Many.html";
        ATTR_QUAL_ONE_FILENAME = "Attr_Qual_One.html";
        QUAL_ONE_FILENAME = "Qual_One.html";
        ATTR_QUAL_MANY_FILENAME = "Attr_Qual_Many.html";
        QUAL_MANY_FILENAME = "Qual_Many.html";
    }

    public AssocsDocGenerator() {
        this.initParameter();
    }

    public void initParameter() {
        this.parameter = new FHashMap();
        this.parameter.put("$RIGHTROLE$", "rightRole");
        this.parameter.put("$RIGHTROLES$", "rightRoles");
        this.parameter.put("$RIGHTROLES_SUFFIX$", "RightRoles");
        this.parameter.put("$RIGHTCLASS$", "RightClass");
        this.parameter.put("$KEYTYPE$", "KeyType");
        this.parameter.put("$GETKEY$", "getKey");
        this.parameter.put("$INSERT$", "&lt;method to insert&gt;");
        this.parameter.put("$REMOVE$", "&lt;method to remove&gt;");
        this.parameter.put("$CONTAINER$", "FHashSet");
        this.parameter.put("$LINKLISTCODE$", " [&& !hasInRightRoles (value)]");
        this.parameter.put("$ONE_FILENAME$", ONE_FILENAME);
        this.parameter.put("$MANY_FILENAME$", MANY_FILENAME);
        this.parameter.put("$AQO_FILENAME$", ATTR_QUAL_ONE_FILENAME);
        this.parameter.put("$QO_FILENAME$", QUAL_ONE_FILENAME);
        this.parameter.put("$AQM_FILENAME$", ATTR_QUAL_MANY_FILENAME);
        this.parameter.put("$QM_FILENAME$", QUAL_MANY_FILENAME);
        this.parameter.put("$SHORTCUTS_FILENAME$", SHORTCUTS_FILENAME);
        this.parameter.put("$MAIN_FILENAME$", MAIN_FILENAME);
        TemplateCodeBlock template = this.assocsTemplate.getFromCodeBlocks("assoc-set-v1");
        this.parameter.put("$assoc-set-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-get-v1");
        this.parameter.put("$assoc-get-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-hasIn-v1");
        this.parameter.put("$assoc-hasIn-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-hasIn-v1A");
        this.parameter.put("$assoc-hasIn-v1A$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-hasIn-v2");
        this.parameter.put("$assoc-hasIn-v2$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-hasIn-v3");
        this.parameter.put("$assoc-hasIn-v3$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-hasIn-v4");
        this.parameter.put("$assoc-hasIn-v4$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-hasIn-v5");
        this.parameter.put("$assoc-hasIn-v5$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-hasKeyIn-v1");
        this.parameter.put("$assoc-hasKeyIn-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-iteratorOf-v1");
        this.parameter.put("$assoc-iteratorOf-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-iteratorOf-v2");
        this.parameter.put("$assoc-iteratorOf-v2$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-iteratorOf-v3");
        this.parameter.put("$assoc-iteratorOf-v3$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-keysOf-v1");
        this.parameter.put("$assoc-keysOf-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-entriesOf-v1");
        this.parameter.put("$assoc-entriesOf-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-sizeOf-v1");
        this.parameter.put("$assoc-sizeOf-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-sizeOf-v2");
        this.parameter.put("$assoc-sizeOf-v2$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-addTo-v1");
        this.parameter.put("$assoc-addTo-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-addTo-v2");
        this.parameter.put("$assoc-addTo-v2$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-addTo-v3");
        this.parameter.put("$assoc-addTo-v3$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-addTo-v4");
        this.parameter.put("$assoc-addTo-v4$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-addTo-v5");
        this.parameter.put("$assoc-addTo-v5$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-addTo-v6");
        this.parameter.put("$assoc-addTo-v6$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-getFrom-v1");
        this.parameter.put("$assoc-getFrom-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeFrom-v1");
        this.parameter.put("$assoc-removeFrom-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeFrom-v2");
        this.parameter.put("$assoc-removeFrom-v2$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeFrom-v3");
        this.parameter.put("$assoc-removeFrom-v3$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeFrom-v4");
        this.parameter.put("$assoc-removeFrom-v4$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeFrom-v5");
        this.parameter.put("$assoc-removeFrom-v5$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeKeyFrom-v1");
        this.parameter.put("$assoc-removeKeyFrom-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeKeyFrom-v2");
        this.parameter.put("$assoc-removeKeyFrom-v2$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeAllFrom-v1");
        this.parameter.put("$assoc-removeAllFrom-v1$", template.getSourceCode(this.parameter));
        template = this.assocsTemplate.getFromCodeBlocks("assoc-removeAllFrom-v2");
        this.parameter.put("$assoc-removeAllFrom-v2$", template.getSourceCode(this.parameter));
    }

    public void generateHtmlFiles() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Generating Fujaba association documentation...");
        }
        TemplateCodeBlock htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("Index");
        this.writeFile(String.valueOf(PATH) + INDEX_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("Shortcuts");
        this.writeFile(String.valueOf(PATH) + SHORTCUTS_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("Main");
        this.writeFile(String.valueOf(PATH) + MAIN_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("One");
        this.writeFile(String.valueOf(PATH) + ONE_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("Many");
        this.writeFile(String.valueOf(PATH) + MANY_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("One-Qualified-Intern");
        this.writeFile(String.valueOf(PATH) + ATTR_QUAL_ONE_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("Many-Qualified-Intern");
        this.writeFile(String.valueOf(PATH) + ATTR_QUAL_MANY_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("One-Qualified-Extern");
        this.writeFile(String.valueOf(PATH) + QUAL_ONE_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
        htmlCodeBlock = this.htmlTemplate.getFromCodeBlocks("Many-Qualified-Extern");
        this.writeFile(String.valueOf(PATH) + QUAL_MANY_FILENAME, htmlCodeBlock.getSourceCode(this.parameter));
    }

    public void writeFile(String fileName, String content) {
        try {
            File file = new File(fileName);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(content);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            log.error((Object)("Error writing file " + fileName));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            PATH = args[0];
        }
        AssocsDocGenerator assocsDocGenerator = new AssocsDocGenerator();
        assocsDocGenerator.generateHtmlFiles();
    }
}

