/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.ConfigurableFilter;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.FilterManager;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.uni_paderborn.fujaba.views.gui.DiagramItemRenderer;
import de.uni_paderborn.fujaba.views.gui.FilterRenderer;
import de.uni_paderborn.fujaba.views.gui.SmallFilterEditorDialog;
import de.upb.tools.fca.FDuplicatedTreeMap;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewDefinitionDialog
extends FujabaDialog
implements ActionListener,
ChangeListener,
ItemListener,
WindowListener {
    private JList diagItemsList = null;
    private JList startItemsList = null;
    private JComboBox filterComboBox = null;
    private JCheckBox updateCheckBox = null;
    private JTextField nContextTextField = null;
    private JRadioButton nContextRadioButton = null;
    private JRadioButton maxContextRadioButton = null;
    private ButtonGroup contextButtonGroup = null;
    private JButton editButton = null;
    private JTextField nameField = null;
    private UMLDiagram mainDiagram = null;
    private FHashSet sourceDiagrams;
    private ViewDefinition view = null;

    public ViewDefinitionDialog(JFrame parentFrame) {
        super(parentFrame);
        this.setModal(true);
        this.setTitle("Edit ViewDefinition");
        this.addWindowListener(this);
        this.guiBuild();
    }

    public ViewDefinitionDialog(JFrame parentFrame, String sTitle) {
        this(parentFrame);
        this.setTitle(sTitle);
    }

    public void guiBuild() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.guiPanelOkCancelHelp(), "South");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField();
        namePanel.add(new JLabel("Definition Name"));
        namePanel.add(this.nameField);
        this.getContentPane().add((Component)namePanel, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        JPanel filterPanel = new JPanel();
        filterPanel.setBorder(new TitledBorder("Filter"));
        this.filterComboBox = new JComboBox();
        this.filterComboBox.setActionCommand("filter");
        this.filterComboBox.addActionListener(this);
        this.filterComboBox.addItemListener(this);
        this.filterComboBox.setRenderer(FilterManager.getListCellRenderer());
        filterPanel.add(this.filterComboBox);
        this.editButton = new JButton();
        this.editButton.setText("Edit Filter");
        this.editButton.setActionCommand("editFilter");
        this.editButton.addActionListener(this);
        JPanel lowerPanel = new JPanel();
        lowerPanel.add(this.editButton);
        filterPanel.add(lowerPanel);
        mainPanel.add((Component)filterPanel, constraints);
        JPanel updatePanel = new JPanel();
        updatePanel.setBorder(new TitledBorder("Update View"));
        this.updateCheckBox = new JCheckBox();
        this.updateCheckBox.setSelected(true);
        this.updateCheckBox.setText("Keep View up-to-date");
        updatePanel.add(this.updateCheckBox);
        constraints.gridx = 3;
        constraints.anchor = 12;
        mainPanel.add((Component)updatePanel, constraints);
        JPanel diagItemsPanel = new JPanel();
        diagItemsPanel.setBorder(new TitledBorder("Diagram Items"));
        diagItemsPanel.setLayout(new GridLayout(1, 1, 0, 0));
        JScrollPane diagItemsScrollPane = new JScrollPane();
        diagItemsScrollPane.setBorder(new BevelBorder(1));
        this.diagItemsList = new JList();
        this.diagItemsList.setModel(new DefaultListModel());
        this.diagItemsList.setCellRenderer(new DiagramItemRenderer());
        diagItemsScrollPane.getViewport().setView(this.diagItemsList);
        diagItemsPanel.add(diagItemsScrollPane);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 2;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 1;
        mainPanel.add((Component)diagItemsPanel, constraints);
        JPanel startItemsPanel = new JPanel();
        startItemsPanel.setBorder(new TitledBorder("0-Context"));
        startItemsPanel.setLayout(new GridLayout(1, 1, 0, 0));
        JScrollPane startItemsScrollPane = new JScrollPane();
        startItemsScrollPane.setBorder(new BevelBorder(1));
        this.startItemsList = new JList();
        this.startItemsList.setCellRenderer(new DiagramItemRenderer());
        this.startItemsList.setModel(new DefaultListModel());
        startItemsScrollPane.getViewport().setView(this.startItemsList);
        startItemsPanel.add(startItemsScrollPane);
        constraints.gridx = 3;
        constraints.anchor = 13;
        mainPanel.add((Component)startItemsPanel, constraints);
        JPanel itemsButtonPanel = new JPanel();
        itemsButtonPanel.setLayout(new GridLayout(3, 1, 0, 0));
        JButton addItemButton = new JButton();
        addItemButton.setText("Add >");
        addItemButton.setActionCommand("addItem");
        addItemButton.addActionListener(this);
        itemsButtonPanel.add(addItemButton);
        JButton removeItemButton = new JButton();
        removeItemButton.setText("< Remove");
        removeItemButton.setActionCommand("removeItem");
        removeItemButton.addActionListener(this);
        itemsButtonPanel.add(removeItemButton);
        JButton moreItemsButton = new JButton();
        moreItemsButton.setText("Get more items");
        moreItemsButton.setActionCommand("moreItems");
        moreItemsButton.addActionListener(this);
        itemsButtonPanel.add(moreItemsButton);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 10;
        constraints.fill = 0;
        mainPanel.add((Component)itemsButtonPanel, constraints);
        JPanel contextPanel = this.createContextPanel();
        constraints.gridy = 0;
        constraints.fill = 0;
        mainPanel.add((Component)contextPanel, constraints);
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    private JPanel createContextPanel() {
        JPanel contextPanel = new JPanel();
        contextPanel.setBorder(new TitledBorder("Context"));
        contextPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        this.contextButtonGroup = new ButtonGroup();
        this.nContextRadioButton = new JRadioButton();
        this.nContextRadioButton.setActionCommand("nContext");
        this.nContextRadioButton.addChangeListener(this);
        this.contextButtonGroup.add(this.nContextRadioButton);
        contextPanel.add((Component)this.nContextRadioButton, constraints);
        this.nContextTextField = new JTextField();
        this.nContextTextField.setEnabled(false);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        contextPanel.add((Component)this.nContextTextField, constraints);
        this.maxContextRadioButton = new JRadioButton();
        this.maxContextRadioButton.setText("max. Context");
        this.maxContextRadioButton.setActionCommand("maxContext");
        this.maxContextRadioButton.addChangeListener(this);
        this.contextButtonGroup.add(this.maxContextRadioButton);
        this.maxContextRadioButton.setSelected(true);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        contextPanel.add((Component)this.maxContextRadioButton, constraints);
        return contextPanel;
    }

    public void unparse() {
        ViewDefinition view = this.getView();
        if (view != null) {
            this.nameField.setText(view.getName());
        }
        DefaultListModel diagItemsModel = (DefaultListModel)this.diagItemsList.getModel();
        DefaultListModel startItemsModel = (DefaultListModel)this.startItemsList.getModel();
        diagItemsModel.removeAllElements();
        startItemsModel.removeAllElements();
        if (this.filterComboBox.getModel() != null && this.filterComboBox.getModel() instanceof FilterManager.FMListModel) {
            ((FilterManager.FMListModel)this.filterComboBox.getModel()).removeYou();
        }
        this.filterComboBox.setModel(FilterManager.get().getListModel(this.mainDiagram));
        this.filterComboBox.setRenderer(new FilterRenderer(view != null ? view.getFilter() : null));
        if (view != null && view.getFilter() != null) {
            Filter insert = view.getFilter();
            int size = this.filterComboBox.getItemCount();
            int i = size - 1;
            while (i >= size) {
                Filter filter = (Filter)this.filterComboBox.getItemAt(i);
                if (filter.getName() != null && filter.getName().equals(insert.getName())) {
                    this.filterComboBox.removeItem(filter);
                }
                --i;
            }
            this.filterComboBox.addItem(insert);
            this.filterComboBox.setSelectedItem(insert);
        }
        if (view != null && view.getContext() >= 0) {
            this.nContextTextField.setText(String.valueOf(view.getContext()));
            this.nContextRadioButton.setSelected(true);
        } else {
            this.nContextTextField.setText("1");
            this.maxContextRadioButton.setSelected(true);
        }
        UMLDiagram sourceDiag = this.mainDiagram;
        if (sourceDiag == null) {
            this.diagItemsList.setEnabled(false);
        } else {
            this.fillDiagItemsList();
            this.diagItemsList.setEnabled(true);
        }
        if (view != null) {
            this.fillStartItemsList();
        }
    }

    public void parse() {
        ViewDefinition view = this.getView();
        if (view == null) {
            view = new ViewDefinition();
        }
        view.setName(this.nameField.getText().trim());
        view.setUpdate(this.updateCheckBox.isSelected());
        if (this.maxContextRadioButton.isSelected()) {
            view.setContext(-1);
        } else {
            view.setContext(Integer.valueOf(this.nContextTextField.getText()));
        }
        HashSet viewStartItems = new HashSet();
        Iterator itemIter = view.iteratorOfStartItems();
        while (itemIter.hasNext()) {
            viewStartItems.add(itemIter.next());
        }
        HashSet selectedStartItems = new HashSet();
        DefaultListModel model = (DefaultListModel)this.startItemsList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            Object obj = model.getElementAt(i);
            if (obj instanceof UMLDiagramItem) {
                selectedStartItems.add(obj);
            }
            ++i;
        }
        viewStartItems.removeAll(selectedStartItems);
        itemIter = viewStartItems.iterator();
        while (itemIter.hasNext()) {
            view.removeFromStartItems((UMLDiagramItem)itemIter.next());
        }
        itemIter = selectedStartItems.iterator();
        while (itemIter.hasNext()) {
            UMLDiagramItem tmpItem = (UMLDiagramItem)itemIter.next();
            view.addToItems(tmpItem);
            view.addToStartItems(tmpItem);
        }
        view.setFilter((Filter)this.filterComboBox.getSelectedItem());
        this.setView(view);
    }

    private void fillDiagItemsList() {
        ViewDefinition view = this.getView();
        UMLDiagram sourceDiag = null;
        FDuplicatedTreeMap elements = new FDuplicatedTreeMap();
        FDuplicatedTreeMap selected = new FDuplicatedTreeMap();
        DefaultListModel model = (DefaultListModel)this.diagItemsList.getModel();
        int selItems = 0;
        model.removeAllElements();
        Iterator diagIter = this.iteratorOfSourceDiagrams();
        while (diagIter.hasNext()) {
            sourceDiag = (UMLDiagram)diagIter.next();
            Iterator itemIter = sourceDiag.iteratorOfElements();
            while (itemIter.hasNext()) {
                ASGElement asgElement = (ASGElement)itemIter.next();
                if (!(asgElement instanceof UMLDiagramItem)) continue;
                UMLDiagramItem item = (UMLDiagramItem)asgElement;
                if (view != null && view.hasInStartItems(item)) continue;
                if (!this.isSelected(item, sourceDiag)) {
                    elements.put(DiagramItemRenderer.getStringRepresentation(item), item);
                    continue;
                }
                selected.put(DiagramItemRenderer.getStringRepresentation(item), item);
            }
        }
        Iterator iter = selected.values().iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
            ++selItems;
        }
        iter = elements.values().iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        if (selItems > 0) {
            this.diagItemsList.setSelectionInterval(0, selItems - 1);
        }
        elements.clear();
        selected.clear();
    }

    private void fillStartItemsList() {
        ViewDefinition view = this.getView();
        DefaultListModel model = (DefaultListModel)this.startItemsList.getModel();
        FDuplicatedTreeMap elements = new FDuplicatedTreeMap();
        FDuplicatedTreeMap selected = new FDuplicatedTreeMap();
        int selItems = 0;
        if (view == null) {
            return;
        }
        Iterator itemIter = view.iteratorOfStartItems();
        while (itemIter.hasNext()) {
            UMLDiagramItem item = (UMLDiagramItem)itemIter.next();
            if (!this.isSelected(item, view.getDiagram())) {
                elements.put(DiagramItemRenderer.getStringRepresentation(item), item);
                continue;
            }
            selected.put(DiagramItemRenderer.getStringRepresentation(item), item);
        }
        Iterator iter = selected.values().iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
            ++selItems;
        }
        iter = elements.values().iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        if (selItems > 0) {
            this.startItemsList.setSelectionInterval(0, selItems - 1);
        }
        elements.clear();
        selected.clear();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("addItem")) {
            this.addItemAction();
        } else if (command.equals("removeItem")) {
            this.removeItemAction();
        } else if (command.equals("moreItems")) {
            this.moreItemsAction();
        } else if (command.equals("filter")) {
            this.filterAction();
        } else if (command.equals("editFilter")) {
            this.editFilterAction();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.nContextTextField.setEnabled(this.nContextRadioButton.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        this.filterAction();
    }

    private void filterAction() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.filterComboBox.getModel();
        this.editButton.setEnabled(model.getSelectedItem() != null && model.getSelectedItem() instanceof ConfigurableFilter);
    }

    private void editFilterAction() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.filterComboBox.getModel();
        Filter filter = (Filter)model.getSelectedItem();
        if (filter == null) {
            return;
        }
        SmallFilterEditorDialog editor = new SmallFilterEditorDialog(null);
        editor.setFilter(filter);
        editor.showCentered();
    }

    private boolean addItemAction() {
        Object[] sel = this.diagItemsList.getSelectedValues();
        if (sel == null || sel.length == 0) {
            return false;
        }
        DefaultListModel sourceModel = (DefaultListModel)this.diagItemsList.getModel();
        DefaultListModel targetModel = (DefaultListModel)this.startItemsList.getModel();
        int i = sel.length - 1;
        while (i > -1) {
            sourceModel.removeElement(sel[i]);
            targetModel.add(0, sel[i]);
            --i;
        }
        this.startItemsList.setSelectionInterval(0, sel.length - 1);
        return true;
    }

    private boolean removeItemAction() {
        Object[] sel = this.startItemsList.getSelectedValues();
        if (sel == null || sel.length == 0) {
            return false;
        }
        DefaultListModel targetModel = (DefaultListModel)this.diagItemsList.getModel();
        DefaultListModel sourceModel = (DefaultListModel)this.startItemsList.getModel();
        int i = sel.length - 1;
        while (i > -1) {
            sourceModel.removeElement(sel[i]);
            targetModel.add(0, sel[i]);
            --i;
        }
        this.diagItemsList.setSelectionInterval(0, sel.length - 1);
        return true;
    }

    private boolean moreItemsAction() {
        Iterator diagIter = this.iteratorOfSourceDiagrams();
        while (diagIter.hasNext()) {
            try {
                UMLDiagram tmpDiag = ((ViewDiagram)diagIter.next()).getDiagram();
                this.addToSourceDiagrams(tmpDiag);
                this.fillDiagItemsList();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean hasInSourceDiagrams(UMLDiagram value) {
        return this.sourceDiagrams != null && value != null && this.sourceDiagrams.contains(value);
    }

    public Iterator iteratorOfSourceDiagrams() {
        return this.sourceDiagrams == null ? FEmptyIterator.get() : this.sourceDiagrams.iterator();
    }

    public int sizeOfSourceDiagrams() {
        return this.sourceDiagrams == null ? 0 : this.sourceDiagrams.size();
    }

    public boolean addToSourceDiagrams(UMLDiagram value) {
        boolean changed = false;
        if (value != null) {
            if (this.sourceDiagrams == null) {
                this.sourceDiagrams = new FHashSet();
                this.mainDiagram = value;
            }
            changed = this.sourceDiagrams.add(value);
        }
        if (changed) {
            this.unparse();
        }
        return changed;
    }

    public boolean removeFromSourceDiagrams(UMLDiagram value) {
        boolean changed = false;
        if (this.sourceDiagrams != null && value != null) {
            changed = this.sourceDiagrams.remove(value);
        }
        if (changed) {
            this.unparse();
        }
        return changed;
    }

    public void removeAllFromSourceDiagrams() {
        Iterator iter = this.iteratorOfSourceDiagrams();
        while (iter.hasNext()) {
            UMLDiagram tmpValue = (UMLDiagram)iter.next();
            this.removeFromSourceDiagrams(tmpValue);
        }
    }

    public void setView(ViewDefinition view) {
        if (this.view != view) {
            this.view = view;
            this.unparse();
        }
    }

    public ViewDefinition getView() {
        return this.view;
    }

    private boolean isSelected(UMLDiagramItem item, UMLDiagram diag) {
        Iterator fsaIter = item.iteratorOfFsaObjects();
        while (fsaIter.hasNext()) {
            FSAObject obj = (FSAObject)fsaIter.next();
            if (!SelectionManager.get().hasInSelection(obj)) continue;
            return true;
        }
        return false;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        ComboBoxModel model;
        ComboBoxModel comboBoxModel = model = this.filterComboBox != null ? this.filterComboBox.getModel() : null;
        if (model != null && model instanceof FilterManager.FMListModel) {
            ((FilterManager.FMListModel)model).removeYou();
        }
    }
}

