/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.cf;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.CompositeFilter;
import de.uni_paderborn.fujaba.views.cf.CFEndNode;
import de.uni_paderborn.fujaba.views.cf.CFNode;
import de.uni_paderborn.fujaba.views.cf.CFStartNode;
import de.uni_paderborn.fujaba.views.cf.CFTransition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CFDiagram
extends UMLDiagram
implements Cloneable {
    private CompositeFilter filter;
    private CFEndNode endNode = null;
    private CFStartNode startNode = null;

    public boolean setFilter(CompositeFilter value) {
        if (this.filter != value) {
            if (this.filter != null) {
                CompositeFilter oldValue = this.filter;
                this.filter = null;
                oldValue.setCFDiagram(null);
            }
            this.filter = value;
            if (value != null) {
                this.filter.setCFDiagram(this);
            }
            return true;
        }
        return false;
    }

    public CompositeFilter getFilter() {
        return this.filter;
    }

    public boolean setEndNode(CFEndNode value) {
        if (value != this.endNode) {
            if (this.endNode != null) {
                CFEndNode oldValue = this.endNode;
                this.endNode = null;
                oldValue.removeFromDiagrams(this);
            }
            this.endNode = value;
            if (value != null) {
                this.addToElements(value);
            }
            return true;
        }
        return false;
    }

    public CFEndNode getEndNode() {
        return this.endNode;
    }

    public boolean setStartNode(CFStartNode value) {
        if (value != this.startNode) {
            if (this.startNode != null) {
                CFStartNode oldValue = this.startNode;
                this.startNode = null;
                oldValue.removeFromDiagrams(this);
            }
            this.startNode = value;
            if (value != null) {
                this.addToElements(value);
            }
            return true;
        }
        return false;
    }

    public CFStartNode getStartNode() {
        return this.startNode;
    }

    public boolean addToElements(UMLDiagramItem item) {
        boolean changed = super.addToElements(item);
        if (changed) {
            if (item instanceof CFStartNode) {
                this.setStartNode((CFStartNode)item);
            } else if (item instanceof CFEndNode) {
                this.setEndNode((CFEndNode)item);
            }
        }
        return changed;
    }

    public boolean removeFromElements(UMLDiagramItem item) {
        boolean changed = super.removeFromElements(item);
        if (changed) {
            if (item == this.getStartNode()) {
                this.setStartNode(null);
            } else if (item == this.getEndNode()) {
                this.setEndNode(null);
            }
        }
        return changed;
    }

    public Set getResults(UMLDiagram diag, UMLDiagramItem item) {
        if (this.getEndNode() == null || this.getStartNode() == null) {
            throw new RuntimeException("CFDiagram must contain both a start- and endnode");
        }
        return this.getEndNode().getResults(diag, item);
    }

    public Object clone() {
        CFDiagram clone = new CFDiagram();
        HashMap<ASGElement, UMLDiagramItem> itemMap = new HashMap<ASGElement, UMLDiagramItem>();
        HashMap<ASGElement, UMLDiagramItem> transitionMap = new HashMap<ASGElement, UMLDiagramItem>();
        UMLDiagramItem tmpItem = null;
        Iterator itemIter = this.iteratorOfElements();
        while (itemIter.hasNext()) {
            ASGElement asgElement = (ASGElement)itemIter.next();
            if (asgElement instanceof CFNode) {
                try {
                    tmpItem = (UMLDiagramItem)((CFNode)asgElement).clone();
                    itemMap.put(asgElement, tmpItem);
                    clone.addToElements(tmpItem);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to clone item " + asgElement + "\nerror: " + e.getMessage());
                }
            }
            if (!(asgElement instanceof CFTransition)) continue;
            try {
                tmpItem = (UMLDiagramItem)((CFTransition)asgElement).clone();
                transitionMap.put(asgElement, tmpItem);
                clone.addToElements(tmpItem);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to clone item " + asgElement + "\nerror: " + e.getMessage());
            }
        }
        if (this.getStartNode() != null) {
            clone.setStartNode((CFStartNode)itemMap.get(this.getStartNode()));
        } else {
            clone.setStartNode(null);
        }
        if (this.getEndNode() != null) {
            clone.setEndNode((CFEndNode)itemMap.get(this.getEndNode()));
        } else {
            clone.setEndNode(null);
        }
        Iterator transIter = transitionMap.entrySet().iterator();
        while (transIter.hasNext()) {
            Map.Entry entry = transIter.next();
            CFTransition orig = (CFTransition)entry.getKey();
            CFTransition copy = (CFTransition)entry.getValue();
            copy.setSource((CFNode)itemMap.get(orig.getSource()));
            copy.setTarget((CFNode)itemMap.get(orig.getTarget()));
        }
        return clone;
    }

    public void removeYou() {
        this.setFilter(null);
        super.removeYou();
    }
}

