/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.beans;

import de.uni_paderborn.fujaba.views.beans.ArrowButton;
import de.uni_paderborn.fujaba.views.beans.IntervalNumberFormat;
import de.uni_paderborn.fujaba.views.beans.NumberTextField;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class NumberInputField
extends JPanel
implements SwingConstants {
    private JPanel mainPanel = new JPanel();
    private NumberTextField input;
    private JButton up;
    private JButton down;
    private JPanel buttonPanel = new JPanel();
    private Number incrValue = null;
    private static final IntervalNumberFormat integerParser = new IntervalNumberFormat(-2.147483648E9, 2.147483647E9);
    private static final IntervalNumberFormat byteParser;
    private static final IntervalNumberFormat longParser;
    private static final IntervalNumberFormat shortParser;
    private static final IntervalNumberFormat doubleParser;
    private static final IntervalNumberFormat floatParser;
    private static final ActionListener upAction;
    private static final ActionListener downAction;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        integerParser.setParseIntegerOnly(true);
        byteParser = new IntervalNumberFormat(-128.0, 127.0);
        byteParser.setParseIntegerOnly(true);
        longParser = new IntervalNumberFormat(-9.223372036854776E18, 9.223372036854776E18);
        longParser.setParseIntegerOnly(true);
        shortParser = new IntervalNumberFormat(-32768.0, 32767.0);
        shortParser.setParseIntegerOnly(true);
        doubleParser = new IntervalNumberFormat(-1.7976931348623157E308, Double.MAX_VALUE);
        floatParser = new IntervalNumberFormat(-3.4028234663852886E38, 3.4028234663852886E38);
        upAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NumberInputField source = (NumberInputField)((Component)e.getSource()).getParent().getParent();
                double oldValue = source.getDoubleValue();
                double incrValue = source.getDoubleIncrValue();
                Double newValue = new Double(oldValue + incrValue);
                source.setValue(newValue);
            }
        };
        downAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NumberInputField source = (NumberInputField)((Component)e.getSource()).getParent().getParent();
                double oldValue = source.getDoubleValue();
                double incrValue = source.getDoubleIncrValue();
                Double newValue = new Double(oldValue - incrValue);
                source.setValue(newValue);
            }
        };
    }

    public NumberInputField() {
        this(6);
    }

    public NumberInputField(int colums) {
        this.setLayout(new FlowLayout(2, 0, 0));
        this.input = new NumberTextField(colums);
        this.add(this.input);
        this.add(this.buttonPanel);
        this.buttonPanel.setLayout(new GridLayout(2, 1));
        this.up = new ArrowButton(1, this);
        this.down = new ArrowButton(5, this);
        this.up.addActionListener(upAction);
        this.down.addActionListener(downAction);
        this.buttonPanel.add(this.up);
        this.buttonPanel.add(this.down);
        this.setIncrValue(new Integer(1));
    }

    public void setValue(Number value) {
        this.input.setValue(value);
    }

    public Number getValue() {
        return this.input.getValue();
    }

    public void setIncrValue(Number value) {
        if (value == null || value.doubleValue() == 0.0) {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
        } else {
            this.up.setEnabled(true);
            this.down.setEnabled(true);
        }
        this.incrValue = value;
    }

    public Number getIncrValue() {
        return this.incrValue;
    }

    protected NumberTextField getInputField() {
        return this.input;
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.mainPanel.setEnabled(flag);
        this.up.setEnabled(flag);
        this.down.setEnabled(flag);
        this.buttonPanel.setEnabled(flag);
        this.input.setEnabled(flag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNumberType(Class type) {
        block44: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                if (type == Integer.TYPE) break block35;
                                                Class<?> clazz = class$0;
                                                if (clazz == null) {
                                                    try {
                                                        clazz = class$0 = Class.forName("java.lang.Integer");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (type != clazz) break block36;
                                            }
                                            this.getInputField().setParser(integerParser);
                                            return;
                                        }
                                        if (type == Byte.TYPE) break block37;
                                        Class<?> clazz = class$1;
                                        if (clazz == null) {
                                            try {
                                                clazz = class$1 = Class.forName("java.lang.Byte");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (type != clazz) break block38;
                                    }
                                    this.getInputField().setParser(byteParser);
                                    return;
                                }
                                if (type == Short.TYPE) break block39;
                                Class<?> clazz = class$2;
                                if (clazz == null) {
                                    try {
                                        clazz = class$2 = Class.forName("java.lang.Short");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (type != clazz) break block40;
                            }
                            this.getInputField().setParser(shortParser);
                            return;
                        }
                        if (type == Long.TYPE) break block41;
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = class$3 = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (type != clazz) break block42;
                    }
                    this.getInputField().setParser(longParser);
                    return;
                }
                if (type == Double.TYPE) break block43;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type != clazz) break block44;
            }
            this.getInputField().setParser(doubleParser);
            return;
        }
        if (type != Float.TYPE) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (type != clazz) throw new RuntimeException("Class type is not a subclass or subtype of Number");
        }
        this.getInputField().setParser(floatParser);
    }

    public void setValue(int value) {
        this.setValue(new Integer(value));
    }

    public void setValue(double value) {
        this.setValue(new Double(value));
    }

    public void setValue(float value) {
        this.setValue(new Float(value));
    }

    public void setValue(long value) {
        this.setValue(new Long(value));
    }

    public void setValue(short value) {
        this.setValue(new Short(value));
    }

    public void setValue(byte value) {
        this.setValue(new Byte(value));
    }

    public int getIntegerValue() {
        Number value = this.getValue();
        return value == null ? 0 : value.intValue();
    }

    public byte getByteValue() {
        Number value = this.getValue();
        return value == null ? (byte)0 : value.byteValue();
    }

    public short getShortValue() {
        Number value = this.getValue();
        return value == null ? (short)0 : value.shortValue();
    }

    public long getLongValue() {
        Number value = this.getValue();
        return value == null ? 0L : value.longValue();
    }

    public double getDoubleValue() {
        Number value = this.getValue();
        return value == null ? 0.0 : value.doubleValue();
    }

    public float getFloatValue() {
        Number value = this.getValue();
        return value == null ? 0.0f : value.floatValue();
    }

    public void setIncrValue(int value) {
        this.setIncrValue(new Integer(value));
    }

    public void setIncrValue(double value) {
        this.setIncrValue(new Double(value));
    }

    public void setIncrValue(float value) {
        this.setIncrValue(new Float(value));
    }

    public void setIncrValue(long value) {
        this.setIncrValue(new Long(value));
    }

    public void setIncrValue(short value) {
        this.setIncrValue(new Short(value));
    }

    public void setIncrValue(byte value) {
        this.setIncrValue(new Byte(value));
    }

    public int getIntegerIncrValue() {
        Number value = this.getIncrValue();
        return value == null ? 0 : value.intValue();
    }

    public byte getByteIncrValue() {
        Number value = this.getIncrValue();
        return value == null ? (byte)0 : value.byteValue();
    }

    public short getShortIncrValue() {
        Number value = this.getIncrValue();
        return value == null ? (short)0 : value.shortValue();
    }

    public long getLongIncrValue() {
        Number value = this.getIncrValue();
        return value == null ? 0L : value.longValue();
    }

    public double getDoubleIncrValue() {
        Number value = this.getIncrValue();
        return value == null ? 0.0 : value.doubleValue();
    }

    public float getFloatIncrValue() {
        Number value = this.getIncrValue();
        return value == null ? 0.0f : value.floatValue();
    }
}

