/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.Toolkit;
import java.beans.PropertyEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BeanTagField
extends JComboBox
implements ListDataListener {
    private PropertyEditor propertyEditor = null;

    public BeanTagField(PropertyEditor propertyEditor) {
        this.setPropertyEditor(propertyEditor);
    }

    public boolean setPropertyEditor(PropertyEditor propertyEditor) {
        if (this.propertyEditor != propertyEditor) {
            this.propertyEditor = propertyEditor;
            this.clear();
            if (propertyEditor != null) {
                this.addItems(propertyEditor.getTags());
                this.setSelectedItem(propertyEditor.getAsText());
            }
            return true;
        }
        return false;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    private void clear() {
        while (this.getItemCount() > 0) {
            this.removeItemAt(0);
        }
    }

    private void addItems(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.addItem(items[i]);
            ++i;
        }
    }

    public void setModel(ComboBoxModel model) {
        ComboBoxModel oldModel = this.getModel();
        if (oldModel != model) {
            if (oldModel != null) {
                oldModel.removeListDataListener(this);
            }
            if (model != null) {
                model.addListDataListener(this);
            }
            super.setModel(model);
        }
    }

    public void contentsChanged(ListDataEvent e) {
        if (e.getIndex0() == -1 && e.getIndex1() == -1) {
            String newValue;
            PropertyEditor editor = this.getPropertyEditor();
            if (editor == null) {
                return;
            }
            String oldValue = editor.getAsText();
            Object item = this.getSelectedItem();
            String string = newValue = item == null ? null : item.toString();
            if (oldValue == null && newValue != null || !oldValue.equals(newValue)) {
                try {
                    editor.setAsText(newValue);
                }
                catch (IllegalArgumentException iae) {
                    Toolkit.getDefaultToolkit().beep();
                    this.setSelectedItem(oldValue);
                }
            }
        }
    }
}

