/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.views.ItemSet;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;
import java.util.Set;

public class ViewDiagram
extends UMLDiagram {
    private UMLDiagram diagram;
    private FHashSet additionalItems;
    private FHashSet viewDefinitions;

    public ViewDiagram() {
    }

    public ViewDiagram(String name, UMLProject project) {
        super(name, project);
    }

    public boolean setDiagram(UMLDiagram value) {
        if (this.diagram != value) {
            if (this.diagram != null) {
                UMLDiagram oldValue = this.diagram;
                this.diagram = null;
                this.removeAllFromViewDefinitions();
                oldValue.removeFromViews(this);
            }
            this.diagram = value;
            this.removeAllFromElements();
            this.removeAllFromAdditionalItems();
            if (value != null) {
                this.diagram.addToViews(this);
                this.update();
            }
            return true;
        }
        return false;
    }

    public UMLDiagram getDiagram() {
        return this.diagram;
    }

    public UMLDiagram getOriginalDiagram() {
        UMLDiagram result = this;
        while (result != null && result instanceof ViewDiagram) {
            result = result.getDiagram();
        }
        return result;
    }

    public boolean addToAdditionalItems(UMLDiagramItem value) {
        boolean changed = false;
        if (value != null) {
            if (this.additionalItems == null) {
                this.additionalItems = new FHashSet();
            }
            if (changed = this.additionalItems.add(value)) {
                value.addToRevAdditionalItems(this);
                this.addToElements(value);
            }
        }
        return changed;
    }

    public boolean hasInAdditionalItems(UMLDiagramItem value) {
        return this.additionalItems != null && value != null && this.additionalItems.contains(value);
    }

    public Iterator iteratorOfAdditionalItems() {
        return this.additionalItems == null ? FEmptyIterator.get() : this.additionalItems.iterator();
    }

    public int sizeOfAdditionalItems() {
        return this.additionalItems == null ? 0 : this.additionalItems.size();
    }

    public boolean removeFromAdditionalItems(UMLDiagramItem value) {
        boolean changed = false;
        if (this.additionalItems != null && value != null && (changed = this.additionalItems.remove(value))) {
            value.removeFromRevAdditionalItems(this);
            this.checkAndRemoveFromItems(value, null);
            if (value instanceof UMLClass) {
                Iterator iter = this.isolateUmlClass((UMLClass)value);
                while (iter.hasNext()) {
                    this.removeFromAdditionalItems((UMLDiagramItem)iter.next());
                }
            }
        }
        return changed;
    }

    public void removeAllFromAdditionalItems() {
        Iterator iter = this.iteratorOfAdditionalItems();
        while (iter.hasNext()) {
            UMLDiagramItem tmpValue = (UMLDiagramItem)iter.next();
            this.removeFromAdditionalItems(tmpValue);
        }
    }

    public boolean addToViewDefinitions(ViewDefinition value) {
        boolean changed = false;
        if (value != null) {
            if (this.viewDefinitions == null) {
                this.viewDefinitions = new FHashSet();
            }
            if (changed = this.viewDefinitions.add(value)) {
                value.setDiagram(this);
            }
        }
        return changed;
    }

    public boolean hasInViewDefinitions(ViewDefinition value) {
        return this.viewDefinitions != null && value != null && this.viewDefinitions.contains(value);
    }

    public Iterator iteratorOfViewDefinitions() {
        return this.viewDefinitions == null ? FEmptyIterator.get() : this.viewDefinitions.iterator();
    }

    public int sizeOfViewDefinitions() {
        return this.viewDefinitions == null ? 0 : this.viewDefinitions.size();
    }

    public boolean removeFromViewDefinitions(ViewDefinition value) {
        boolean changed = false;
        if (this.viewDefinitions != null && value != null && (changed = this.viewDefinitions.remove(value))) {
            value.removeYou();
        }
        return changed;
    }

    public void removeAllFromViewDefinitions() {
        Iterator iter = this.iteratorOfViewDefinitions();
        while (iter.hasNext()) {
            ViewDefinition tmpValue = (ViewDefinition)iter.next();
            this.removeFromViewDefinitions(tmpValue);
        }
    }

    public void flushAdditionalItems() {
        this.removeAllFromAdditionalItems();
        this.update();
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean force) {
        Iterator viewDefIter = this.iteratorOfViewDefinitions();
        ItemSet contextItems = new ItemSet();
        Set tmpSet = null;
        if (this.additionalItems != null) {
            contextItems.addAll(this.additionalItems);
        }
        while (viewDefIter.hasNext()) {
            ViewDefinition viewDef = (ViewDefinition)viewDefIter.next();
            tmpSet = force || viewDef.isUpdate() ? viewDef.evaluate() : viewDef.getItems();
            if (tmpSet == null) continue;
            contextItems.addAll(tmpSet);
        }
        Iterator itemIter = this.iteratorOfElements();
        while (itemIter.hasNext()) {
            ASGElement asgElement = (ASGElement)itemIter.next();
            if (contextItems.contains(asgElement)) {
                contextItems.remove(asgElement);
                continue;
            }
            if (!(asgElement instanceof UMLDiagramItem)) continue;
            this.removeFromItemsWithoutIncrementAge((UMLDiagramItem)asgElement);
        }
    }

    public boolean addToElements(UMLDiagramItem item) {
        boolean changed = false;
        if (item != null && !this.hasInElements(item)) {
            super.addToElements(item);
            if (!(this.getDiagram() != null && this.getDiagram().hasInElements(item) || UMLProject.isLoading())) {
                this.addToAdditionalItems(item);
            }
            item.addToDiagrams(this.getDiagram());
            if (this.getOriginalDiagram() != null) {
                item.addToDiagrams(this.getOriginalDiagram());
            }
        }
        return changed;
    }

    public boolean addToItems(UMLDiagramItem item, UMLDiagram diag) {
        boolean changed = false;
        if (item != null && !this.hasInElements(item)) {
            super.addToElements(item);
            if (!(this.getDiagram() != null && diag.hasInElements(item) || UMLProject.isLoading())) {
                this.addToAdditionalItems(item);
            }
            if (diag != null) {
                item.addToDiagrams(diag);
            }
        }
        return changed;
    }

    public boolean removeFromElements(UMLDiagramItem item) {
        return this.removeFromItemsWithoutIncrementAge(item);
    }

    public boolean removeFromItemsWithoutIncrementAge(UMLDiagramItem item) {
        boolean changed = this.removeFromItemsNoParentSideEffects(item);
        if (changed) {
            item.removeFromDiagrams(this.getDiagram());
            Iterator viewIter = this.iteratorOfViewDefinitions();
            while (viewIter.hasNext()) {
                ViewDefinition viewDef = (ViewDefinition)viewIter.next();
                viewDef.removeFromStartItems(item);
                viewDef.removeFromItems(item);
            }
            this.update();
        }
        return changed;
    }

    public boolean removeFromItemsNoParentSideEffects(UMLDiagramItem item) {
        boolean changed = false;
        if (item != null && this.hasInElements(item)) {
            super.removeFromElementsWithSideEffects(item);
            this.removeFromAdditionalItems(item);
            if (item instanceof UMLClass) {
                Iterator iter = this.isolateUmlClass((UMLClass)item);
                while (iter.hasNext()) {
                    this.removeFromItemsNoParentSideEffects((UMLDiagramItem)iter.next());
                }
            }
            changed = true;
        }
        return changed;
    }

    public void removeAllFromElements() {
        Iterator iter = this.iteratorOfElements();
        while (iter.hasNext()) {
            UMLDiagramItem item = (UMLDiagramItem)iter.next();
            this.removeFromItemsNoParentSideEffects(item);
        }
    }

    protected boolean checkAndRemoveFromItems(UMLDiagramItem item, ViewDefinition ignoreDef) {
        boolean changed = false;
        if (item != null && this.hasInElements(item)) {
            boolean found = false;
            Iterator defIter = this.iteratorOfViewDefinitions();
            while (defIter.hasNext() && !found) {
                ViewDefinition tmpDef = (ViewDefinition)defIter.next();
                if (tmpDef == ignoreDef || !tmpDef.hasInItems(item)) continue;
                found = true;
            }
            if (!found) {
                changed = this.removeFromItemsNoParentSideEffects(item);
            }
        }
        return changed;
    }

    protected boolean checkAndRemoveFromItems(Set items, ViewDefinition ignoreDef) {
        boolean changed = false;
        if (items != null && items.size() > 0 && this.sizeOfElements() > 0) {
            Set tmpItems = null;
            Iterator viewIter = this.iteratorOfViewDefinitions();
            while (viewIter.hasNext() && items.size() > 0) {
                ViewDefinition tmpDef = (ViewDefinition)viewIter.next();
                if (tmpDef == ignoreDef || (tmpItems = tmpDef.getItems()) == null) continue;
                items.removeAll(tmpItems);
            }
            Iterator itemIter = items.iterator();
            while (itemIter.hasNext()) {
                UMLDiagramItem delItem = (UMLDiagramItem)itemIter.next();
                changed |= this.removeFromItemsNoParentSideEffects(delItem);
            }
        }
        return changed;
    }

    public void removeYou() {
        this.setDiagram(null);
        this.removeAllFromViewDefinitions();
        super.removeYou();
    }

    public String toString() {
        return this.getName();
    }

    private Iterator isolateUmlClass(UMLClass item) {
        UMLGeneralization gen;
        ItemSet removeItems = new ItemSet();
        Iterator iter = item.iteratorOfRoles();
        while (iter.hasNext()) {
            UMLRole role = (UMLRole)iter.next();
            UMLAssoc assoc = role.getAssoc();
            removeItems.add(assoc);
        }
        iter = item.iteratorOfRevSubclass();
        while (iter.hasNext()) {
            gen = (UMLGeneralization)iter.next();
            removeItems.add(gen);
        }
        iter = item.iteratorOfRevSuperclass();
        while (iter.hasNext()) {
            gen = (UMLGeneralization)iter.next();
            removeItems.add(gen);
        }
        return removeItems.iterator();
    }

    public void delete() {
        this.removeYou();
    }
}

