/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.views.AbstractConfigurableFilter;
import de.uni_paderborn.fujaba.views.ItemSet;
import java.util.Iterator;
import java.util.Set;

public class TransitionFilter
extends AbstractConfigurableFilter {
    private boolean includePredecessors = true;
    private boolean includeSuccessors = true;

    public TransitionFilter() {
        this.setDescription("This Filter defines its 1-Context by following the in- and outgoing transitions of the activity depending on the current configuration");
    }

    public boolean isForDiagram(UMLDiagram diag) {
        return diag instanceof UMLActivityDiagram;
    }

    public Set grow1Context(UMLDiagram diag, UMLDiagramItem item, ItemSet context) {
        UMLDiagramItem tmpItem;
        UMLTransition aTransition;
        Iterator transitions;
        if (item == null || !(item instanceof UMLActivity) || !diag.hasInElements(item)) {
            return null;
        }
        if (context == null) {
            context = new ItemSet();
        }
        ItemSet newNodes = new ItemSet();
        if (this.includeSuccessors) {
            transitions = ((UMLActivity)item).iteratorOfExit();
            while (transitions.hasNext()) {
                aTransition = (UMLTransition)transitions.next();
                tmpItem = TransitionFilter.tryAddConnection(diag, context, aTransition);
                if (tmpItem == null) continue;
                newNodes.add(tmpItem);
            }
        }
        if (this.includePredecessors) {
            transitions = ((UMLActivity)item).iteratorOfEntry();
            while (transitions.hasNext()) {
                aTransition = (UMLTransition)transitions.next();
                tmpItem = TransitionFilter.tryAddConnection(diag, context, aTransition);
                if (tmpItem == null) continue;
                newNodes.add(tmpItem);
            }
        }
        return newNodes;
    }

    public boolean isIncludeSuccessors() {
        return this.includeSuccessors;
    }

    public void setIncludeSuccessors(boolean inc) {
        this.includeSuccessors = inc;
    }

    public boolean isIncludePredecessors() {
        return this.includePredecessors;
    }

    public void setIncludePredecessors(boolean inc) {
        this.includePredecessors = inc;
    }

    public String getDescription() {
        return "View Filter, that filters along transition edges";
    }
}

