/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.basic.FujabaPropertyChangeSupport;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.views.AssocFilter;
import de.uni_paderborn.fujaba.views.CompositeFilter;
import de.uni_paderborn.fujaba.views.ConfigurableFilter;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.FilterClassLoader;
import de.uni_paderborn.fujaba.views.InheritanceFilter;
import de.uni_paderborn.fujaba.views.LinkFilter;
import de.uni_paderborn.fujaba.views.TransitionFilter;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FPropHashMap;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.pcs.PropertyChangeClient;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class FilterManager
implements PropertyChangeClient {
    private static final transient Logger log;
    public static final transient String SETTINGS_FILE_EXT = "ffs.gz";
    private static transient FilterManager filterManager;
    private FujabaPropertyChangeSupport propertyChangeSupport = null;
    private transient FHashSet scannedFiles;
    private transient FHashMap filters;
    private transient FHashMap settingsFiles;
    private static transient ListCellRenderer renderer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.views.FilterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        filterManager = null;
        renderer = null;
    }

    private FilterManager() {
        this.addToFilters(new InheritanceFilter());
        this.addToFilters(new AssocFilter());
        this.addToFilters(new TransitionFilter());
        this.addToFilters(new LinkFilter());
        this.addToFilters(new CompositeFilter());
    }

    public static FilterManager get() {
        if (filterManager == null) {
            filterManager = new FilterManager();
        }
        return filterManager;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new FujabaPropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new FujabaPropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(e);
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (oldValue == newValue || this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected void firePropertyChange(String name, boolean oldValue, boolean newValue) {
        if (oldValue == newValue || this.propertyChangeSupport == null) {
            return;
        }
        this.firePropertyChange(name, (Object)oldValue, (Object)newValue);
    }

    protected void firePropertyChange(String name, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(name, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String name, double oldValue, double newValue) {
        if (oldValue == newValue || this.propertyChangeSupport == null) {
            return;
        }
        this.firePropertyChange(name, new Double(oldValue), new Double(newValue));
    }

    /*
     * Unable to fully structure code
     */
    public static Filter createInstance(Class filterClass) {
        try {
            return (Filter)filterClass.newInstance();
        }
        catch (Exception var1_1) {
            instance = null;
            methods = filterClass.getMethods();
            i = 0;
            ** while (i < methods.length && instance == null)
        }
lbl-1000:
        // 1 sources

        {
            if (Modifier.isStatic(methods[i].getModifiers()) && methods[i].getParameterTypes().length == 0) {
                v0 = FilterManager.class$1;
                if (v0 == null) {
                    try {
                        v0 = Class.forName("de.uni_paderborn.fujaba.views.Filter");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                }
                if (v0.isAssignableFrom(methods[i].getReturnType())) {
                    try {
                        instance = (Filter)methods[i].invoke(null, new Object[0]);
                    }
                    catch (Exception var4_5) {
                        // empty catch block
                    }
                }
            }
            ++i;
            continue;
        }
lbl24:
        // 1 sources

        return instance;
    }

    public static Filter createInstance(File classFile) {
        return FilterManager.createInstance(FilterClassLoader.get().defineClass(classFile));
    }

    public static Filter createInstance(ZipFile classFile, ZipEntry entry) {
        return FilterManager.createInstance(FilterClassLoader.get().defineClass(classFile, entry));
    }

    public static void saveFilter(ConfigurableFilter filter, OutputStream stream) {
        PrintWriter out = new PrintWriter(stream);
        out.print("# Fujaba-FilterSettings-File (do not alter this file!!!)\n");
        out.print("# Date    : " + new Date(System.currentTimeMillis()).toString() + "\n");
        out.print("-;FilterClass;" + filter.getClass().getName() + "\n");
        out.flush();
        filter.writeSettings(out);
        out.flush();
    }

    public static void saveFilter(ConfigurableFilter filter, File file) throws IOException {
        GZIPOutputStream stream = new GZIPOutputStream(new FileOutputStream(file));
        FilterManager.saveFilter(filter, stream);
        ((OutputStream)stream).flush();
        ((OutputStream)stream).close();
        if (FilterManager.get().hasInFilters(filter)) {
            FilterManager.get().addToSettingsFiles(filter, file);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ConfigurableFilter loadFilter(InputStream stream) {
        filter = null;
        fr = null;
        className = null;
        try {
            fr = new BufferedReader(new InputStreamReader(stream), 32768);
            line = fr.readLine();
            if (line.startsWith("# Fujaba-FilterSettings-File")) ** GOTO lbl24
            throw new Exception("This is not a Fujaba filtersettings (.ffs) file");
lbl-1000:
            // 1 sources

            {
                line = fr.readLine();
                lineTok = new StringTokenizer(line, ";");
                lineTok.nextToken();
                switch (line.charAt(0)) {
                    case '#': {
                        break;
                    }
                    case '-': {
                        variable = lineTok.nextToken();
                        if (variable.compareTo("FilterClass") != 0) continue block10;
                        className = lineTok.nextToken();
                        break;
                    }
                    default: {
                        if (line.trim().length() <= 0) continue block10;
                        throw new Exception("Unexpected line while searching for class name of filter");
                    }
                }
lbl24:
                // 5 sources

                ** while (fr.ready() && className == null)
            }
lbl25:
            // 1 sources

        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("An error occured while reading the settings file.\nMessage: " + e);
        }
        if (className != null) {
            try {
                clazz = FilterClassLoader.get().loadClass(className);
                v0 = FilterManager.class$2;
                if (v0 == null) {
                    try {
                        v0 = FilterManager.class$2 = Class.forName("de.uni_paderborn.fujaba.views.ConfigurableFilter");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                }
                if (!v0.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("The InputStream does not denote a ConfigurableFilter");
                }
                filter = (ConfigurableFilter)FilterManager.createInstance(clazz);
                filter.readSettings(fr);
            }
            catch (ClassNotFoundException e) {
                FilterManager.log.error((Object)("Class not found: " + className));
            }
        }
        return filter;
    }

    public static ConfigurableFilter loadFilter(File file) throws IOException {
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(file));
        ConfigurableFilter filter = FilterManager.loadFilter(stream);
        return filter;
    }

    public void rescanDir() {
        File dir = new File(GeneralPreferences.get().getViewFilterFolder());
        this.rescanDir(dir);
    }

    private void rescanDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles(new AFileFilter());
        int i = 0;
        while (i < files.length) {
            block20: {
                String path = null;
                try {
                    path = files[i].getCanonicalPath();
                }
                catch (IOException ioe) {
                    path = files[i].getAbsolutePath();
                }
                if (!files[i].isDirectory() && (path.toLowerCase().endsWith(".zip") || path.toLowerCase().endsWith(".jar"))) {
                    path = String.valueOf(path) + "[" + files[i].lastModified() + "]";
                }
                if (!this.hasInScannedFiles(path)) {
                    this.addToScannedFiles(path);
                    if (files[i].isDirectory()) {
                        this.rescanDir(files[i]);
                    }
                    if (path.toLowerCase().endsWith(".zip") || path.toLowerCase().endsWith(".jar")) {
                        this.rescanZipFile(files[i]);
                    } else if (path.toLowerCase().endsWith(".ffs.gz")) {
                        try {
                            ConfigurableFilter filter = FilterManager.loadFilter(files[i]);
                            this.addToFilters(filter);
                            this.addToSettingsFiles(filter, files[i]);
                        }
                        catch (IOException e) {
                            log.error((Object)("Found " + path + ", error while loading: " + e));
                        }
                    } else if (path.toLowerCase().endsWith(".class")) {
                        Class clazz = null;
                        try {
                            clazz = FilterClassLoader.get().defineClass(files[i]);
                        }
                        catch (Exception e) {
                            break block20;
                        }
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("de.uni_paderborn.fujaba.views.Filter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz2.isAssignableFrom(clazz)) {
                            this.addToFilters(FilterManager.createInstance(clazz));
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void rescanZipFile(File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception e) {
            return;
        }
        String zipName = null;
        try {
            zipName = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            zipName = file.getAbsolutePath();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            String fileName = null;
            try {
                fileName = new File(name).getCanonicalPath();
            }
            catch (IOException ioe) {
                fileName = new File(name).getAbsolutePath();
            }
            if (this.hasInScannedFiles(String.valueOf(zipName) + ":" + name) || this.hasInScannedFiles(fileName)) continue;
            this.addToScannedFiles(String.valueOf(zipName) + ":" + name);
            InputStream stream = null;
            try {
                stream = zipFile.getInputStream(entry);
            }
            catch (IOException ioe) {
                continue;
            }
            if (name.toLowerCase().endsWith(".ffs.gz")) {
                ConfigurableFilter filter = FilterManager.loadFilter(stream);
                this.addToFilters(filter);
                this.addToSettingsFiles(filter, new File(name));
            } else if (name.toLowerCase().endsWith(".class")) {
                Class clazz = null;
                try {
                    clazz = FilterClassLoader.get().defineClass(stream, entry.getSize());
                }
                catch (Exception e) {
                    continue;
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("de.uni_paderborn.fujaba.views.Filter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(clazz)) {
                    this.addToFilters(FilterManager.createInstance(clazz));
                }
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean addToScannedFiles(String value) {
        boolean changed = false;
        if (value != null) {
            if (this.scannedFiles == null) {
                this.scannedFiles = new FHashSet();
            }
            changed = this.scannedFiles.add(value);
        }
        return changed;
    }

    public boolean hasInScannedFiles(String value) {
        return this.scannedFiles != null && value != null && this.scannedFiles.contains(value);
    }

    public Iterator iteratorOfScannedFiles() {
        return this.scannedFiles == null ? FEmptyIterator.get() : this.scannedFiles.iterator();
    }

    public int sizeOfScannedFiles() {
        return this.scannedFiles == null ? 0 : this.scannedFiles.size();
    }

    protected boolean removeFromScannedFiles(String value) {
        boolean changed = false;
        if (this.scannedFiles != null && value != null) {
            changed = this.scannedFiles.remove(value);
        }
        return changed;
    }

    protected void removeAllFromScannedFiles() {
        Iterator iter = this.iteratorOfScannedFiles();
        while (iter.hasNext()) {
            String tmpValue = (String)iter.next();
            this.removeFromScannedFiles(tmpValue);
        }
    }

    public boolean hasInFilters(Filter value) {
        if (this.filters == null || value == null) {
            return false;
        }
        String name = value.getName();
        return name != null && this.filters.get(name) == value;
    }

    public boolean hasInFilters(String key, Filter value) {
        return this.filters != null && value != null && key != null && this.filters.get(key) == value;
    }

    public boolean hasKeyInFilters(String key) {
        return this.filters != null && key != null && this.filters.containsKey(key);
    }

    public Iterator iteratorOfFilters() {
        return this.filters == null ? FEmptyIterator.get() : this.filters.values().iterator();
    }

    public Iterator keysOfFilters() {
        return this.filters == null ? FEmptyIterator.get() : this.filters.keySet().iterator();
    }

    public Iterator entriesOfFilters() {
        return this.filters == null ? FEmptyIterator.get() : this.filters.entrySet().iterator();
    }

    public int sizeOfFilters() {
        return this.filters == null ? 0 : this.filters.size();
    }

    public Filter getFromFilters(String key) {
        Filter result;
        Filter filter = result = this.filters == null || key == null ? null : (Filter)this.filters.get(key);
        if (result == null) {
            this.rescanDir();
            result = this.filters == null || key == null ? null : (Filter)this.filters.get(key);
        }
        return result;
    }

    public String getKeyFromFilters(Filter value) {
        if (value == null) {
            return null;
        }
        String key = value.getName();
        if (key != null && this.getFromFilters(key) != value) {
            key = null;
        }
        return key;
    }

    public boolean addToFilters(Filter value) {
        boolean changed = false;
        if (value != null) {
            Filter oldValue;
            if (this.filters == null) {
                this.filters = new FPropHashMap(this, "filters");
            }
            if ((oldValue = (Filter)this.filters.put(value.getName(), value)) != value) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromFilters(Filter value) {
        Filter oldValue;
        boolean changed = false;
        if (this.filters != null && value != null && value.getName() != null && (oldValue = (Filter)this.filters.get(value.getName())) == value) {
            this.filters.remove(value.getName());
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromFilters(String key) {
        Filter tmpValue;
        boolean changed = false;
        if (this.filters != null && key != null && (tmpValue = (Filter)this.filters.get(key)) != null) {
            this.filters.remove(key);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromFilters() {
        Iterator iter = this.iteratorOfFilters();
        while (iter.hasNext()) {
            Filter entry = (Filter)iter.next();
            this.removeFromFilters(entry);
        }
    }

    public Filter getFilter(String name) {
        Filter filter = this.getFromFilters(name);
        if (filter != null) {
            Filter clone = null;
            try {
                clone = filter instanceof ConfigurableFilter ? (Filter)((ConfigurableFilter)filter).clone() : FilterManager.createInstance(filter.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return clone;
        }
        return null;
    }

    public boolean hasInSettingsFiles(File value) {
        return this.settingsFiles != null && value != null && this.settingsFiles.containsValue(value);
    }

    public boolean hasInSettingsFiles(ConfigurableFilter key, File value) {
        return this.settingsFiles != null && value != null && key != null && this.settingsFiles.get(key) == value;
    }

    public boolean hasKeyInSettingsFiles(ConfigurableFilter key) {
        return this.settingsFiles != null && key != null && this.settingsFiles.containsKey(key);
    }

    public Iterator iteratorOfSettingsFiles() {
        return this.settingsFiles == null ? FEmptyIterator.get() : this.settingsFiles.values().iterator();
    }

    public Iterator keysOfSettingsFiles() {
        return this.settingsFiles == null ? FEmptyIterator.get() : this.settingsFiles.keySet().iterator();
    }

    public Iterator entriesOfSettingsFiles() {
        return this.settingsFiles == null ? FEmptyIterator.get() : this.settingsFiles.entrySet().iterator();
    }

    public int sizeOfSettingsFiles() {
        return this.settingsFiles == null ? 0 : this.settingsFiles.size();
    }

    public File getFromSettingsFiles(ConfigurableFilter key) {
        return this.settingsFiles == null || key == null ? null : (File)this.settingsFiles.get(key);
    }

    public boolean addToSettingsFiles(ConfigurableFilter key, File value) {
        boolean changed = false;
        if (value != null && key != null) {
            File oldValue;
            if (this.settingsFiles == null) {
                this.settingsFiles = new FPropHashMap(this, "settingsFiles");
            }
            if ((oldValue = (File)this.settingsFiles.put(key, value)) != value) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean addToSettingsFiles(Map.Entry entry) {
        return this.addToSettingsFiles((ConfigurableFilter)entry.getKey(), (File)entry.getValue());
    }

    public boolean removeFromSettingsFiles(File value) {
        boolean changed = false;
        if (this.settingsFiles != null && value != null) {
            Iterator iter = this.entriesOfSettingsFiles();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value) continue;
                changed |= this.removeFromSettingsFiles((ConfigurableFilter)entry.getKey(), value);
            }
        }
        return changed;
    }

    public boolean removeFromSettingsFiles(ConfigurableFilter key, File value) {
        File oldValue;
        boolean changed = false;
        if (this.settingsFiles != null && value != null && key != null && (oldValue = (File)this.settingsFiles.get(key)) == value) {
            this.settingsFiles.remove(key);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromSettingsFiles(ConfigurableFilter key) {
        File tmpValue;
        boolean changed = false;
        if (this.settingsFiles != null && key != null && (tmpValue = (File)this.settingsFiles.get(key)) != null) {
            this.settingsFiles.remove(key);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromSettingsFiles() {
        Iterator iter = this.entriesOfSettingsFiles();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.removeFromSettingsFiles((ConfigurableFilter)entry.getKey(), (File)entry.getValue());
        }
    }

    public ComboBoxModel getListModel(UMLDiagram diagram) {
        while (diagram != null && diagram instanceof ViewDiagram) {
            diagram = ((ViewDiagram)diagram).getDiagram();
        }
        FMListModel model = new FMListModel(diagram);
        this.fillModel(model);
        return model;
    }

    public ComboBoxModel getPrototypeListModel(UMLDiagram diagram) {
        while (diagram != null && diagram instanceof ViewDiagram) {
            diagram = ((ViewDiagram)diagram).getDiagram();
        }
        FMListModel model = new FMListModel(diagram);
        this.fillPrototypeModel(model);
        return model;
    }

    private void fillModel(FMListModel model) {
        UMLDiagram diagram = model.getDiagram();
        while (diagram != null && diagram instanceof ViewDiagram) {
            diagram = ((ViewDiagram)diagram).getDiagram();
        }
        Iterator filterIter = this.iteratorOfFilters();
        while (filterIter.hasNext()) {
            Filter filter = (Filter)filterIter.next();
            if (diagram != null && !filter.isForDiagram(diagram)) continue;
            Filter clone = null;
            try {
                clone = filter instanceof ConfigurableFilter ? (Filter)((ConfigurableFilter)filter).clone() : FilterManager.createInstance(filter.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clone == null) continue;
            model.addElement(clone);
        }
    }

    private void fillPrototypeModel(FMListModel model) {
        UMLDiagram diagram = model.getDiagram();
        while (diagram != null && diagram instanceof ViewDiagram) {
            diagram = ((ViewDiagram)diagram).getDiagram();
        }
        Iterator filterIter = this.iteratorOfFilters();
        while (filterIter.hasNext()) {
            Filter filter = (Filter)filterIter.next();
            if (diagram != null && !filter.isForDiagram(diagram)) continue;
            model.addElement(filter);
        }
    }

    public static ListCellRenderer getListCellRenderer() {
        if (renderer == null) {
            renderer = new FMListCellRenderer();
        }
        return renderer;
    }

    private static final class FMListCellRenderer
    extends DefaultListCellRenderer {
        FMListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            String name = ((Filter)value).getName();
            if (name == null) {
                name = value.toString();
            }
            return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        }
    }

    public static final class FMListModel
    extends DefaultComboBoxModel
    implements PropertyChangeListener {
        private boolean clone = false;
        private UMLDiagram diagram = null;

        public UMLDiagram getDiagram() {
            return this.diagram;
        }

        public FMListModel(UMLDiagram diagram, boolean clone) {
            this(diagram);
            this.clone = clone;
        }

        public FMListModel(UMLDiagram diagram) {
            while (diagram != null && diagram instanceof ViewDiagram) {
                diagram = ((ViewDiagram)diagram).getDiagram();
            }
            this.diagram = diagram;
            FilterManager.get().addPropertyChangeListener("filters", this);
        }

        public void addElement(Object object) {
            if (!(object instanceof Filter)) {
                throw new IllegalArgumentException("Object is not a Filter");
            }
            Filter filter = (Filter)object;
            if (this.diagram != null && !filter.isForDiagram(this.diagram)) {
                throw new IllegalArgumentException("Object is not suited for UMLDiagram " + this.diagram);
            }
            String name = ((Filter)object).getName();
            int size = this.getSize();
            int i = 0;
            while (i < size) {
                String compare = ((Filter)this.getElementAt(i)).getName();
                if (compare.compareTo(name) >= 0) {
                    this.insertElementAt(object, i);
                    return;
                }
                ++i;
            }
            super.addElement(object);
        }

        public void insertElementAt(Object o, int i) {
            if (!(o instanceof Filter)) {
                throw new IllegalArgumentException("Object is not a Filter");
            }
            Filter filter = (Filter)o;
            if (this.diagram != null && !filter.isForDiagram(this.diagram)) {
                throw new IllegalArgumentException("Object is not suited for UMLDiagram " + this.diagram);
            }
            super.insertElementAt(o, i);
        }

        public void setSelectedItem(Object o) {
            if (!(o instanceof Filter)) {
                throw new IllegalArgumentException("Object is not a Filter");
            }
            Filter filter = (Filter)o;
            if (this.diagram != null && !filter.isForDiagram(this.diagram)) {
                throw new IllegalArgumentException("Object is not suited for UMLDiagram " + this.diagram);
            }
            super.setSelectedItem(o);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e instanceof CollectionChangeEvent) {
                CollectionChangeEvent event = (CollectionChangeEvent)e;
                if (event.getType() == 1) {
                    Filter filter = (Filter)event.getNewValue();
                    if (this.diagram == null || filter.isForDiagram(this.diagram)) {
                        Filter add;
                        block12: {
                            add = null;
                            if (this.clone) {
                                try {
                                    if (filter instanceof ConfigurableFilter) {
                                        add = (Filter)((ConfigurableFilter)filter).clone();
                                        break block12;
                                    }
                                    add = FilterManager.createInstance(filter.getClass());
                                }
                                catch (Exception exception) {}
                            } else {
                                add = filter;
                            }
                        }
                        if (add != null) {
                            this.addElement(add);
                        }
                    }
                } else if (event.getType() == 2) {
                    Object item = event.getOldValue();
                    boolean selected = this.getSelectedItem() == item;
                    this.removeElement(item);
                    if (selected && this.getSize() > 0) {
                        this.setSelectedItem(this.getElementAt(0));
                    }
                }
            }
        }

        public void removeYou() {
            this.removeAllElements();
            FilterManager.get().removePropertyChangeListener(this);
        }
    }

    private static final class AFileFilter
    implements FileFilter {
        AFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase();
            return name.endsWith(".class") || name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith("." + FilterManager.SETTINGS_FILE_EXT.toLowerCase());
        }
    }
}

