/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.upb.tools.fca.FEmptyIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FilterClassLoader
extends ClassLoader {
    private static FilterClassLoader defaultClassLoader = null;
    private static HashMap classLoaders = null;
    private static FileFilter classFileFilter = null;
    private static FileFilter zipFileFilter = null;
    private HashMap resolvedClasses;
    private File path;
    private boolean isZipFile;
    static /* synthetic */ Class class$0;

    private FilterClassLoader() {
        this(new File(GeneralPreferences.get().getViewFilterFolder()));
    }

    private FilterClassLoader(File path) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.views.Filter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getClassLoader());
        this.resolvedClasses = null;
        this.path = null;
        this.isZipFile = false;
        this.setPath(path);
    }

    public static FilterClassLoader get() {
        if (defaultClassLoader == null) {
            defaultClassLoader = new FilterClassLoader();
        }
        return defaultClassLoader;
    }

    public static FilterClassLoader get(File path) {
        FilterClassLoader loader;
        if (path == null || path.equals(FilterClassLoader.get().getPath())) {
            return FilterClassLoader.get();
        }
        if (classLoaders == null) {
            classLoaders = new HashMap();
        }
        if ((loader = (FilterClassLoader)classLoaders.get(FilterClassLoader.getAbsolutePath(path))) == null) {
            loader = new FilterClassLoader(path);
            classLoaders.put(FilterClassLoader.getAbsolutePath(path), loader);
        }
        return loader;
    }

    protected static FileFilter getClassFileFilter() {
        if (classFileFilter == null) {
            classFileFilter = new NoCaseFileFilter(new String[]{".class"});
        }
        return classFileFilter;
    }

    protected static FileFilter getZipFileFilter() {
        if (zipFileFilter == null) {
            zipFileFilter = new NoCaseFileFilter(new String[]{".zip", ".jar"});
        }
        return zipFileFilter;
    }

    protected Class defineClass(File classFile) throws ClassFormatError {
        Class clazz = this.getFromResolvedClasses(FilterClassLoader.getAbsolutePath(classFile));
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.defineClass(new FileInputStream(classFile), classFile.length());
            this.addToResolvedClasses(FilterClassLoader.getAbsolutePath(classFile), clazz);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassFormatError();
        }
    }

    protected Class defineClass(ZipFile classFile, ZipEntry classEntry) throws ClassFormatError {
        String id = String.valueOf(FilterClassLoader.getAbsolutePath(new File(classFile.getName()))) + ":" + classEntry.getName();
        Class clazz = this.getFromResolvedClasses(id);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.defineClass(classFile.getInputStream(classEntry), classEntry.getSize());
            this.addToResolvedClasses(id, clazz);
        }
        catch (IOException e) {
            throw new ClassFormatError();
        }
        return clazz;
    }

    protected Class defineClass(InputStream stream, long length) throws ClassFormatError {
        BufferedInputStream buffer = new BufferedInputStream(stream);
        int pos = 0;
        long toDo = length;
        int lastRead = 0;
        byte[] classBytes = new byte[(int)toDo];
        try {
            while (lastRead != -1 && toDo > 0L) {
                lastRead = buffer.read(classBytes, pos, (int)toDo);
                if (lastRead == -1) continue;
                pos += lastRead;
                toDo -= (long)lastRead;
            }
        }
        catch (IOException ioe) {
            throw new ClassFormatError();
        }
        return this.defineClass(null, classBytes, 0, classBytes.length);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        String baseName = null;
        StringBuffer packageName = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                packageName.append(String.valueOf(token) + File.separator);
                continue;
            }
            baseName = token;
        }
        Class clazz = null;
        clazz = this.isZipFile() ? this.findInZipFile(this.getPath(), packageName.toString(), baseName) : this.findInDir(this.getPath(), packageName.toString(), baseName);
        if (clazz == null || !clazz.getName().equals(name)) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    private Class findInDir(File path, String packageName, String baseName) {
        File[] files;
        Class clazz;
        if (packageName != null && packageName.length() > 0 && (clazz = this.findInDir(new File(path, packageName), null, baseName)) != null) {
            return clazz;
        }
        File classFile = new File(path, String.valueOf(baseName) + ".class");
        if (classFile.exists() && classFile.isFile()) {
            try {
                return this.defineClass(classFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((classFile = path).exists() && classFile.isDirectory()) {
            files = classFile.listFiles(FilterClassLoader.getClassFileFilter());
            int i = 0;
            while (i < files.length) {
                String ext;
                String name = files[i].getName();
                if (name.startsWith(baseName) && (ext = name.substring(baseName.length()).toLowerCase()).equals(".class")) {
                    try {
                        return this.defineClass(classFile);
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                ++i;
            }
        }
        files = path.listFiles(FilterClassLoader.getZipFileFilter());
        Class clazz2 = null;
        int i = 0;
        while (i < files.length && clazz2 == null) {
            if (files[i].getName().toLowerCase().endsWith(".zip") || files[i].getName().toLowerCase().endsWith(".jar")) {
                clazz2 = this.findInZipFile(files[i], packageName, baseName);
            }
            ++i;
        }
        return clazz2;
    }

    private Class findInZipFile(File zipFile, String packageName, String baseName) {
        Class clazz = null;
        try {
            ZipFile zipArchive = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zipArchive.entries();
            while (entries.hasMoreElements()) {
                String ext;
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).startsWith(String.valueOf(packageName) + baseName) || !(ext = name.substring((String.valueOf(packageName) + baseName).length()).toLowerCase()).equals(".class")) continue;
                try {
                    clazz = this.defineClass(zipArchive, entry);
                }
                catch (Exception exception) {}
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private void setPath(File path) {
        if (path != this.path) {
            if (path == null || !path.exists()) {
                throw new IllegalArgumentException("Path " + FilterClassLoader.getAbsolutePath(path) + " does not exist");
            }
            if (!path.canRead()) {
                throw new IllegalArgumentException("Path " + FilterClassLoader.getAbsolutePath(path) + " is unreadable");
            }
            if (path.isFile()) {
                try {
                    new ZipFile(path).getName();
                    this.isZipFile = true;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Path " + FilterClassLoader.getAbsolutePath(path) + " is not a directory or a valid zip file");
                }
            } else {
                this.isZipFile = false;
            }
            try {
                this.path = path.getCanonicalFile();
            }
            catch (IOException e) {
                this.path = path.getAbsoluteFile();
            }
        }
    }

    protected File getPath() {
        return this.path;
    }

    protected boolean isZipFile() {
        return this.isZipFile;
    }

    public boolean hasInResolvedClasses(Class value) {
        return this.resolvedClasses != null && value != null && this.resolvedClasses.containsValue(value);
    }

    public boolean hasInResolvedClasses(String key, Class value) {
        return this.resolvedClasses != null && value != null && key != null && this.resolvedClasses.get(key) == value;
    }

    public boolean hasKeyInResolvedClasses(String key) {
        return this.resolvedClasses != null && key != null && this.resolvedClasses.containsKey(key);
    }

    public Iterator iteratorOfResolvedClasses() {
        return this.resolvedClasses == null ? FEmptyIterator.get() : this.resolvedClasses.values().iterator();
    }

    public Iterator keysOfResolvedClasses() {
        return this.resolvedClasses == null ? FEmptyIterator.get() : this.resolvedClasses.keySet().iterator();
    }

    public Iterator entriesOfResolvedClasses() {
        return this.resolvedClasses == null ? FEmptyIterator.get() : this.resolvedClasses.entrySet().iterator();
    }

    public int sizeOfResolvedClasses() {
        return this.resolvedClasses == null ? 0 : this.resolvedClasses.size();
    }

    public Class getFromResolvedClasses(String key) {
        return this.resolvedClasses == null || key == null ? null : (Class)this.resolvedClasses.get(key);
    }

    protected boolean addToResolvedClasses(String key, Class value) {
        boolean changed = false;
        if (value != null && key != null) {
            Class oldValue;
            if (this.resolvedClasses == null) {
                this.resolvedClasses = new HashMap();
            }
            if ((oldValue = this.resolvedClasses.put(key, value)) != value) {
                changed = true;
            }
        }
        return changed;
    }

    protected boolean addToResolvedClasses(Map.Entry entry) {
        return this.addToResolvedClasses((String)entry.getKey(), (Class)entry.getValue());
    }

    protected boolean removeFromResolvedClasses(Class value) {
        boolean changed = false;
        if (this.resolvedClasses != null && value != null) {
            Iterator iter = this.entriesOfResolvedClasses();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value) continue;
                changed |= this.removeFromResolvedClasses((String)entry.getKey(), value);
            }
        }
        return changed;
    }

    protected boolean removeFromResolvedClasses(String key, Class value) {
        Class oldValue;
        boolean changed = false;
        if (this.resolvedClasses != null && value != null && key != null && (oldValue = (Class)this.resolvedClasses.get(key)) == value) {
            this.resolvedClasses.remove(key);
            changed = true;
        }
        return changed;
    }

    protected boolean removeKeyFromResolvedClasses(String key) {
        Class tmpValue;
        boolean changed = false;
        if (this.resolvedClasses != null && key != null && (tmpValue = (Class)this.resolvedClasses.get(key)) != null) {
            this.resolvedClasses.remove(key);
            changed = true;
        }
        return changed;
    }

    protected void removeAllFromResolvedClasses() {
        if (this.resolvedClasses != null) {
            Object[] keys = this.resolvedClasses.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                this.removeKeyFromResolvedClasses((String)keys[i]);
                ++i;
            }
        }
    }

    private static String getAbsolutePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private static final class NoCaseFileFilter
    implements FileFilter {
        private String[] extensions = null;

        public NoCaseFileFilter(String[] exts) {
            this.extensions = new String[exts.length];
            int i = 0;
            while (i < exts.length) {
                this.extensions[i] = exts[i].toLowerCase();
                ++i;
            }
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            String name = file.getName().toLowerCase();
            if (this.extensions == null) {
                return true;
            }
            int i = 0;
            while (i < this.extensions.length) {
                if (name.endsWith(this.extensions[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

