/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.views.AbstractFilterEditor;
import de.uni_paderborn.fujaba.views.AssocFilter;
import de.uni_paderborn.fujaba.views.CompositeFilter;
import de.uni_paderborn.fujaba.views.ConfigurableFilter;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.cf.CFAndNode;
import de.uni_paderborn.fujaba.views.cf.CFDiagram;
import de.uni_paderborn.fujaba.views.cf.CFEndNode;
import de.uni_paderborn.fujaba.views.cf.CFFilterNode;
import de.uni_paderborn.fujaba.views.cf.CFNode;
import de.uni_paderborn.fujaba.views.cf.CFNotNode;
import de.uni_paderborn.fujaba.views.cf.CFOrNode;
import de.uni_paderborn.fujaba.views.cf.CFStartNode;
import de.uni_paderborn.fujaba.views.cf.CFTransition;
import de.uni_paderborn.fujaba.views.gui.SmallFilterEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class CompositeFilterEditor
extends AbstractFilterEditor
implements ActionListener {
    JLayeredPane noDiagPanel = null;
    JScrollPane scrollPane = null;
    private CFDiagram currentDiagram = null;

    public CompositeFilterEditor(ConfigurableFilter filter) {
        super(filter);
    }

    protected void buildEditor() {
        this.setLayout(new BorderLayout());
        JToolBar buttonBar = this.createButtonBar();
        this.scrollPane = this.createScrollPane();
        JEditorPane textPane = new JEditorPane();
        textPane.setContentType("text/html");
        textPane.setText("<div align=\"Center\"><i>This editor might not work 100% correctly <br>because of ongoing changes to the <br>FUJABA display model</i></div>");
        textPane.setEditable(false);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(1, 1, 0, 0));
        textPanel.setBackground(FSAObject.COLOR_BACKGROUND);
        textPanel.add(textPane);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)buttonBar, "North");
        this.add((Component)textPanel, "South");
    }

    private JToolBar createButtonBar() {
        JToolBar bar = new JToolBar();
        JButton button = new JButton();
        button.setActionCommand("addAndNode");
        button.addActionListener(this);
        button.setText(" & ");
        bar.add(button);
        button = new JButton();
        button.setActionCommand("addOrNode");
        button.addActionListener(this);
        button.setText(" v ");
        bar.add(button);
        button = new JButton();
        button.setActionCommand("addNotNode");
        button.addActionListener(this);
        button.setText(" ! ");
        bar.add(button);
        button = new JButton();
        button.setActionCommand("addFilterNode");
        button.addActionListener(this);
        button.setText("Filter");
        bar.add(button);
        button = new JButton();
        button.setActionCommand("addTransition");
        button.addActionListener(this);
        button.setText("->");
        bar.add(button);
        bar.addSeparator();
        button = new JButton();
        button.setActionCommand("deleteNode");
        button.addActionListener(this);
        button.setText("Delete");
        bar.add(button);
        bar.addSeparator();
        button = new JButton();
        button.setActionCommand("editFilter");
        button.addActionListener(this);
        button.setText("Edit Filter");
        bar.add(button);
        return bar;
    }

    private JScrollPane createScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(FSAObject.COLOR_BACKGROUND);
        JLabel noDiagLabel = new JLabel("No diagram is selected in the project tree.");
        noDiagLabel.setBackground(FSAObject.COLOR_BACKGROUND);
        this.noDiagPanel = new JLayeredPane();
        this.noDiagPanel.setLayout(new FlowLayout());
        this.noDiagPanel.setBackground(FSAObject.COLOR_BACKGROUND);
        this.noDiagPanel.add((Component)noDiagLabel, 0);
        scrollPane.getViewport().setDoubleBuffered(true);
        scrollPane.getViewport().setBackground(FSAObject.COLOR_BACKGROUND);
        scrollPane.getViewport().add(this.noDiagPanel);
        scrollPane.getViewport().setScrollMode(1);
        return scrollPane;
    }

    protected void setValues(ConfigurableFilter filter) {
        if (filter == null || !(filter instanceof CompositeFilter)) {
            return;
        }
        ((CompositeFilter)filter).setCFDiagram(this.getCurrentDiagram());
    }

    private CFDiagram getCurrentDiagram() {
        LogicUnparseInterface incr;
        FSAObject obj;
        Component comp;
        if (this.currentDiagram == null && (comp = this.scrollPane.getViewport().getComponent(0)) instanceof JComponent && (obj = FSAObject.getFSAObjectFromJComponent((JComponent)comp)) != null && (incr = obj.getLogic()) != null && incr instanceof CFDiagram) {
            this.currentDiagram = (CFDiagram)incr;
        }
        return this.currentDiagram;
    }

    protected void getValues(ConfigurableFilter filter) {
        if (this.scrollPane == null) {
            this.buildEditor();
        }
        this.scrollPane.getViewport().removeAll();
        SelectionManager.get().clear();
        CFDiagram diag = null;
        if (filter != null && filter instanceof CompositeFilter) {
            diag = ((CompositeFilter)filter).getCFDiagram();
            if (diag != null) {
                try {
                    diag = (CFDiagram)diag.clone();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Unable to clone diagram.\nFailed to set editor up. Cause: " + e.getMessage());
                }
            } else {
                diag = new CFDiagram();
            }
            this.initDiagram(diag);
            UnparseManager.get().unparse(diag);
            this.scrollPane.getViewport().removeAll();
            SelectionManager.get().clear();
            Iterator fsaIter = diag.iteratorOfFsaObjects();
            FSALayeredPane pane = (FSALayeredPane)fsaIter.next();
            this.scrollPane.getViewport().add(pane.getJComponent());
            this.currentDiagram = diag;
        } else {
            this.scrollPane.getViewport().add(this.noDiagPanel);
        }
    }

    private void initDiagram(CFDiagram diag) {
        if (diag.getStartNode() != null) {
            if (!diag.hasInElements(diag.getStartNode())) {
                diag.addToElements(diag.getStartNode());
            }
        } else {
            diag.addToElements(new CFStartNode());
        }
        if (diag.getEndNode() != null) {
            if (!diag.hasInElements(diag.getEndNode())) {
                diag.addToElements(diag.getEndNode());
            }
        } else {
            diag.addToElements(new CFEndNode());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        CFDiagram diag = this.getCurrentDiagram();
        if (diag == null) {
            return;
        }
        if ("addOrNode".equals(command)) {
            diag.addToElements(new CFOrNode());
        } else if ("addNotNode".equals(command)) {
            diag.addToElements(new CFNotNode());
        } else if ("addAndNode".equals(command)) {
            diag.addToElements(new CFAndNode());
        } else if ("addFilterNode".equals(command)) {
            CFFilterNode node = new CFFilterNode();
            node.setFilter(new AssocFilter());
            node.setContext(-1);
            diag.addToElements(node);
        } else if ("addTransition".equals(command)) {
            this.addTransitionAction();
        } else if ("deleteNode".equals(command)) {
            this.deleteAction();
        } else if ("editFilter".equals(command)) {
            this.editFilterAction();
        }
    }

    private void addTransitionAction() {
        FSAObject[] sel = SelectionManager.get().getLastSelections(null, 2);
        if (sel.length < 2 || sel[sel.length - 1] == null || sel[sel.length - 2] == null) {
            JOptionPane.showMessageDialog(this, "You have to select two items first", "Error", 0);
        } else {
            LogicUnparseInterface sourceIncr = sel[sel.length - 2].getLogic();
            LogicUnparseInterface targetIncr = sel[sel.length - 1].getLogic();
            if (!(sourceIncr instanceof CFNode) || !(targetIncr instanceof CFNode)) {
                JOptionPane.showMessageDialog(this, "The last two selections\nhave to be Nodes!", "Error", 0);
            } else {
                CFNode source = (CFNode)sourceIncr;
                CFNode target = (CFNode)targetIncr;
                if (source instanceof CFEndNode) {
                    JOptionPane.showMessageDialog(this, "An end node cannot have an\noutgoing transition", "Error", 0);
                } else if (target instanceof CFStartNode) {
                    JOptionPane.showMessageDialog(this, "A start node cannot have an\nincoming transition", "Error", 0);
                } else {
                    CFTransition trans = new CFTransition();
                    trans.setSource(source);
                    trans.setTarget(target);
                    this.getCurrentDiagram().addToElements(trans);
                }
            }
        }
    }

    private void deleteAction() {
        FSAObject obj;
        Iterator iter = SelectionManager.get().iteratorOfSelection();
        if (!iter.hasNext()) {
            JOptionPane.showMessageDialog(this, "Nothing selected for deletion!", "Error", 0);
            return;
        }
        Vector<FSAObject> remove = new Vector<FSAObject>();
        while (iter.hasNext()) {
            obj = (FSAObject)iter.next();
            LogicUnparseInterface incr = obj.getLogic();
            if (incr instanceof CFStartNode) {
                JOptionPane.showMessageDialog(this, "Cannot delete start node!", "Error", 0);
                continue;
            }
            if (incr instanceof CFEndNode) {
                JOptionPane.showMessageDialog(this, "Cannot delete end node!", "Error", 0);
                continue;
            }
            remove.add(obj);
        }
        iter = remove.iterator();
        while (iter.hasNext()) {
            obj = (FSAObject)iter.next();
            JComponent parent = (JComponent)obj.getJComponent().getParent();
            ((UMLIncrement)obj.getLogic()).removeYou();
            parent.revalidate();
            parent.repaint();
        }
    }

    private void editFilterAction() {
        FSAObject obj = SelectionManager.get().getFocusedObject();
        if (obj != null && obj.getLogic() instanceof CFFilterNode) {
            Filter filter = ((CFFilterNode)obj.getLogic()).getFilter();
            if (filter != null && filter instanceof ConfigurableFilter) {
                SmallFilterEditorDialog editor = new SmallFilterEditorDialog(null);
                editor.setFilter(filter);
                editor.showCentered();
            } else {
                JOptionPane.showMessageDialog(this, "No ConfigurableFilter\nin this FilterNode", "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Please select a FilterNode first!", "Error", 0);
        }
    }
}

