/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.utility;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGUtility;
import de.uni_paderborn.fujaba.uml.From;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.upb.tools.fca.FTreeSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UMLClassDiagramUtility
extends ASGUtility {
    public UMLClassDiagramUtility(ASGDiagram diagram) {
        super(diagram);
    }

    public static Set setOfAssociations(UMLClass class1, UMLClass class2) {
        HashSet<UMLAssoc> set = new HashSet<UMLAssoc>();
        if (class1 != null && class2 != null) {
            UMLClass superClass;
            UMLGeneralization generalization;
            Iterator iter = class1.iteratorOfRoles();
            while (iter.hasNext()) {
                UMLRole leftRole = (UMLRole)iter.next();
                UMLAssoc assoc = leftRole.getAssoc();
                UMLRole rightRole = assoc.getPartnerRole(leftRole);
                if (rightRole.getTarget() != class2) continue;
                set.add(assoc);
            }
            iter = class1.iteratorOfRevSubclass();
            while (iter.hasNext()) {
                generalization = (UMLGeneralization)iter.next();
                superClass = generalization.getSuperclass();
                set.addAll(UMLClassDiagramUtility.setOfAssociations(superClass, class2));
            }
            iter = class2.iteratorOfRevSubclass();
            while (iter.hasNext()) {
                generalization = (UMLGeneralization)iter.next();
                superClass = generalization.getSuperclass();
                set.addAll(UMLClassDiagramUtility.setOfAssociations(class1, superClass));
            }
        }
        return set;
    }

    public static FTreeSet calculatePossibleAssocs(UMLClass class1, UMLClass class2) throws IllegalArgumentException {
        if (class1 == null || class2 == null) {
            throw new IllegalArgumentException("At least one argument is null!");
        }
        FTreeSet intersection = new FTreeSet();
        UMLAssoc assoc = null;
        FTreeSet assocsFromClass1 = class1.getAllAssocs();
        Iterator iter = assocsFromClass1.iterator();
        while (iter.hasNext()) {
            assoc = (UMLAssoc)iter.next();
            if (class1.isChildOf(assoc.getLeftRole().getTarget()) && class2.isChildOf(assoc.getRightRole().getTarget())) {
                intersection.add(assoc);
                continue;
            }
            if (!class1.isChildOf(assoc.getRightRole().getTarget()) || !class2.isChildOf(assoc.getLeftRole().getTarget())) continue;
            intersection.add(assoc);
        }
        return intersection;
    }

    public static FTreeSet calculatePossibleAssocsViaASGElementRef(UMLClass refClass, UMLClass elemClass) {
        if (refClass == null || elemClass == null || refClass == elemClass || UMLClassDiagramUtility.isDerivedfrom(refClass, "ASGElementRef")) {
            return null;
        }
        Object obj = null;
        FTreeSet assocs = new FTreeSet();
        FTreeSet refClasses = new FTreeSet();
        FTreeSet assocsFromClass = refClass.getAllAssocs();
        Iterator assocIter = assocsFromClass.iterator();
        while (assocIter.hasNext()) {
            obj = assocIter.next();
            UMLAssoc assoc = obj;
            refClasses.add(assoc.getLeftRole().getTarget());
            refClasses.add(assoc.getRightRole().getTarget());
            Iterator refClassIter = refClasses.iterator();
            while (refClassIter.hasNext()) {
                UMLClass reachableRefClass = (UMLClass)refClassIter.next();
                if (!UMLClassDiagramUtility.isDerivedfrom(reachableRefClass, "ASGElementRef") || !UMLClassDiagramUtility.isDerivedfrom(elemClass, "ASGElement")) continue;
                assocs.add((Object)obj);
            }
        }
        if (assocs.isEmpty()) {
            return null;
        }
        return assocs;
    }

    public static boolean isDerivedfrom(UMLClass cls, String superClsName) {
        boolean result = false;
        From superClsIter = (From)cls.iteratorOfSuperClasses();
        while (superClsIter.hasNext()) {
            UMLClass superCls = (UMLClass)superClsIter.next();
            if (superCls.getName().equals(superClsName)) {
                return true;
            }
            result = UMLClassDiagramUtility.isDerivedfrom(superCls, superClsName);
        }
        return result;
    }

    public static UMLAssoc getAssoc(String assocName) {
        UMLClassDiagram clazzDiagram = null;
        UMLAssoc foundAssoc = null;
        Iterator diagIter = UMLProject.get().iteratorOfDiags();
        while (diagIter.hasNext() && clazzDiagram == null) {
            ASGDiagram diagram = (ASGDiagram)diagIter.next();
            if (!(diagram instanceof UMLClassDiagram)) continue;
            clazzDiagram = (UMLClassDiagram)diagram;
            Iterator iter = clazzDiagram.iteratorOfElements();
            while (iter.hasNext() && foundAssoc == null) {
                UMLAssoc assoc;
                ASGElement asgElement = (ASGElement)iter.next();
                if (!(asgElement instanceof UMLAssoc) || !(assoc = (UMLAssoc)asgElement).getName().equals(assocName)) continue;
                foundAssoc = assoc;
            }
            if (foundAssoc != null) continue;
            clazzDiagram = null;
        }
        return foundAssoc;
    }

    public static UMLAssoc searchForAssoc(UMLClass class1, UMLClass class2, String assocName) {
        UMLAssoc foundAssoc = null;
        boolean found = false;
        Iterator iter = UMLClassDiagramUtility.calculatePossibleAssocs(class1, class2).iterator();
        while (iter.hasNext() && !found) {
            UMLAssoc currentAssoc = (UMLAssoc)iter.next();
            if (!currentAssoc.getName().equals(assocName)) continue;
            foundAssoc = currentAssoc;
            found = true;
        }
        return foundAssoc;
    }

    public static void removeMethodBySameName(UMLClass cls, UMLMethod method) {
        UMLMethod tmpMethod = null;
        Iterator iter = cls.iteratorOfMethods();
        boolean found = false;
        if (method != null) {
            while (!found && iter.hasNext()) {
                tmpMethod = (UMLMethod)iter.next();
                found = tmpMethod.getName().equals(method.getName());
            }
        }
        if (method != null && found) {
            tmpMethod.setParent(null);
            tmpMethod.removeYou();
        }
    }
}

