/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.update;

import de.uni_paderborn.fujaba.fsa.FSABend;
import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.fsa.swing.JArrowHead;
import de.uni_paderborn.fujaba.fsa.swing.JRectangle;
import de.uni_paderborn.fujaba.fsa.swing.PanelGrabUI;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.fsa.update.LogicToFsaUpdater;
import de.uni_paderborn.fujaba.uml.UMLQualifier;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.unparse.UMArrowHead;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class AdornmentUpdater
extends LogicToFsaUpdater
implements PropertyChangeListener {
    public AdornmentUpdater() {
        super.setLogicAttrName("adornment");
        super.setFsaAttrName("adornment");
    }

    public AdornmentUpdater(UMLRole role) {
        this();
        this.setLogicObject(role);
    }

    public boolean setLogicObject(Object object) {
        if (object == null || object instanceof UMLRole) {
            return super.setLogicObject(object);
        }
        throw new IllegalArgumentException("Object must be of instance UMLRole");
    }

    public boolean setFsaObject(FSAObject object) {
        if (object == null || object instanceof FSABend) {
            return super.setFsaObject(object);
        }
        throw new IllegalArgumentException("Object must be of instance FSABend");
    }

    public boolean setLogicAttrName(String name) {
        if ("adornment".equals(name)) {
            return false;
        }
        throw new UnsupportedOperationException("Cannot change AdornmentUpdater.umlAttrName from \"adornment\"");
    }

    public Object translateLogicToFsa(Object data) {
        int adornment = 0;
        if (data != null) {
            try {
                adornment = Integer.parseInt(data.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean selected = SelectionListenerHelper.isSelected(FSAObject.getJComponent(this.getFsaObject()));
        JComponent result = null;
        if (adornment == 1) {
            result = (JArrowHead)UMArrowHead.AGGREGATION.clone();
        } else if (adornment == 2) {
            result = (JArrowHead)UMArrowHead.COMPOSITION.clone();
        } else if (adornment == 4) {
            UMLQualifier qualifier = ((UMLRole)this.getLogicObject()).getQualifier();
            if (qualifier != null) {
                FSAObject qualFsa = qualifier.getFromFsaObjects(String.valueOf(this.getFsaObject().getID()) + ".entry");
                if (qualFsa == null) {
                    qualFsa = UnparseManager.get().unparse(qualifier, this.getFsaObject());
                }
                result = qualFsa.getJComponent();
            }
        } else {
            result = adornment == 3 ? (JArrowHead)UMArrowHead.REFERENCE.clone() : new JRectangle(3, 3);
        }
        if (result != null) {
            SelectionListenerHelper.addSelectionListener(result, ForegroundHighlighter.get());
            SelectionListenerHelper.setSelected(result, selected);
        }
        return result;
    }

    protected void addListener() {
        if (this.getLogicObject() != null && this.getLogicAttrName() != null && this.getFsaObject() != null && this.getFsaAttrName() != null) {
            if (this.getLogicListener() == null) {
                this.setLogicListener(this);
            }
            ((UMLRole)this.getLogicObject()).addPropertyChangeListener(this.getLogicAttrName(), (PropertyChangeListener)this.getLogicListener());
        }
    }

    protected void removeListener() {
        if (this.getLogicObject() != null && this.getLogicAttrName() != null && this.getFsaObject() != null && this.getFsaAttrName() != null && this.getLogicListener() != null) {
            ((UMLRole)this.getLogicObject()).removePropertyChangeListener(this.getLogicAttrName(), (PropertyChangeListener)this.getLogicListener());
        }
    }

    public void initialize() {
        if (this.getLogicObject() == null || this.getLogicAttrName() == null || this.getFsaObject() == null || this.getFsaAttrName() == null) {
            return;
        }
        Method getMethod = null;
        Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods(this.getLogicAttrName(), this.getLogicObject());
        getMethod = methods[0];
        try {
            Object value = getMethod.invoke(this.getLogicObject(), null);
            JComponent comp = (JComponent)this.getTranslator().translateLogicToFsa(value);
            PanelGrabUI ui = (PanelGrabUI)((FSABend)this.getFsaObject()).getUI();
            JComponent grabComp = ui.getGrabComponent();
            if (grabComp == null) {
                ui.setGrabComponent(comp);
            } else {
                grabComp.removeAll();
                grabComp.add(comp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception in " + this + ".initialize: " + e);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        JComponent comp = (JComponent)this.getTranslator().translateLogicToFsa(e.getNewValue());
        PanelGrabUI ui = (PanelGrabUI)((FSABend)this.getFsaObject()).getUI();
        JComponent grabComp = ui.getGrabComponent();
        if (grabComp == null) {
            ui.setGrabComponent(comp);
        } else {
            grabComp.removeAll();
            if (comp != null) {
                grabComp.add(comp);
            }
        }
    }
}

