/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.messages.WarningMessages;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class NewClassDiagramAction
extends AbstractAction {
    public void actionPerformed(ActionEvent e) {
        UMLProject project = UMLProject.get();
        boolean done = false;
        FrameMain frameMain = FrameMain.get();
        while (!done) {
            String prefix = "ClassDiagram";
            String name = String.valueOf(prefix) + "1";
            int i = 1;
            while (project.getFromDiags(String.valueOf(prefix) + i) != null) {
                name = String.valueOf(prefix) + (i + 1);
                ++i;
            }
            if (name != null) {
                JTree tree;
                Iterator iter = project.iteratorOfDiags();
                boolean found = false;
                if (name.trim().equals("")) {
                    WarningMessages.warnUnnamedDiagram(frameMain, "class");
                    found = true;
                }
                while (!found && iter.hasNext()) {
                    ASGDiagram diagram = (ASGDiagram)iter.next();
                    if (!(diagram instanceof UMLClassDiagram) || !diagram.getName().equals(name)) continue;
                    WarningMessages.warnDoubleIdentifiedDiagram(frameMain, "class", name);
                    found = true;
                }
                if (found) continue;
                UMLClassDiagram newDiag = new UMLClassDiagram(name, null);
                project.addToDiags(newDiag);
                frameMain.createNewTreeItems();
                frameMain.selectTreeItem(newDiag);
                Component selectedComponent = frameMain.getTabbedPaneProxy().getTabbedPane().getSelectedComponent();
                if (selectedComponent instanceof JScrollPane) {
                    selectedComponent = ((JScrollPane)selectedComponent).getViewport().getView();
                }
                if (selectedComponent instanceof JTree && (tree = (JTree)selectedComponent).isEditable()) {
                    tree.startEditingAtPath(tree.getSelectionPath());
                }
                done = true;
                continue;
            }
            done = true;
        }
    }
}

