/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.SelectFromListDialog;
import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStatechart;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.actions.Event;
import de.uni_paderborn.fujaba.uml.actions.InEvent;
import de.uni_paderborn.fujaba.uml.actions.NewStateAction;
import de.uni_paderborn.fujaba.uml.actions.OutEvent;
import de.uni_paderborn.fujaba.uml.actions.State;
import de.uni_paderborn.fujaba.uml.actions.Trace;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MergeSequenceDiagramIntoStateChartAction
extends AbstractAction {
    private static final transient Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.actions.MergeSequenceDiagramIntoStateChartAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent event) {
        FrameMain frameMain = FrameMain.get();
        UMLStatechart statechart = (UMLStatechart)UMLProject.get().getCurrentDiagram();
        try {
            block11: {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"FIXME: This is work in progress!");
                    }
                    JFileChooser fileChooser = frameMain.getFileChooser();
                    fileChooser.setCurrentDirectory(new File(UMLProject.get().getRootDir(), "examples/xml-sequence-diagrams"));
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setPreferredSize(new Dimension(600, 600));
                    if (fileChooser.showOpenDialog(frameMain.getFrame()) == 0) {
                        frameMain.setStatusLabel("Merging...");
                        frameMain.setCursorWait();
                        File sdFile = fileChooser.getSelectedFile();
                        if (!sdFile.exists()) throw new Exception("Can't open " + sdFile + ".");
                        if (!sdFile.isFile()) throw new Exception("Can't open " + sdFile + ".");
                        Collection sequenceDiagramObjects = this.sequenceDiagramObjects(sdFile);
                        SelectFromListDialog objectsDialog = new SelectFromListDialog(frameMain.getFrame());
                        objectsDialog.setObjects(sequenceDiagramObjects);
                        objectsDialog.setHeading("Select an object of the sequence-diagram:    ");
                        objectsDialog.show();
                        if (objectsDialog.getSelectedObject() != null) {
                            String tracedObject = (String)objectsDialog.getSelectedObject();
                            Trace trace = this.createSequenceDiagramTrace(sdFile, tracedObject);
                            if (trace == null) throw new Exception("Error while reading " + sdFile + ".");
                            if (log.isInfoEnabled()) {
                                log.info((Object)trace);
                            }
                            this.mergeTraceIntoStatechart(statechart, trace);
                            frameMain.setStatusLabel("Merged.");
                            break block11;
                        } else {
                            frameMain.setStatusLabel("Cancelled.");
                        }
                        break block11;
                    }
                    frameMain.setStatusLabel("Cancelled.");
                }
                catch (Exception e) {
                    frameMain.setStatusLabel(e.getMessage());
                    if (log.isInfoEnabled()) {
                        log.info((Object)e);
                    }
                    e.printStackTrace();
                }
            }
            Object var10_13 = null;
            frameMain.setCursorDefault();
            UMLProject.get().refreshDisplay();
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            frameMain.setCursorDefault();
            UMLProject.get().refreshDisplay();
            throw throwable;
        }
    }

    boolean mergeTraceIntoStatechart(UMLStatechart statechart, Trace trace) {
        boolean result = false;
        if (!this.statechartCanExecuteTrace(statechart, trace) && !trace.isEmpty()) {
            Iterator iter = statechart.iteratorOfElements();
            while (iter.hasNext() && !result) {
                UMLTransition transition;
                Trace traceForTransition;
                ASGElement asgElement = (ASGElement)iter.next();
                if (asgElement instanceof UMLComplexState) {
                    Trace traceForState = new Trace(trace);
                    UMLComplexState state = (UMLComplexState)asgElement;
                    if (!traceForState.startsWith(state) || traceForState.getSize() == trace.getSize() || !this.mergeTraceIntoStatechart(statechart, traceForState, state, true, "   ")) continue;
                    result = true;
                    continue;
                }
                if (!(asgElement instanceof UMLTransition) || !(traceForTransition = new Trace(trace)).startsWith(transition = (UMLTransition)asgElement) || traceForTransition.getSize() == trace.getSize() || !this.mergeTraceIntoStatechart(statechart, traceForTransition, transition, "   ")) continue;
                result = true;
            }
            if (!result) {
                UMLComplexState newState = trace.createState(statechart);
                if (this.mergeTraceIntoStatechart(statechart, trace, newState, true, "   ")) {
                    result = true;
                } else {
                    newState.removeYou();
                }
            }
        }
        return result;
    }

    boolean mergeTraceIntoStatechart(UMLStatechart statechart, Trace trace, UMLComplexState state, boolean allowNewLeavingTransition, String prefix) {
        if (trace.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "merge(null, " + state + ")"));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "trace is empty, merge is ok"));
            }
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(String.valueOf(prefix) + "merge(" + trace.first() + ", " + state + ")"));
        }
        Iterator iter = state.iteratorOfExit();
        while (iter.hasNext()) {
            UMLTransition transition = (UMLTransition)iter.next();
            if (!trace.startsWith(transition)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "have to follow transition."));
            }
            return this.mergeTraceIntoStatechart(statechart, trace, transition, String.valueOf(prefix) + "   ");
        }
        if (allowNewLeavingTransition) {
            UMLTransition newTransition;
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "creating new transition."));
            }
            if ((newTransition = trace.createTransition(statechart, state)) != null) {
                if (this.mergeTraceIntoStatechart(statechart, trace, newTransition, String.valueOf(prefix) + "   ")) {
                    return true;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)(String.valueOf(prefix) + "merge failed, backtrack: remove transition from " + newTransition.getSource() + " to " + newTransition.getTarget() + "."));
                }
                newTransition.removeYou();
                return false;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "merge failed, couldn't create transition from state " + state + "."));
            }
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(String.valueOf(prefix) + "merge failed, not allowed to create new leaving transition from state " + state + "."));
        }
        return false;
    }

    boolean mergeTraceIntoStatechart(UMLStatechart statechart, Trace trace, UMLTransition transition, String prefix) {
        if (trace.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "merge(null, " + transition + ")"));
            }
            System.out.print(String.valueOf(prefix) + "trace is empty, ");
            if (transition.getTarget() == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"have to create new state, ");
                }
                UMLComplexState newState = NewStateAction.createState(statechart, "");
                transition.setTarget(newState);
                statechart.addToElements(newState);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"merge is ok.");
            }
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(String.valueOf(prefix) + "merge(" + trace.first() + ", " + transition + ")"));
        }
        if (transition.getTarget() != null) {
            UMLComplexState target = (UMLComplexState)transition.getTarget();
            if (trace.startsWith(target)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(String.valueOf(prefix) + "transition has target, have to follow to state " + target));
                }
                return this.mergeTraceIntoStatechart(statechart, trace, target, true, String.valueOf(prefix) + "   ");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "merge failed, target " + target + " doesn't match trace."));
            }
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(String.valueOf(prefix) + "transition has no target"));
        }
        Iterator iter = statechart.iteratorOfElements();
        while (iter.hasNext()) {
            UMLComplexState state;
            Trace traceForState;
            ASGElement asgElement = (ASGElement)iter.next();
            if (!(asgElement instanceof UMLComplexState) || asgElement == statechart.getInitialState() || !(traceForState = new Trace(trace)).startsWith(state = (UMLComplexState)asgElement)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "trying target " + state));
            }
            transition.setTarget(state);
            if (this.mergeTraceIntoStatechart(statechart, traceForState, state, true, String.valueOf(prefix) + "   ")) {
                return true;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(prefix) + "target " + state + " failed."));
            }
            transition.setTarget(null);
        }
        UMLComplexState newState = trace.createState(statechart);
        if (log.isInfoEnabled()) {
            log.info((Object)(String.valueOf(prefix) + "all targets tried, creating new state " + newState));
        }
        transition.setTarget(newState);
        if (this.mergeTraceIntoStatechart(statechart, trace, newState, true, String.valueOf(prefix) + "   ")) {
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(String.valueOf(prefix) + "merge failed, backtrack: remove state " + newState + "."));
        }
        transition.setTarget(null);
        newState.removeYou();
        return false;
    }

    boolean statechartCanExecuteTrace(UMLStatechart statechart, Trace trace) {
        return trace.isEmpty();
    }

    private Collection sequenceDiagramObjects(File sdFile) {
        TreeSet<String> diagramObjects = new TreeSet<String>();
        Document document = this.openSequenceDiagram(sdFile);
        if (document != null) {
            NodeList lst = document.getElementsByTagName("*");
            int i = 0;
            while (i < lst.getLength()) {
                Node node = lst.item(i);
                if (node.getNodeType() == 1 && (node.getNodeName().equals("sender") || node.getNodeName().equals("receiver"))) {
                    String name = node.getFirstChild().getNodeValue().trim();
                    diagramObjects.add(name);
                }
                ++i;
            }
        }
        return diagramObjects;
    }

    private Trace createSequenceDiagramTrace(File file, String tracedObject) {
        Trace trace = null;
        Document document = this.openSequenceDiagram(file);
        if (document != null) {
            NodeList lst = document.getElementsByTagName("*");
            trace = new Trace();
            int length = lst.getLength();
            int i = 0;
            while (i < length) {
                Node node = lst.item(i);
                if (node.getNodeType() == 1) {
                    State state;
                    if (node.getNodeName().equals("event")) {
                        Event event = this.createEvent(node, tracedObject);
                        if (event != null) {
                            trace.appendItem(event);
                        }
                    } else if (node.getNodeName().equals("state") && (state = this.createState(node)) != null) {
                        trace.appendItem(state);
                    }
                }
                ++i;
            }
        }
        return trace;
    }

    private Document openSequenceDiagram(File file) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
            DocumentType doctype = document.getDoctype();
            boolean valid = false;
            if (doctype != null && doctype.getName().equals("sequence-diagram")) {
                valid = true;
            }
            if (!valid) {
                throw new RuntimeException("invalid xml-document");
            }
            document.normalize();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }

    private Event createEvent(Node eventNode, String tracedObject) {
        String name = "";
        String sender = "";
        String receiver = "";
        NodeList lst = eventNode.getChildNodes();
        int length = lst.getLength();
        int i = 0;
        while (i < length) {
            Node node = lst.item(i);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("name")) {
                    name = node.getFirstChild().getNodeValue().trim();
                }
                if (node.getNodeName().equals("sender")) {
                    sender = node.getFirstChild().getNodeValue().trim();
                }
                if (node.getNodeName().equals("receiver")) {
                    receiver = node.getFirstChild().getNodeValue().trim();
                }
            }
            ++i;
        }
        Event result = null;
        if (sender.equals(receiver)) {
            throw new RuntimeException("sender==receiver not yet supported for events (" + name + " from/to " + sender + ")");
        }
        if (sender.equals(tracedObject)) {
            result = new OutEvent(name, receiver);
        } else if (receiver.equals(tracedObject)) {
            result = new InEvent(name, sender);
        }
        return result;
    }

    private State createState(Node stateNode) {
        String name = "";
        NodeList lst = stateNode.getChildNodes();
        int length = lst.getLength();
        int i = 0;
        while (i < length) {
            Node node = lst.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals("name")) {
                name = node.getFirstChild().getNodeValue().trim();
            }
            ++i;
        }
        return new State(name);
    }
}

