/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

public class ImportClassReferences
extends AbstractAction {
    private static final transient Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.actions.ImportClassReferences");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void actionPerformed(ActionEvent event) {
        FrameMain frame = UMLProject.get().getGui();
        JFileChooser fileChooser = frame.getFileChooser();
        fileChooser.setFileFilter(frame.getFilterJarFiles());
        fileChooser.setFileSelectionMode(2);
        if (fileChooser.showOpenDialog(frame) == 0) {
            File file = fileChooser.getSelectedFile();
            if (file.isDirectory()) {
                this.importDirectory(file.getAbsoluteFile().toString().lastIndexOf(File.separatorChar) + 1, file);
            } else {
                this.importFile(file);
            }
        }
    }

    private String convertToNormalName(String name) {
        name = name.replace(File.separatorChar, '.');
        name = name.replace('/', '.');
        if ((name = name.replace('\\', '.')).endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
        }
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public UMLPackage findPlace(UMLPackage rootPackage, String name) {
        int index = name.indexOf(46);
        if (index != -1) {
            String first = name.substring(0, index);
            String rest = name.substring(index + 1, name.length());
            UMLPackage childPackage = rootPackage.getFromPackages(first);
            if (childPackage != null) {
                return this.findPlace(childPackage, rest);
            }
            UMLPackage newPackage = new UMLPackage();
            newPackage.setName(first);
            rootPackage.addToPackages(newPackage);
            return this.findPlace(newPackage, rest);
        }
        return rootPackage;
    }

    public void addToTreeAndPackages(String name, boolean isClass) {
        if (name.indexOf("$") == -1) {
            name = this.convertToNormalName(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding: " + name));
            }
            UMLPackage place = this.findPlace(UMLProject.get().getRootPackage(), name);
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
            if (isClass) {
                if (!place.hasKeyInDeclares(name)) {
                    UMLClass newClass = new UMLClass(name);
                    UMLStereotype referenceType = UMLStereotypeManager.get().getFromStereotypes("reference");
                    newClass.setStereotype(referenceType, true);
                    place.addToDeclares(newClass);
                }
            } else if (!place.hasKeyInPackages(name)) {
                UMLPackage newPackage = new UMLPackage();
                newPackage.setName(name);
                place.addToPackages(newPackage);
            }
        }
    }

    private void importFile(File file) {
        block6: {
            String fileName = file.getName();
            String extension = "";
            if (fileName.lastIndexOf(46) != -1) {
                extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
            }
            if (extension.equals("jar")) {
                try {
                    JarFile jar = new JarFile(file);
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.startsWith("META") || !name.endsWith(".class") && !entry.isDirectory()) continue;
                        if (entry.isDirectory()) {
                            this.addToTreeAndPackages(entry.getName(), false);
                            continue;
                        }
                        this.addToTreeAndPackages(entry.getName(), true);
                    }
                }
                catch (IOException e) {
                    if (!log.isInfoEnabled()) break block6;
                    log.info((Object)"Some problem occured while accessing the jar file");
                }
            }
        }
    }

    private void importDirectory(int index, File file) {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            File tmpFile = files[i];
            String fileName = tmpFile.getAbsoluteFile().toString();
            fileName = fileName.substring(index, fileName.length());
            if (!tmpFile.isDirectory()) {
                if (fileName.endsWith(".class")) {
                    this.addToTreeAndPackages(fileName, true);
                }
            } else if (!fileName.startsWith(".") && !tmpFile.getName().equals("CVS")) {
                this.addToTreeAndPackages(fileName, false);
                this.importDirectory(index, tmpFile);
            }
            ++i;
        }
    }
}

