/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLTransition;

public class UMLTransitionGuard
extends UMLDiagramItem {
    public static final transient int NONE = 0;
    public static final transient int SUCCESS = 1;
    public static final transient int FAILURE = 2;
    public static final transient int EVERYTIMES = 3;
    public static final transient int TERMINATION = 4;
    public static final transient int ELSE = 5;
    public static final transient int BOOL = 6;
    public static final transient int EXCEPTION = 7;
    private int type = 0;
    private String boolExpr = null;
    private UMLTransition revGuard = null;

    public static int getGuardType(UMLTransition transition) {
        UMLTransitionGuard guard = transition.getGuard();
        return guard == null ? 0 : guard.getType();
    }

    public UMLTransitionGuard() {
    }

    public UMLTransitionGuard(boolean coobraPersistent) {
        super(coobraPersistent);
    }

    public UMLTransitionGuard(int type, String boolExpr, UMLTransition revGuard) {
        this.setType(type);
        this.setBoolExpr(boolExpr);
        this.setRevGuard(revGuard);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type >= 0 && type <= 7 && this.type != type) {
            int oldValue = this.type;
            this.type = type;
            this.firePropertyChange("type", oldValue, type);
            this.firePropertyChange("boolExpr", this.getBoolExpr(oldValue), this.getBoolExpr());
        }
    }

    public String getBoolExpr(int type) {
        String expr;
        switch (type) {
            case 0: {
                expr = null;
                break;
            }
            case 1: {
                expr = "success";
                break;
            }
            case 2: {
                expr = "failure";
                break;
            }
            case 3: {
                expr = "each time";
                break;
            }
            case 4: {
                expr = "end";
                break;
            }
            case 5: {
                expr = "else";
                break;
            }
            default: {
                expr = this.boolExpr;
            }
        }
        return expr;
    }

    public String getBoolExpr() {
        return this.getBoolExpr(this.getType());
    }

    public void setBoolExpr(String boolExpr) {
        if (this.boolExpr == null && boolExpr != null || this.boolExpr != null && !this.boolExpr.equals(boolExpr)) {
            String oldValue = this.boolExpr;
            this.boolExpr = boolExpr;
            this.firePropertyChange("boolExpr", oldValue, boolExpr);
        }
    }

    public UMLTransition getRevGuard() {
        return this.revGuard;
    }

    public void setRevGuard(UMLTransition revGuard) {
        if (this.revGuard == null && revGuard != null || this.revGuard != null && !this.revGuard.equals(revGuard)) {
            UMLTransition oldRevGuard = this.revGuard;
            if (this.revGuard != null) {
                this.revGuard = null;
                oldRevGuard.setGuard(null);
            }
            this.revGuard = revGuard;
            if (revGuard != null) {
                revGuard.setGuard(this);
            }
            this.firePropertyChange("revGuard", oldRevGuard, revGuard);
        }
    }

    public boolean looksLike(UMLTransitionGuard curTransitionGuard) {
        return this.getType() == curTransitionGuard.getType();
    }

    public void removeYou() {
        this.setRevGuard(null);
        super.removeYou();
    }

    public FElement getParentElement() {
        return this.getRevGuard();
    }
}

