/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.metamodel.FCommentary;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FIncrement;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import java.util.StringTokenizer;

public class UMLCommentary
extends UMLIncrement
implements FCommentary {
    private transient UMLIncrement revComment;
    private String text = "";

    public UMLCommentary() {
    }

    public UMLCommentary(boolean coobraPersistent) {
        super(coobraPersistent);
    }

    public UMLCommentary(String text) {
        this.setText(text);
    }

    protected String createUnparseModuleName() {
        return UMLUnparseGetter.getUnparseModuleName(this);
    }

    public void swapVisibilityTo(boolean value) {
    }

    public boolean getVisibilityOfFirstIncr() {
        return false;
    }

    public boolean isVisible() {
        ASGDiagram diag = UMLProject.get().getCurrentDiagram();
        return this.hasInDiagrams(diag);
    }

    public void setVisible(boolean value) {
        if (value) {
            ASGDiagram diag = UMLProject.get().getCurrentDiagram();
            this.addToDiagrams(diag);
        } else {
            ASGDiagram diag = UMLProject.get().getCurrentDiagram();
            this.removeFromDiagrams(diag);
        }
    }

    public UMLIncrement getRevComment() {
        return this.revComment;
    }

    public FIncrement getFRevComment() {
        return this.getRevComment();
    }

    public void setRevComment(FIncrement revComment) {
        if (this.revComment != revComment) {
            UMLIncrement oldRevComment = this.revComment;
            if (this.revComment != null) {
                this.revComment = null;
                oldRevComment.setComment(null);
            }
            this.revComment = (UMLIncrement)revComment;
            if (revComment != null) {
                revComment.setComment(this);
            }
            this.firePropertyChange("revComment", oldRevComment, revComment);
        }
    }

    public String deleteBlancLines(String text) {
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        boolean blancLines = true;
        StringBuffer initialBlancs = new StringBuffer();
        while (blancLines && st.hasMoreTokens()) {
            String str = st.nextToken();
            if (str.trim().length() <= 0) continue;
            blancLines = false;
            StringBuffer strBuf = new StringBuffer(str);
            boolean ready = false;
            int i = 0;
            while (!ready && i < strBuf.length()) {
                char chr = strBuf.charAt(i);
                if (chr == ' ' || chr == '\t') {
                    initialBlancs.append(chr);
                } else {
                    ready = true;
                }
                ++i;
            }
        }
        return text.trim().length() > 0 ? initialBlancs + text.trim() + "\n" : "";
    }

    public String getIncrText() {
        return this.getText();
    }

    public String getText() {
        return this.text;
    }

    public String setText(String text) {
        if (text != null && !this.text.equals(text)) {
            String oldValue = this.text;
            this.text = text;
            this.firePropertyChange("text", oldValue, this.text);
        }
        return this.text;
    }

    public String getCommentedText() {
        String trimmedText = this.text.trim();
        if (trimmedText.startsWith("/*")) {
            if (!trimmedText.endsWith("*/")) {
                return String.valueOf(this.text) + "*/\n";
            }
            return this.text;
        }
        if (trimmedText.startsWith("//")) {
            StringTokenizer tokenizer = new StringTokenizer(this.text, "\n", true);
            StringBuffer textBuffer = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.length() == 1 && token.startsWith("\n")) {
                    textBuffer.append(token);
                    continue;
                }
                String trimmedToken = token.trim();
                if (trimmedToken.startsWith("//")) {
                    textBuffer.append(token);
                    continue;
                }
                textBuffer.append("// ");
                textBuffer.append(token);
            }
            return textBuffer.toString();
        }
        return "/*\n" + this.text + "*/\n";
    }

    public static String getUncommentedText(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String trimmedText = text.trim();
        int commentType = -1;
        commentType = trimmedText.startsWith("/**") ? 1 : (trimmedText.startsWith("/*") ? 0 : (trimmedText.startsWith("//") ? 2 : -1));
        switch (commentType) {
            case -1: {
                break;
            }
            case 0: 
            case 1: {
                int firstMultiIndex = -1;
                firstMultiIndex = commentType == 0 ? text.indexOf("/*") : text.indexOf("/**");
                int textEndIndex = text.lastIndexOf("*/");
                String pureText = textEndIndex != -1 ? text.substring(firstMultiIndex + 2, textEndIndex) : text.substring(firstMultiIndex + 2);
                if (commentType == 0) {
                    return UMLCommentary.deleteInitialBlancs(pureText, false);
                }
                return UMLCommentary.deleteInitialBlancs(pureText, true);
            }
            case 2: {
                StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
                StringBuffer textBuffer = new StringBuffer();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.length() == 1 && token.startsWith("\n")) {
                        textBuffer.append(token);
                        continue;
                    }
                    String trimmedToken = token.trim();
                    if (trimmedToken.startsWith("//")) {
                        textBuffer.append(trimmedToken.substring(2).trim());
                        continue;
                    }
                    textBuffer.append(trimmedToken);
                }
                return textBuffer.toString();
            }
        }
        return text;
    }

    public static String deleteInitialBlancs(String text, boolean removeAsterisk) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
        StringBuffer textBuffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && token.startsWith("\n")) {
                textBuffer.append(token);
                continue;
            }
            String trimmedToken = token.trim();
            if (removeAsterisk && trimmedToken.startsWith("*")) {
                textBuffer.append(trimmedToken.substring(1).trim());
                continue;
            }
            textBuffer.append(trimmedToken);
        }
        return textBuffer.toString();
    }

    public void removeYou() {
        this.setRevComment(null);
        super.removeYou();
    }

    public FElement getParentElement() {
        return this.getRevComment();
    }
}

