/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.FCardinality;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;

public class UMLCardinality
extends UMLIncrement
implements FCardinality {
    private String cardString = null;
    private UMLRole revCard = null;

    public UMLCardinality() {
    }

    public UMLCardinality(String cardString) {
        this(cardString, null);
    }

    public UMLCardinality(String cardString, UMLRole revCard) {
        this.setCardString(cardString);
        this.setRevCard(revCard);
    }

    protected String createUnparseModuleName() {
        return UMLUnparseGetter.getUnparseModuleName(this);
    }

    public int getLowerBound() {
        if (this.cardString != null && this.cardString.length() > 0) {
            char c = this.cardString.charAt(0);
            if (c < '0' || c > '9') {
                return 0;
            }
            int result = 0;
            int i = 0;
            while (i < this.cardString.length()) {
                c = this.cardString.charAt(i);
                if ('0' > c || c > '9') {
                    return result;
                }
                result = result * 10 + c - 48;
                ++i;
            }
            return result;
        }
        return 1;
    }

    public int getUpperBound() {
        if (this.cardString != null && this.cardString.length() > 0) {
            char c = this.cardString.charAt(this.cardString.length() - 1);
            if (c < '0' || c > '9') {
                return Integer.MAX_VALUE;
            }
            int result = 0;
            int multi = 1;
            int i = this.cardString.length() - 1;
            while (i >= 0) {
                c = this.cardString.charAt(i);
                if ('0' <= c && c <= '9') {
                    result = (c - 48) * multi + result;
                    multi *= 10;
                } else {
                    return result;
                }
                --i;
            }
            return result;
        }
        return 1;
    }

    public String getCardString() {
        return this.cardString;
    }

    public void setCardString(String strg) {
        if (this.cardString == null && strg != null || this.cardString != null && !this.cardString.equals(strg)) {
            String oldValue = this.cardString;
            this.cardString = strg;
            this.firePropertyChange("cardString", oldValue, strg);
        }
    }

    public UMLRole getRevCard() {
        return this.revCard;
    }

    public FRole getFRevCard() {
        return this.getRevCard();
    }

    public void setRevCard(FRole revCard) {
        if (this.revCard == null && revCard != null || this.revCard != null && !this.revCard.equals(revCard)) {
            UMLRole oldRevCard = this.revCard;
            if (this.revCard != null) {
                this.revCard = null;
                oldRevCard.setCard(null);
            }
            this.revCard = (UMLRole)revCard;
            if (this.revCard != null) {
                this.revCard.setCard(this);
            }
            this.firePropertyChange("revCard", oldRevCard, revCard);
        }
    }

    public void removeYou() {
        this.setRevCard(null);
        super.removeYou();
    }

    public FElement getParentElement() {
        return this.getRevCard();
    }
}

