/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLObject;

public class UMLAttrExprPair
extends UMLDiagramItem {
    public static final int NONE = 0;
    public static final int PRE = 1;
    public static final int POST = 2;
    public static final int EQUAL = 0;
    public static final int NOTEQUAL = 1;
    public static final int LESS = 2;
    public static final int GREATER = 3;
    public static final int LESSEQUAL = 4;
    public static final int GREATEREQUAL = 5;
    public static final int REG_EXPRESSION = 6;
    public static final int IN = 7;
    public static final int NOT_IN = 8;
    private String name = "";
    private int qualifier = 0;
    private int operation = 0;
    private String expression = "";
    private UMLAttr instanceOf;
    private UMLObject revAttrs;
    private static String[] allAttrOperationsAsText = null;

    public UMLAttrExprPair() {
    }

    public UMLAttrExprPair(String name, int qualifier, int operation, String expression, UMLAttr instanceOf, UMLObject revAttrs) {
        this.setName(name);
        this.setQualifier(qualifier);
        this.setOperation(operation);
        this.setExpression(expression);
        this.setRevAttrs(revAttrs);
        this.setInstanceOf(instanceOf);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null && name != null || this.name != null && !this.name.equals(name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, this.name);
        }
    }

    public int getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(int qualifier) {
        if (this.qualifier != qualifier) {
            int oldQualifier = this.qualifier;
            String oldAttrOperationAsText = this.getAttrOperationAsText();
            this.qualifier = qualifier;
            this.firePropertyChange("qualifier", oldQualifier, this.qualifier);
            this.firePropertyChange("attrOperationAsText", oldAttrOperationAsText, this.getAttrOperationAsText());
        }
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        if (this.operation != operation) {
            int oldOperation = this.operation;
            String oldAttrOperationAsText = this.getAttrOperationAsText();
            this.operation = operation;
            this.firePropertyChange("operation", oldOperation, this.operation);
            this.firePropertyChange("attrOperationAsText", oldAttrOperationAsText, this.getAttrOperationAsText());
        }
    }

    public String getOperationText() {
        switch (this.getOperation()) {
            case 0: {
                return "=";
            }
            case 1: {
                return "!=";
            }
            case 2: {
                return "<";
            }
            case 3: {
                return ">";
            }
            case 4: {
                return "<=";
            }
            case 5: {
                return ">=";
            }
            case 6: {
                return "== RegExp:";
            }
            case 7: {
                return " in ";
            }
            case 8: {
                return " not in ";
            }
        }
        return "";
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        if (this.expression == null && expression != null || this.expression != null && !this.expression.equals(expression)) {
            String oldExpression = this.expression;
            this.expression = expression;
            this.firePropertyChange("expression", oldExpression, this.expression);
        }
    }

    public UMLAttr getInstanceOf() {
        return this.instanceOf;
    }

    public void setInstanceOf(UMLAttr instanceOf) {
        if (this.instanceOf != instanceOf) {
            UMLAttr oldInstanceOf = this.instanceOf;
            if (this.instanceOf != null) {
                this.instanceOf = null;
                oldInstanceOf.removeFromInstances(this);
            }
            this.instanceOf = instanceOf;
            this.firePropertyChange("instanceOf", oldInstanceOf, instanceOf);
            if (instanceOf != null) {
                instanceOf.addToInstances(this);
            }
        }
    }

    public UMLObject getRevAttrs() {
        return this.revAttrs;
    }

    public void setRevAttrs(UMLObject revAttrs) {
        if (this.revAttrs != revAttrs) {
            UMLObject oldRevAttrs = this.revAttrs;
            if (this.revAttrs != null) {
                this.revAttrs = null;
                oldRevAttrs.removeFromAttrs(this);
            }
            this.revAttrs = revAttrs;
            this.firePropertyChange("revAttrs", oldRevAttrs, revAttrs);
            if (revAttrs != null) {
                revAttrs.addToAttrs(this);
            }
        }
    }

    public String getText() {
        StringBuffer newText = new StringBuffer();
        newText.append(this.getName());
        switch (this.getQualifier()) {
            case 1: {
                if (this.getOperation() != 0) break;
                newText.append("=");
                break;
            }
            case 2: {
                newText.append(":");
                break;
            }
            default: {
                newText.append(" ");
            }
        }
        newText.append(this.getOperationText()).append(" ").append(this.getExpression());
        return newText.toString();
    }

    public String getAttrOperationAsText() {
        StringBuffer newText = new StringBuffer();
        switch (this.getQualifier()) {
            case 1: {
                if (this.getOperation() != 0) break;
                newText.append("=");
                break;
            }
            case 2: {
                if (this.getOperation() != 0) break;
                newText.append(":");
                break;
            }
        }
        newText.append(this.getOperationText());
        return newText.toString();
    }

    public void setAttrOperationAsText(String newText) {
        if (newText.equals(":=")) {
            this.setOperation(0);
            this.setQualifier(2);
        } else if (newText.equals("==")) {
            this.setOperation(0);
            this.setQualifier(1);
        } else if (newText.equals("!=")) {
            this.setOperation(1);
            this.setQualifier(0);
        } else if (newText.equals("<")) {
            this.setOperation(2);
            this.setQualifier(0);
        } else if (newText.equals(">")) {
            this.setOperation(3);
            this.setQualifier(0);
        } else if (newText.equals("<=")) {
            this.setOperation(4);
            this.setQualifier(0);
        } else if (newText.equals(">=")) {
            this.setOperation(5);
            this.setQualifier(0);
        } else if (newText.equals("== RegExp:")) {
            this.setOperation(6);
            this.setQualifier(0);
        } else if (newText.trim().equals("in")) {
            this.setOperation(7);
            this.setQualifier(0);
        } else if (newText.trim().equals("not in")) {
            this.setOperation(8);
            this.setQualifier(0);
        } else if (!FujabaChangeManager.isInUndoRedo()) {
            throw new RuntimeExceptionWithContext("newText \"" + newText + "\" should not happen !", (FElement)this);
        }
    }

    public static String[] getAllAttrOperationsAsText() {
        if (allAttrOperationsAsText == null) {
            allAttrOperationsAsText = new String[]{":=", "==", "!=", "<", ">", "<=", ">=", "== RegExp:", " in ", " not in "};
        }
        return allAttrOperationsAsText;
    }

    public void removeYou() {
        this.setRevAttrs(null);
        this.setInstanceOf(null);
        super.removeYou();
    }

    public FElement getParentElement() {
        return this.getRevAttrs();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("UMLAttrExprPair[name=");
        result.append(this.getName());
        result.append(",operation=");
        result.append(this.getOperationText());
        result.append(",expression=");
        result.append(this.getExpression());
        result.append(",instanceOf=");
        result.append(this.getInstanceOf());
        result.append("]");
        return result.toString();
    }
}

