/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.sequencer.FlowActivity;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FLinkedList;
import de.upb.tools.sdm.Path;
import java.util.Iterator;

public class UMLActivityDiagram
extends UMLDiagram {
    private UMLMethod storyMethod;
    private boolean createTest = true;
    private boolean isStoryBoard = false;
    private transient boolean hasFlowAssociations = false;
    private transient FLinkedList transitions = null;
    private transient FHashMap newStoryObjects = null;
    private transient UMLComplexState revContains = null;
    private int priority;

    public UMLActivityDiagram(boolean coobraPersistent) {
        super(coobraPersistent);
    }

    public UMLActivityDiagram() {
    }

    public UMLActivityDiagram(String name, UMLProject project) {
        super(name, project);
    }

    public String getName() {
        if (this.getStartActivity() != null && this.getStartActivity().getSpec() != null) {
            return this.getStartActivity().getSpec().getFullMethodName();
        }
        return super.getName();
    }

    public boolean isStatechart() {
        UMLStartActivity start = this.getStartActivity();
        if (start != null) {
            return start.getSpecClass() != null && start.getSpec() == null;
        }
        return false;
    }

    public UMLMethod getStoryMethod() {
        return this.storyMethod;
    }

    public void setStoryMethod(UMLMethod storyMethod) {
        if (this.storyMethod == null && storyMethod != null || this.storyMethod != null && !this.storyMethod.equals(storyMethod)) {
            UMLMethod oldStoryMethod = this.storyMethod;
            if (this.storyMethod != null) {
                this.storyMethod = null;
                oldStoryMethod.setStoryDiag(null);
            }
            this.storyMethod = storyMethod;
            if (storyMethod != null) {
                storyMethod.setStoryDiag(this);
            }
            this.firePropertyChange("storyMethod", oldStoryMethod, storyMethod);
        }
    }

    public boolean isCreateTest() {
        return this.createTest;
    }

    public void setCreateTest(boolean value) {
        if (this.createTest != value) {
            boolean oldValue = this.createTest;
            this.createTest = value;
            this.firePropertyChange("createTest", new Boolean(oldValue), new Boolean(value));
        }
    }

    public boolean getIsStoryBoard() {
        return this.isStoryBoard;
    }

    public void setIsStoryBoard(boolean flag) {
        this.isStoryBoard = flag;
    }

    public Iterator iteratorOfObjects() {
        Iterator tmpIter = FEmptyIterator.get();
        Iterator itemsIter = this.iteratorOfElements();
        while (itemsIter.hasNext()) {
            UMLStoryPattern pattern;
            ASGElement tmpItem = (ASGElement)itemsIter.next();
            if (tmpItem instanceof UMLStoryActivity && (pattern = ((UMLStoryActivity)tmpItem).getStoryPattern()) != null) {
                tmpIter = Path.iterUnion(tmpIter, pattern.iteratorOfObjects());
            }
            if (!(tmpItem instanceof UMLComplexState)) continue;
            UMLComplexState complexState = (UMLComplexState)tmpItem;
            UMLStoryActivity storyActivity = complexState.getStory();
            if (storyActivity != null) {
                UMLStoryPattern storyPattern = storyActivity.getStoryPattern();
                if (storyPattern == null) continue;
                tmpIter = Path.iterUnion(tmpIter, storyPattern.iteratorOfObjects());
                continue;
            }
            UMLActivityDiagram activityDiagram = complexState.getFirstFromContains();
            if (activityDiagram == null) continue;
            tmpIter = Path.iterUnion(tmpIter, activityDiagram.iteratorOfObjects());
        }
        return tmpIter;
    }

    public synchronized void createFlowAssociations() {
        while (this.hasFlowAssociations) {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.hasFlowAssociations = true;
        Iterator iter = this.iteratorOfElements();
        while (iter.hasNext()) {
            ASGElement tmpItem = (ASGElement)iter.next();
            if (!(tmpItem instanceof UMLActivity)) continue;
            FlowActivity tmpFlowActivity = new FlowActivity();
            tmpFlowActivity.setUMLActivity((UMLActivity)tmpItem);
        }
    }

    public void removeFlowAssociations() {
        Iterator iter = this.iteratorOfElements();
        while (iter.hasNext()) {
            ASGElement tmpItem = (ASGElement)iter.next();
            if (!(tmpItem instanceof UMLActivity)) continue;
            FlowActivity tmpFlowActivity = ((UMLActivity)tmpItem).getFlowActivity();
            tmpFlowActivity.removeYou();
        }
        this.hasFlowAssociations = false;
    }

    public UMLStartActivity getStartActivity() {
        UMLStartActivity theStartActivity = null;
        Iterator iter = this.iteratorOfElements();
        while (iter.hasNext() && theStartActivity == null) {
            ASGElement tmpItem = (ASGElement)iter.next();
            if (!(tmpItem instanceof UMLStartActivity)) continue;
            theStartActivity = (UMLStartActivity)tmpItem;
        }
        return theStartActivity;
    }

    private void removeAllFromTransitions() {
        if (this.transitions != null) {
            this.transitions.clear();
        }
    }

    public boolean belongsToState() {
        return this.belongsToMasterState() || this.belongsToSubState();
    }

    public boolean belongsToMasterState() {
        UMLStartActivity startActivity = this.getStartActivity();
        return startActivity != null && startActivity.getRevStartOfStateChart() != null;
    }

    public boolean belongsToSubState() {
        return this.getRevContains() != null;
    }

    public boolean belongsToSimpleState() {
        if (!this.belongsToState()) {
            return false;
        }
        return this.sizeOfElements() == 0;
    }

    public boolean belongsToStateWithSubStates() {
        if (!this.belongsToState()) {
            return false;
        }
        Iterator iter = this.iteratorOfElements();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof UMLComplexState)) continue;
            return true;
        }
        return false;
    }

    public UMLActivityDiagram findActivityDiagramOfMasterState() {
        UMLStartActivity startActivity = this.getStartActivity();
        if (startActivity != null && this.belongsToMasterState()) {
            return this;
        }
        UMLActivityDiagram activityDiag = null;
        UMLActivityDiagram tmpDiag = null;
        UMLComplexState state = this.getRevContains();
        UMLDiagram diag = null;
        if (state != null) {
            diag = state.getFirstFromDiagrams();
        }
        if (diag != null && diag instanceof UMLActivityDiagram) {
            tmpDiag = (UMLActivityDiagram)diag;
            activityDiag = tmpDiag.findActivityDiagramOfMasterState();
        }
        return activityDiag;
    }

    protected void addToNewStoryObjects(UMLObject value) {
        if (value != null && value.getText() != null && !this.hasInNewStoryObjects(value)) {
            if (this.newStoryObjects == null) {
                this.newStoryObjects = new FHashMap();
            }
            this.newStoryObjects.put(value.getText(), value);
        }
    }

    protected boolean hasInNewStoryObjects(UMLObject value) {
        return this.newStoryObjects != null && value != null && value.getText() != null && this.newStoryObjects.get(value.getText()) == value;
    }

    protected UMLObject getFromNewStoryObjects(String key) {
        return this.newStoryObjects == null || key == null ? null : (UMLObject)this.newStoryObjects.get(key);
    }

    protected void removeAllFromNewStoryObjects() {
        if (this.newStoryObjects != null && !this.newStoryObjects.isEmpty()) {
            this.newStoryObjects.clear();
        }
    }

    public String getFullName() {
        String text = null;
        UMLClass parent = null;
        UMLMethod method = null;
        UMLStartActivity activity = this.getStartActivity();
        if (activity != null) {
            method = activity.getSpec();
        }
        if (method != null) {
            parent = method.getParent();
        }
        text = parent != null && parent.getName() != null && parent.getName().length() > 0 ? parent.getName() : "?";
        return String.valueOf(text) + "::" + this;
    }

    public String toString() {
        String text = null;
        UMLMethod method = null;
        UMLStartActivity activity = this.getStartActivity();
        if (activity != null) {
            method = activity.getSpec();
        }
        text = method != null && method.getName() != null && method.getName().length() > 0 ? method.getName() : this.getName();
        return text;
    }

    public void setRevContains(UMLComplexState elem) {
        if (this.revContains == null && elem != null || this.revContains != null && !this.revContains.equals(elem)) {
            UMLComplexState oldRevContains = this.revContains;
            if (this.revContains != null) {
                this.revContains = null;
                oldRevContains.removeFromContains(this);
            }
            this.revContains = elem;
            if (elem != null) {
                elem.addToContains(this);
            }
            this.firePropertyChange("revContains", oldRevContains, elem);
        }
    }

    public UMLComplexState getRevContains() {
        return this.revContains;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int v) {
        if (this.priority != v) {
            int oldValue = this.priority;
            UMLComplexState revContains = this.getRevContains();
            if (revContains != null) {
                revContains.removeFromContains(this);
                this.priority = v;
                revContains.addToContains(this);
            }
            this.priority = v;
            this.firePropertyChange("priority", oldValue, v);
        }
    }

    public void removeYou() {
        Iterator iter = this.iteratorOfElements();
        while (iter.hasNext()) {
            ASGElement item = (ASGElement)iter.next();
            item.removeYou();
        }
        this.removeAllFromNewStoryObjects();
        this.setRevContains(null);
        this.removeAllFromTransitions();
        this.setStoryMethod(null);
        super.removeYou();
    }

    public FElement getParentElement() {
        UMLStartActivity startActivity = this.getStartActivity();
        if (this.getStoryMethod() != null) {
            return this.getStoryMethod();
        }
        if (startActivity != null) {
            if (startActivity.getSpec() != null) {
                return startActivity.getSpec();
            }
            if (startActivity.getRevStartOfStateChart() != null) {
                return startActivity.getRevStartOfStateChart();
            }
            return super.getParentElement();
        }
        return super.getParentElement();
    }
}

