/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.preferences.DebugPreferences;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DebugPreferencesPanel
extends PreferencesPanel {
    private JCheckBox checkBoxDebug;
    private JCheckBox checkBoxSaveGenerated;
    JCheckBox[] debugBoxes;

    public DebugPreferencesPanel() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridBagLayout);
        JPanel folderPanel = this.createDebugPanel();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        mainPanel.add((Component)folderPanel, constraints);
        JPanel editorPanel = this.createDebugMessagePanel();
        mainPanel.add((Component)editorPanel, constraints);
        this.add((Component)mainPanel, "North");
    }

    private JPanel createDebugPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Debug Mode"));
        panel.setLayout(gridBagLayout);
        this.checkBoxDebug = new JCheckBox("Enable Debug Mode");
        this.checkBoxDebug.addActionListener(new DebugCheckBoxActionListener());
        this.checkBoxDebug.setToolTipText("The debug mode enables actions for debugging Fujaba");
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 3, 0, 3);
        constraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.checkBoxDebug, constraints);
        panel.add(this.checkBoxDebug);
        this.checkBoxSaveGenerated = new JCheckBox("Save Generated Increments");
        this.checkBoxSaveGenerated.setToolTipText("Generated increments will be saved in project.");
        constraints.insets = new Insets(2, 3, 3, 3);
        gridBagLayout.setConstraints(this.checkBoxSaveGenerated, constraints);
        panel.add(this.checkBoxSaveGenerated);
        return panel;
    }

    private JPanel createDebugMessagePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Debug Level"));
        panel.setLayout(gridBagLayout);
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 3, 0, 3);
        String[] labelArray = new String[]{"Save/Load", "Code Generation", "Display", "Analyzing", "UML", "Parsing", "Gui", "RemoveYou Methods", "Plug-Ins", "Everything else"};
        this.debugBoxes = new JCheckBox[labelArray.length];
        int rows = labelArray.length / 2;
        int i = 0;
        while (i < labelArray.length) {
            this.debugBoxes[i] = new JCheckBox(labelArray[i]);
            constraints.weightx = i / rows;
            constraints.gridx = i / rows;
            constraints.gridy = i % rows;
            gridBagLayout.setConstraints(this.debugBoxes[i], constraints);
            panel.add(this.debugBoxes[i]);
            ++i;
        }
        return panel;
    }

    public String getPreferredTabName() {
        return "Debug";
    }

    public void setDefaults() {
        DebugPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void setPreferences() {
        DebugPreferences options = DebugPreferences.get();
        this.checkBoxDebug.setSelected(options.isDebugMode());
        this.checkBoxSaveGenerated.setSelected(options.isSaveGenerated());
        this.setDebugBoxes(options.getDebugLevel());
        boolean enabled = this.checkBoxDebug.isSelected();
        int i = 0;
        while (i < this.debugBoxes.length) {
            this.debugBoxes[i].setEnabled(enabled);
            ++i;
        }
    }

    public void okPressed() {
        DebugPreferences options = DebugPreferences.get();
        options.setDebugMode(this.checkBoxDebug.isSelected());
        options.setSaveGenerated(this.checkBoxSaveGenerated.isSelected());
        options.setDebugLevel(this.getDebugBoxes());
    }

    private void setDebugBoxes(int value) {
        int i = 0;
        while (i < this.debugBoxes.length) {
            int pow = (int)Math.pow(2.0, i);
            if ((value & pow) == pow) {
                this.debugBoxes[i].setSelected(true);
            }
            ++i;
        }
    }

    private int getDebugBoxes() {
        int value = 0;
        int i = 0;
        while (i < this.debugBoxes.length) {
            if (this.debugBoxes[i].isSelected()) {
                value = (int)((double)value + Math.pow(2.0, i));
            }
            ++i;
        }
        return value;
    }

    private class DebugCheckBoxActionListener
    implements ActionListener {
        DebugCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            JCheckBox button = (JCheckBox)event.getSource();
            boolean enabled = button.isSelected();
            int i = 0;
            while (i < DebugPreferencesPanel.this.debugBoxes.length) {
                DebugPreferencesPanel.this.debugBoxes[i].setEnabled(enabled);
                ++i;
            }
        }
    }
}

