/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorsPreferencesPanel
extends PreferencesPanel {
    JList colorList;
    JColorChooser colorChooser;
    private Vector colorData;
    private ListSelectionListener selectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            String name = (String)ColorsPreferencesPanel.this.colorList.getSelectedValue();
            Color clr = ColorsPreferences.get().getColor(name);
            if (clr == null) {
                clr = Color.white;
            }
            ColorsPreferencesPanel.this.colorChooser.setColor(clr);
        }
    };
    private ChangeListener colorListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            String name = (String)ColorsPreferencesPanel.this.colorList.getSelectedValue();
            ColorsPreferences.get().setColor(name, ColorsPreferencesPanel.this.colorChooser.getColor());
        }
    };

    public ColorsPreferencesPanel() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridBagLayout);
        mainPanel.setBorder(new TitledBorder("Color Settings"));
        this.colorData = new Vector();
        this.colorList = new JList(this.colorData);
        this.colorList.setToolTipText("Fujaba needs to be restarted for all color changes to take effect.");
        this.colorList.addListSelectionListener(this.selectionListener);
        JScrollPane scrollPane = new JScrollPane(this.colorList);
        constraints.gridwidth = -1;
        constraints.fill = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        mainPanel.add((Component)scrollPane, constraints);
        this.colorChooser = new JColorChooser();
        this.colorChooser.getSelectionModel().addChangeListener(this.colorListener);
        constraints.weightx = 1.0;
        mainPanel.add((Component)this.colorChooser, constraints);
        this.add((Component)mainPanel, "North");
        this.setPreferences();
    }

    public String getPreferredTabName() {
        return "Colors";
    }

    public void okPressed() {
        ColorsPreferences.get().save();
    }

    public void setDefaults() {
        ColorsPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void setPreferences() {
        this.colorData.clear();
        Iterator it = ColorsPreferences.get().getColors();
        while (it.hasNext()) {
            String name = (String)it.next();
            this.colorData.add(name);
        }
        if (this.colorData.size() > 0) {
            this.colorList.setSelectedIndex(0);
        }
    }
}

