/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.preferences.LoggingPreferences;
import de.uni_paderborn.fujaba.preferences.gui.FujabaPreferencesDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppenderPanel
extends JPanel {
    private String displayName;
    private String configName;
    JCheckBox enabledBox;
    private final String[] THRESHOLDS = new String[]{"Debug", "Info", "Warn", "Error", "Fatal"};
    private JLabel thresholdLabel = new JLabel("Threshold");
    private JComboBox thresholdCombo = new JComboBox<String>(this.THRESHOLDS);
    private GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private Hashtable componentMap = new Hashtable();
    private static final String CONVERSION_PATTERN = "Conversion Pattern";
    private static final String PORT = "Port";
    private static final String JLABEL = "";

    public String getConfigName() {
        return this.configName;
    }

    public AppenderPanel(String theDisplayName, String theConfigName) {
        this.displayName = theDisplayName;
        this.configName = theConfigName;
        this.setLayout(this.gridBag);
        this.enabledBox = new JCheckBox(this.displayName);
        this.enabledBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AppenderPanel.this.setFieldsEnabled(AppenderPanel.this.enabledBox.isSelected());
            }
        });
        this.constraints.gridwidth = 0;
        this.constraints.fill = 2;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(0, 4, 0, 0);
        this.gridBag.setConstraints(this.enabledBox, this.constraints);
        this.add(this.enabledBox);
        this.addComponent(this.thresholdLabel, this.thresholdCombo);
    }

    public void addCheckBox(String name, String param) {
        JLabel label = new JLabel(name);
        JCheckBox checkBox = new JCheckBox();
        this.addComponent(label, checkBox);
        this.componentMap.put(label, JLABEL);
        this.componentMap.put(checkBox, param);
    }

    public void addTextField(String name, String param) {
        JLabel label = new JLabel(name);
        JTextField textField = new JTextField(25);
        this.addComponent(label, textField);
        this.componentMap.put(label, JLABEL);
        this.componentMap.put(textField, param);
    }

    public void addFileSelector(String name, String param) {
        JLabel label = new JLabel(name);
        FileSelector selector = new FileSelector();
        this.addComponent(label, selector);
        this.componentMap.put(label, JLABEL);
        this.componentMap.put(selector, param);
    }

    public void addPatternField() {
        this.addTextField(CONVERSION_PATTERN, CONVERSION_PATTERN);
    }

    public void addPortField() {
        this.addTextField(PORT, PORT);
    }

    private void addComponent(JLabel label, JComponent component) {
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.gridwidth = -1;
        this.constraints.insets = new Insets(0, 30, 0, 0);
        this.gridBag.setConstraints(label, this.constraints);
        label.setEnabled(false);
        this.add(label);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.gridwidth = 0;
        this.constraints.insets = new Insets(0, 4, 0, 0);
        this.gridBag.setConstraints(component, this.constraints);
        component.setEnabled(false);
        this.add(component);
    }

    public void setOptions() {
        LoggingPreferences options = LoggingPreferences.get();
        this.getThreshold();
        Enumeration components = this.componentMap.keys();
        while (components.hasMoreElements()) {
            JComponent component = (JComponent)components.nextElement();
            String param = (String)this.componentMap.get(component);
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected(Boolean.valueOf(options.getAppenderParam(param, this.configName)));
                continue;
            }
            if (component instanceof JTextField) {
                if (CONVERSION_PATTERN.equals(param)) {
                    ((JTextField)component).setText(options.getAppenderPattern(this.configName));
                    continue;
                }
                ((JTextField)component).setText(options.getAppenderParam(param, this.configName));
                continue;
            }
            if (!(component instanceof FileSelector)) continue;
            ((FileSelector)component).setFilename(options.getAppenderParam(param, this.configName));
        }
    }

    public void updateOptions() {
        LoggingPreferences options = LoggingPreferences.get();
        this.setThreshold();
        Enumeration components = this.componentMap.keys();
        while (components.hasMoreElements()) {
            JComponent component = (JComponent)components.nextElement();
            String param = (String)this.componentMap.get(component);
            if (component instanceof JCheckBox) {
                options.setAppenderParam(param, String.valueOf(((JCheckBox)component).isSelected()), this.configName);
                continue;
            }
            if (component instanceof JTextField) {
                if (CONVERSION_PATTERN.equals(param)) {
                    options.setAppenderPattern(((JTextField)component).getText(), this.configName);
                    continue;
                }
                options.setAppenderParam(param, ((JTextField)component).getText(), this.configName);
                continue;
            }
            if (!(component instanceof FileSelector)) continue;
            options.setAppenderParam(param, ((FileSelector)component).getFilename(), this.configName);
        }
    }

    public void setContentsEnabled(boolean enabled) {
        this.enabledBox.setEnabled(enabled);
        this.setFieldsEnabled(enabled && this.enabledBox.isSelected());
    }

    void setFieldsEnabled(boolean enabled) {
        Enumeration components = this.componentMap.keys();
        if (enabled) {
            this.thresholdLabel.setEnabled(true);
            this.thresholdCombo.setEnabled(true);
            while (components.hasMoreElements()) {
                JComponent component = (JComponent)components.nextElement();
                component.setEnabled(true);
            }
        } else {
            this.thresholdLabel.setEnabled(false);
            this.thresholdCombo.setEnabled(false);
            while (components.hasMoreElements()) {
                JComponent component = (JComponent)components.nextElement();
                component.setEnabled(false);
            }
        }
    }

    private void getThreshold() {
        LoggingPreferences options = LoggingPreferences.get();
        String threshold = options.getAppenderParam("Threshold", this.configName);
        if (threshold.equalsIgnoreCase("Off")) {
            this.enabledBox.setSelected(false);
        } else {
            this.enabledBox.setSelected(true);
            boolean found = false;
            int i = 0;
            while (i < this.THRESHOLDS.length) {
                if (threshold.equalsIgnoreCase(this.THRESHOLDS[i])) {
                    this.thresholdCombo.setSelectedItem(this.THRESHOLDS[i]);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.thresholdCombo.setSelectedItem("Debug");
            }
        }
    }

    private void setThreshold() {
        LoggingPreferences options = LoggingPreferences.get();
        if (!this.enabledBox.isSelected()) {
            options.setAppenderParam("Threshold", "Off".toLowerCase(), this.configName);
        } else {
            options.setAppenderParam("Threshold", ((String)this.thresholdCombo.getSelectedItem()).toLowerCase(), this.configName);
        }
    }

    private class FileSelector
    extends JPanel {
        private JButton browseButton = new JButton("...");
        private JTextField fileField;

        public FileSelector() {
            this.browseButton.addActionListener(new ActionListener(this){
                final /* synthetic */ FileSelector this$1;
                {
                    this.this$1 = fileSelector;
                }

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser();
                    File currentFile = new File(this.this$1.getFilename());
                    fileChooser.setSelectedFile(currentFile);
                    fileChooser.setDialogType(1);
                    fileChooser.setDialogTitle("Select file");
                    fileChooser.setApproveButtonText("Select");
                    fileChooser.setApproveButtonMnemonic(KeyStroke.getKeyStroke(83, 8).getKeyCode());
                    fileChooser.setApproveButtonToolTipText("Select the named file");
                    if (fileChooser.showDialog(FujabaPreferencesDialog.get(), null) == 0) {
                        File file = fileChooser.getSelectedFile();
                        String filePath = file.getAbsolutePath();
                        this.this$1.setFilename(filePath);
                    }
                }
            });
            this.fileField = new JTextField(20);
            this.fileField.setEditable(false);
            GridBagLayout selBag = new GridBagLayout();
            GridBagConstraints selConstraints = new GridBagConstraints();
            super.setLayout(selBag);
            selConstraints.gridwidth = -1;
            selConstraints.fill = 1;
            selConstraints.weightx = 1.0;
            selConstraints.weighty = 1.0;
            selConstraints.insets = new Insets(1, 0, 1, 1);
            selBag.setConstraints(this.fileField, selConstraints);
            super.add(this.fileField);
            selConstraints.gridwidth = -1;
            selConstraints.fill = 3;
            selConstraints.weightx = 0.0;
            selConstraints.weighty = 0.0;
            selConstraints.insets = new Insets(1, 0, 0, 1);
            selBag.setConstraints(this.browseButton, selConstraints);
            super.add(this.browseButton);
        }

        public void setEnabled(boolean enabled) {
            this.browseButton.setEnabled(enabled);
            this.fileField.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void setFilename(String filename) {
            this.fileField.setText(filename.replace(File.separatorChar, '/'));
        }

        public String getFilename() {
            return this.fileField.getText().replace(File.separatorChar, '/');
        }
    }
}

