/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.preferences.DebugPreferences;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.preferences.IconsPreferences;
import de.uni_paderborn.fujaba.preferences.JavaPreferences;
import de.uni_paderborn.fujaba.preferences.LoggingPreferences;
import de.uni_paderborn.fujaba.preferences.PlugInsPreferences;
import de.uni_paderborn.lib.util.StringManipulation;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;

public class PreferencesProperties {
    private static final String CORE_PROPERTIES = "core/Fujaba.properties";
    public static final String PROPERTY_DIR_PROPERTY = "propertyDir_" + FujabaApp.FUJABA_BASE.toString();
    private static final String PROPERTY_DIR = "fujaba";
    private File settingsFile;
    private Properties properties = new Properties();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static String baseDir = System.getProperty("user.home");
    private static HashMap propertyOptions = new HashMap();
    private static String propertyDir = null;

    private PreferencesProperties() {
    }

    public static PreferencesProperties get() {
        PreferencesProperties coreOptions = (PreferencesProperties)propertyOptions.get(CORE_PROPERTIES);
        if (coreOptions == null) {
            coreOptions = new PreferencesProperties();
            propertyOptions.put(CORE_PROPERTIES, coreOptions);
            coreOptions.load(CORE_PROPERTIES);
        }
        return coreOptions;
    }

    public static PreferencesProperties get(String fileName) {
        PreferencesProperties currentOptions = (PreferencesProperties)propertyOptions.get(fileName);
        if (currentOptions == null) {
            currentOptions = new PreferencesProperties();
            propertyOptions.put(fileName, currentOptions);
            currentOptions.load(fileName);
        }
        return currentOptions;
    }

    public static void saveAll() {
        Iterator iter = propertyOptions.values().iterator();
        while (iter.hasNext()) {
            PreferencesProperties currentOptions = (PreferencesProperties)iter.next();
            currentOptions.save();
        }
    }

    public void save() {
        try {
            this.properties.store(new FileOutputStream(this.settingsFile), "Fujaba Properties, Do NOT edit!");
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + this.settingsFile + " could not be saved!");
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println("File " + this.settingsFile + " could not be saved!");
            System.err.println(e.getMessage());
        }
    }

    private void load(String fileName) {
        String fixedFileName = StringManipulation.fixFileNameSeparators(fileName);
        String dirName = PreferencesProperties.getPropertyDir();
        if (fixedFileName.lastIndexOf(File.separatorChar) != -1) {
            dirName = String.valueOf(dirName) + fixedFileName.substring(0, fixedFileName.lastIndexOf(File.separatorChar));
        }
        File dir = new File(dirName);
        dir.mkdirs();
        this.settingsFile = new File(String.valueOf(PreferencesProperties.getPropertyDir()) + fixedFileName);
        try {
            if (this.settingsFile.exists()) {
                this.properties.load(new FileInputStream(this.settingsFile));
            } else {
                boolean fileCreated = this.settingsFile.createNewFile();
                if (fileCreated) {
                    System.out.println("created preference file '" + this.settingsFile + "'");
                }
                if (CORE_PROPERTIES.equals(fileName)) {
                    this.generateDefaultSettings();
                    this.save();
                }
            }
        }
        catch (Exception e) {
            System.err.println("The preferences " + this.settingsFile + " could not be loaded!");
            e.printStackTrace();
        }
    }

    public static String getPropertyDir() {
        if (propertyDir == null) {
            PreferencesProperties.setPropertyDir(PreferencesProperties.getProposedPropertyDir());
        }
        return propertyDir;
    }

    public static void setPropertyDir(String value) {
        if (!value.endsWith(File.separator)) {
            value = String.valueOf(value) + File.separator;
        }
        if (value != propertyDir) {
            propertyDir = value;
        }
    }

    public static String getProposedPropertyDir() {
        StringBuffer propertyDirBuffer = new StringBuffer();
        propertyDirBuffer.append(baseDir);
        propertyDirBuffer.append(File.separatorChar);
        if ("Linux".equals(System.getProperty("os.name")) || "Unix".equals(System.getProperty("os.name"))) {
            propertyDirBuffer.append(".");
        }
        propertyDirBuffer.append(PROPERTY_DIR);
        propertyDirBuffer.append(File.separatorChar);
        return propertyDirBuffer.toString();
    }

    private void generateDefaultSettings() {
        GeneralPreferences.get().setDefaults();
        JavaPreferences.get().setDefaults();
        IconsPreferences.get().setDefaults();
        ColorsPreferences.get().setDefaults();
        DebugPreferences.get().setDefaults();
        LoggingPreferences.get().setDefaults();
        PlugInsPreferences.get().setDefaults();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.propertyChangeSupport.firePropertyChange(event);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String arg0) {
        return this.propertyChangeSupport.getPropertyChangeListeners(arg0);
    }

    public boolean hasListeners(String arg0) {
        return this.propertyChangeSupport.hasListeners(arg0);
    }

    public String getSetting(String key) {
        return this.properties.getProperty(key);
    }

    public String getSetting(String key, String defaultValue) {
        String result = this.getSetting(key);
        if (result == null) {
            this.putSetting(key, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    public boolean getBoolSetting(String key) {
        return this.getBoolSetting(key, false);
    }

    public boolean getBoolSetting(String key, boolean defaultValue) {
        String result = this.getSetting(key, String.valueOf(defaultValue));
        return Boolean.valueOf(result);
    }

    public int getIntSetting(String key) throws NumberFormatException {
        return this.getIntSetting(key, 0);
    }

    public int getIntSetting(String key, int defaultValue) throws NumberFormatException {
        String result = this.getSetting(key, String.valueOf(defaultValue));
        return Integer.valueOf(result);
    }

    public float getFloatSetting(String key) throws NumberFormatException {
        return this.getFloatSetting(key, 0.0f);
    }

    public float getFloatSetting(String key, float defaultValue) throws NumberFormatException {
        String result = this.getSetting(key, String.valueOf(defaultValue));
        return Float.valueOf(result).floatValue();
    }

    public double getDoubleSetting(String key) throws NumberFormatException {
        return this.getDoubleSetting(key, 0.0);
    }

    public double getDoubleSetting(String key, double defaultValue) throws NumberFormatException {
        String result = this.getSetting(key, String.valueOf(defaultValue));
        return Double.valueOf(result);
    }

    public Vector getVectorSetting(String key) {
        return this.getVectorSetting(key, new Vector());
    }

    /*
     * Unable to fully structure code
     */
    public Vector getVectorSetting(String key, Vector defVector) {
        vector = new Vector<String>();
        i = 0;
        value = this.getSetting(String.valueOf(key) + i);
        if (value != null) ** GOTO lbl8
        return defVector;
lbl-1000:
        // 1 sources

        {
            vector.addElement(value);
            value = this.getSetting(String.valueOf(key) + ++i);
lbl8:
            // 2 sources

            ** while (value != null)
        }
lbl9:
        // 1 sources

        return vector;
    }

    public Hashtable getHashtableSetting(String key, String name) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int i = 0;
        String secondaryKey = this.getSetting(String.valueOf(key) + name + i);
        String value = null;
        while (secondaryKey != null) {
            value = this.getSetting(String.valueOf(key) + name + secondaryKey);
            if (value != null) {
                hashtable.put(secondaryKey, value);
            }
            secondaryKey = this.getSetting(String.valueOf(key) + name + ++i);
        }
        return hashtable;
    }

    public Color getColorSetting(String key, Color defaultValue) {
        int red = this.getIntSetting(String.valueOf(key) + "_R", defaultValue.getRed());
        int green = this.getIntSetting(String.valueOf(key) + "_G", defaultValue.getGreen());
        int blue = this.getIntSetting(String.valueOf(key) + "_B", defaultValue.getBlue());
        return new Color(red, green, blue);
    }

    public void putSetting(String key, String value) {
        Object oldValue = this.properties.get(key);
        this.properties.put(key, value);
        this.propertyChangeSupport.firePropertyChange(key, oldValue, value);
    }

    public void putSetting(String key, boolean value) {
        this.putSetting(key, String.valueOf(value));
    }

    public void putSetting(String key, int value) {
        this.putSetting(key, String.valueOf(value));
    }

    public void putSetting(String key, float value) {
        this.putSetting(key, String.valueOf(value));
    }

    public void putSetting(String key, double value) {
        this.putSetting(key, String.valueOf(value));
    }

    public void putSetting(String key, List settings) {
        int i = 0;
        while (this.getSetting(String.valueOf(key) + i) != null) {
            this.properties.remove(String.valueOf(key) + i);
            ++i;
        }
        ListIterator listIter = settings.listIterator();
        while (listIter.hasNext()) {
            i = listIter.nextIndex();
            String value = listIter.next().toString();
            this.putSetting(String.valueOf(key) + i, value);
        }
    }

    public void putSetting(String key, String name, Hashtable settings) {
        int i = 0;
        String secondaryKey = this.getSetting(String.valueOf(key) + name + i);
        while (secondaryKey != null) {
            this.properties.remove(String.valueOf(key) + name + i);
            this.properties.remove(String.valueOf(key) + name + secondaryKey);
            secondaryKey = this.getSetting(String.valueOf(key) + name + ++i);
        }
        i = 0;
        Enumeration keyEnum = settings.keys();
        while (keyEnum.hasMoreElements()) {
            secondaryKey = keyEnum.nextElement().toString();
            String value = settings.get(secondaryKey).toString();
            this.putSetting(String.valueOf(key) + name + i, secondaryKey);
            this.putSetting(String.valueOf(key) + name + secondaryKey, value);
            ++i;
        }
    }

    public void putSetting(String key, Color col) {
        this.properties.remove(String.valueOf(key) + "_R");
        this.properties.remove(String.valueOf(key) + "_G");
        this.properties.remove(String.valueOf(key) + "_B");
        this.putSetting(String.valueOf(key) + "_R", col.getRed());
        this.putSetting(String.valueOf(key) + "_G", col.getGreen());
        this.putSetting(String.valueOf(key) + "_B", col.getBlue());
    }
}

