/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Vector;

public class PlugInsPreferences
extends AbstractPreferences {
    public static final String PROPERTY_NAME = "PlugIns.";
    public static final String PLUGIN_SERVER_LIST = "http://www.uni-paderborn.de/cs/fujaba/downloads/plugins/PluginServer.xml";
    public static final String FOLDERS = "Folders";
    public static final String DOWNLOAD_URLS = "DownloadURL";
    private static final String DEF_FOLDER;
    private static PlugInsPreferences pluginOptions;

    static {
        String defFolder = "./plugins";
        if (FujabaApp.FUJABA_BASE != null) {
            try {
                URI pluginUri = FujabaApp.FUJABA_BASE.resolve("plugins");
                defFolder = new File(pluginUri).getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DEF_FOLDER = defFolder;
    }

    private PlugInsPreferences() {
    }

    public static synchronized PlugInsPreferences get() {
        if (pluginOptions == null) {
            pluginOptions = new PlugInsPreferences();
        }
        return pluginOptions;
    }

    public void setDefaults() {
        PreferencesProperties propertyOptions = PreferencesProperties.get();
        Vector<String> folders = new Vector<String>();
        folders.add(DEF_FOLDER);
        propertyOptions.putSetting("PlugIns.Folders", folders);
        Vector downloadURLs = new Vector();
        propertyOptions.putSetting("PlugIns.DownloadURL", downloadURLs);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().removePropertyChangeListener(propertyName, listener);
    }

    public void setPluginFolders(Vector value) {
        PreferencesProperties.get().putSetting("PlugIns.Folders", value);
        this.setModified(true);
    }

    public Vector getPluginFolders() {
        Vector<String> defaultVector = new Vector<String>();
        defaultVector.add(DEF_FOLDER);
        return PreferencesProperties.get().getVectorSetting("PlugIns.Folders", defaultVector);
    }

    public void setPluginDownloadURLs(Vector value) {
        PreferencesProperties.get().putSetting("PlugIns.DownloadURL", value);
        this.setModified(true);
    }

    public Vector getPluginDownloadURLs() {
        Vector defaultVector = new Vector();
        return PreferencesProperties.get().getVectorSetting("PlugIns.DownloadURL", defaultVector);
    }
}

