/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.logging.LoggerInfo;
import de.uni_paderborn.fujaba.logging.LoggingConfigException;
import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.ParseConfigErrorHandler;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.varia.NullAppender;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LoggingPreferences
extends AbstractPreferences {
    private static LoggingPreferences options;
    private Document log4JConfig;
    private String configFile = String.valueOf(PreferencesProperties.getPropertyDir()) + "core" + File.separatorChar + "log4j-config.xml";
    private String defaultConfigFile = "/de/uni_paderborn/fujaba/logging/log4j-default-config.xml";
    private Hashtable appenderCache = new Hashtable();

    protected LoggingPreferences() {
        if (new File(this.configFile).exists()) {
            try {
                this.loadFile(new File(this.configFile));
                this.configureLog4J();
            }
            catch (LoggingConfigException logEx) {
                System.err.println("Error whilst loading log4j settings from " + this.configFile);
                System.err.println("Error was:");
                System.err.println(logEx.getMessage());
                System.err.println("Reverting to default settings.");
                this.initWithDefaults();
                if (this.configLoaded()) {
                    this.configureLog4J();
                }
            }
        } else {
            System.err.println("No log4j configuration file found - loading default settings from " + this.defaultConfigFile);
            this.initWithDefaults();
            if (this.configLoaded()) {
                this.saveSettings();
                this.configureLog4J();
            }
        }
    }

    private void initWithDefaults() {
        try {
            this.loadDefaults();
        }
        catch (LoggingConfigException e) {
            System.err.println(e.getMessage());
            System.err.println("Could not initialise logging mechanism.  All logging stopped until mechanism is configured.");
            LoggerRepository repository = LogManager.getLoggerRepository();
            repository.resetConfiguration();
            Logger rootLogger = repository.getRootLogger();
            rootLogger.addAppender((Appender)new NullAppender());
            rootLogger.setLevel(Level.OFF);
        }
    }

    public static synchronized LoggingPreferences get() {
        if (options == null) {
            options = new LoggingPreferences();
        }
        return options;
    }

    public void setDefaults() {
        this.appenderCache = new Hashtable();
        try {
            this.loadDefaults();
        }
        catch (LoggingConfigException e) {
            System.err.println(e.getMessage());
        }
        if (this.log4JConfig != null) {
            this.configureLog4J();
        }
    }

    public void loadFile(File file) throws LoggingConfigException {
        this.appenderCache = new Hashtable();
        FileInputStream configStream = null;
        try {
            configStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new LoggingConfigException("Cannot load " + file.getName() + " - file not found.");
        }
        ParseConfigErrorHandler handler = new ParseConfigErrorHandler();
        Document tempConfig = null;
        try {
            tempConfig = this.parse(configStream, handler);
            configStream.close();
        }
        catch (IOException ioEx) {
            throw new LoggingConfigException("I/O problem encountered whilst parsing " + file.getName() + ".\n" + ioEx.getMessage());
        }
        catch (SAXException saxEx) {
            throw new LoggingConfigException("Parsing error in " + file.getName() + ".\n" + saxEx.getMessage());
        }
        if (handler.getErrorCount() > 0) {
            throw new LoggingConfigException("Parsing error in " + file.getName() + ".\n" + handler.getMessage());
        }
        if (tempConfig == null) {
            throw new LoggingConfigException("Unidentified error whilst parsing " + file.getName());
        }
        this.log4JConfig = tempConfig;
    }

    public void configureLog4J() {
        LogManager.resetConfiguration();
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - log4j not configured.");
            return;
        }
        DOMConfigurator.configure((Element)this.log4JConfig.getDocumentElement());
    }

    public void saveSettings() {
        FileWriter configWriter;
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - settings have not been saved");
            return;
        }
        OutputFormat format = new OutputFormat(this.log4JConfig);
        format.setIndenting(true);
        File parentDir = new File(this.configFile).getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        try {
            configWriter = new FileWriter(this.configFile);
        }
        catch (IOException ioEx) {
            System.err.println("Could not open " + this.configFile + " for writing.");
            System.err.println("log4j settings not saved.");
            return;
        }
        XMLSerializer serializer = new XMLSerializer(configWriter, format);
        try {
            serializer.serialize(this.log4JConfig);
        }
        catch (IOException ioEx) {
            System.err.println("Could not save log4j settings to " + this.configFile + "!");
        }
        try {
            configWriter.close();
        }
        catch (IOException ioEx) {
            System.err.println("Could not close connection to " + this.configFile);
        }
    }

    public void generateTestMsgs() {
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            this.testLogger(logger);
        }
        Logger rootLogger = LogManager.getRootLogger();
        this.testLogger(rootLogger);
    }

    private void testLogger(Logger logger) {
        String name = logger.getName();
        logger.debug((Object)("Testing a DEBUG call to logger " + name));
        logger.info((Object)("Testing an INFO call to logger " + name));
        logger.warn((Object)("Testing a WARN call to logger " + name));
        logger.error((Object)("Testing an ERROR call to logger " + name));
        logger.fatal((Object)("Testing a FATAL call to logger " + name));
    }

    public boolean isValidLoggerName(String name) {
        return XMLCharacterProperties.validName(name);
    }

    private void loadDefaults() throws LoggingConfigException {
        ParseConfigErrorHandler handler = new ParseConfigErrorHandler();
        Document tempConfig = null;
        try {
            Class<?> clazz = this.getClass();
            URL defaultsURL = clazz.getResource(this.defaultConfigFile);
            if (defaultsURL == null) {
                throw new LoggingConfigException("Could not find [" + this.defaultConfigFile + "]. Used [" + clazz.getClassLoader() + "] class loader in the search.");
            }
            tempConfig = this.parse(defaultsURL.openStream(), handler);
        }
        catch (IOException ioEx) {
            throw new LoggingConfigException("I/O exception encountered whilst trying to load default log4j configuration from " + this.defaultConfigFile + "\nError was:" + ioEx.toString());
        }
        catch (SAXException saxEx) {
            throw new LoggingConfigException("Parsing error whilst loading default log4j configuration from " + this.defaultConfigFile + "\nError was:" + saxEx.toString());
        }
        if (handler.getErrorCount() > 0) {
            throw new LoggingConfigException("Parsing error whilst loading default log4j configuration from " + this.defaultConfigFile + "\nError was:" + handler.getMessage());
        }
        if (tempConfig == null) {
            throw new LoggingConfigException("Unidentified error whilst parsing default log4j configuration file " + this.defaultConfigFile);
        }
        this.log4JConfig = tempConfig;
    }

    private Document parse(InputStream xmlStream, ErrorHandler handler) throws IOException, SAXException {
        InputSource source = new InputSource(xmlStream);
        Class<?> clazz = this.getClass();
        URL dtdURL = clazz.getResource("/org/apache/log4j/xml/log4j.dtd");
        if (dtdURL == null) {
            System.err.println("Could not find [log4j.dtd]. Used [" + clazz.getClassLoader() + "] class loader in the search.");
        } else {
            source.setSystemId(dtdURL.toString());
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(handler);
            return parser.parse(source);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    public boolean configLoaded() {
        return this.log4JConfig != null;
    }

    public void updateLogger(LoggerInfo info) {
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - cannot update logger");
            return;
        }
        String name = info.getName();
        Node loggerNode = this.getLoggerNode(name);
        if (loggerNode == null) {
            try {
                Vector<String> successors = new Vector<String>();
                successors.add("root");
                successors.add("categoryFactory");
                Hashtable<String, String> atts = new Hashtable<String, String>();
                atts.put("name", name);
                loggerNode = this.insertElement(this.log4JConfig.getDocumentElement(), "logger", atts, successors);
            }
            catch (DOMException domEx) {
                System.err.println("Error thrown whilst trying to create element for logger " + name + ": " + domEx);
                return;
            }
        }
        if (loggerNode != null) {
            this.updateLoggerNode(loggerNode, info);
        } else {
            System.err.println("Unidentified error whilst trying to create element for logger " + name);
        }
    }

    public void deleteLogger(String name) {
        Node loggerNode = this.getLoggerNode(name);
        if (loggerNode == null) {
            return;
        }
        Node loggerParent = loggerNode.getParentNode();
        loggerParent.removeChild(loggerNode);
    }

    public void updateRootLogger(LoggerInfo info) {
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - cannot update root logger");
            return;
        }
        Element docEl = this.log4JConfig.getDocumentElement();
        Node rootNode = null;
        NodeList configChildren = docEl.getChildNodes();
        int i = 0;
        while (i < configChildren.getLength()) {
            Node configChild = configChildren.item(i);
            if (configChild.getNodeType() == 1 && configChild.getNodeName().equals("root")) {
                rootNode = configChild;
            }
            ++i;
        }
        if (rootNode == null) {
            try {
                Vector<String> successors = new Vector<String>();
                successors.add("categoryFactory");
                Hashtable atts = new Hashtable();
                rootNode = this.insertElement(docEl, "root", atts, successors);
            }
            catch (DOMException domEx) {
                System.err.println("Error thrown whilst trying to create element for root logger: " + domEx);
                return;
            }
        }
        if (rootNode != null) {
            this.updateLoggerNode(rootNode, info);
        } else {
            System.err.println("Unidentified error whilst trying to create element for root logger");
        }
    }

    private Node getLoggerNode(String name) {
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - cannot get logger node");
            return null;
        }
        Node loggerNode = null;
        Element docEl = this.log4JConfig.getDocumentElement();
        NodeList configChildren = docEl.getChildNodes();
        int i = 0;
        while (i < configChildren.getLength()) {
            Node configChild = configChildren.item(i);
            if (configChild.getNodeType() == 1 && configChild.getNodeName().equals("logger") && this.subst(((Element)configChild).getAttribute("name")).equals(name)) {
                loggerNode = configChild;
                break;
            }
            ++i;
        }
        return loggerNode;
    }

    private void updateLoggerNode(Node node, LoggerInfo info) {
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - cannot update logger node");
            return;
        }
        boolean foundLevel = false;
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node child = children.item(j);
            if (child.getNodeType() == 1 && child.getNodeName().equals("level")) {
                foundLevel = true;
                try {
                    ((Element)child).setAttribute("value", info.getLevel().toLowerCase());
                }
                catch (DOMException domEx) {
                    System.err.println("Error thrown whilst trying to update level element for " + info.getName() + ": " + domEx);
                }
            }
            ++j;
        }
        if (!foundLevel) {
            Element loggerEl = (Element)node;
            try {
                Vector<String> successors = new Vector<String>();
                successors.add("appender-ref");
                Hashtable<String, String> atts = new Hashtable<String, String>();
                atts.put("value", info.getLevel().toLowerCase());
                this.insertElement(loggerEl, "level", atts, successors);
            }
            catch (DOMException domEx) {
                System.err.println("Error thrown whilst trying to create level element for logger " + info.getName() + ": " + domEx);
            }
        }
    }

    private Element insertElement(Element parent, String name, Map atts, List successors) throws DOMException {
        Element newEl = this.log4JConfig.createElement(name);
        Iterator attsIter = atts.keySet().iterator();
        while (attsIter.hasNext()) {
            String attName = (String)attsIter.next();
            String attValue = (String)atts.get(attName);
            newEl.setAttribute(attName, attValue);
        }
        Node followingNode = null;
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && successors.contains(child.getNodeName())) {
                followingNode = child;
                break;
            }
            ++i;
        }
        parent.insertBefore(newEl, followingNode);
        return newEl;
    }

    public LoggerInfo getRootLogger() {
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - cannot retrieve root logger");
            return null;
        }
        String rootLevel = "Debug";
        NodeList configChildren = this.log4JConfig.getDocumentElement().getChildNodes();
        int i = 0;
        block0: while (i < configChildren.getLength()) {
            Node configChild = configChildren.item(i);
            if (configChild.getNodeType() == 1 && configChild.getNodeName().equals("root")) {
                NodeList rootChildren = configChild.getChildNodes();
                int j = 0;
                while (j < rootChildren.getLength()) {
                    Node rootChild = rootChildren.item(j);
                    if (rootChild.getNodeType() == 1 && rootChild.getNodeName().equals("level")) {
                        Element levelEl = (Element)rootChild;
                        rootLevel = this.subst(levelEl.getAttribute("value"));
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return new LoggerInfo("root", rootLevel);
    }

    public Collection getLoggers() {
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - cannot retrieve loggers");
            return null;
        }
        Vector<LoggerInfo> loggers = new Vector<LoggerInfo>();
        NodeList configChildren = this.log4JConfig.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < configChildren.getLength()) {
            Node configChild = configChildren.item(i);
            if (configChild.getNodeType() == 1 && configChild.getNodeName().equals("logger")) {
                String loggerName = this.subst(((Element)configChild).getAttribute("name"));
                String loggerLevel = "Inherited";
                NodeList loggerChildren = configChild.getChildNodes();
                int j = 0;
                while (j < loggerChildren.getLength()) {
                    Node loggerChild = loggerChildren.item(j);
                    if (loggerChild.getNodeType() == 1 && loggerChild.getNodeName().equals("level")) {
                        Element levelEl = (Element)loggerChild;
                        loggerLevel = this.subst(levelEl.getAttribute("value"));
                        break;
                    }
                    ++j;
                }
                loggers.add(new LoggerInfo(loggerName, loggerLevel));
            }
            ++i;
        }
        return loggers;
    }

    public String getAppenderParam(String param, String appender) {
        Node appenderNode = this.getAppenderNode(appender);
        return this.getParam(param, appenderNode);
    }

    public String getAppenderPattern(String appenderName) {
        Node appenderNode = this.getAppenderNode(appenderName);
        NodeList appenderChildren = appenderNode.getChildNodes();
        int i = 0;
        while (i < appenderChildren.getLength()) {
            Node appenderChild = appenderChildren.item(i);
            if (appenderChild.getNodeType() == 1 && appenderChild.getNodeName().equals("layout")) {
                return this.getParam("ConversionPattern", appenderChild);
            }
            ++i;
        }
        return null;
    }

    public void setAppenderParam(String param, String value, String appender) {
        Node appenderNode = this.getAppenderNode(appender);
        this.setParam(param, value, appenderNode);
    }

    public void setAppenderPattern(String pattern, String appenderName) {
        Node appenderNode = this.getAppenderNode(appenderName);
        NodeList appenderChildren = appenderNode.getChildNodes();
        int i = 0;
        while (i < appenderChildren.getLength()) {
            Node appenderChild = appenderChildren.item(i);
            if (appenderChild.getNodeType() == 1 && appenderChild.getNodeName().equals("layout")) {
                this.setParam("ConversionPattern", pattern, appenderChild);
            }
            ++i;
        }
    }

    private Node getAppenderNode(String name) {
        if (!this.configLoaded()) {
            System.err.println("log4j configuration settings not loaded correctly - cannot get appender node");
            return null;
        }
        Node appenderNode = (Node)this.appenderCache.get(name);
        if (appenderNode != null) {
            return appenderNode;
        }
        Element docEl = this.log4JConfig.getDocumentElement();
        NodeList docChildren = docEl.getChildNodes();
        int i = 0;
        while (i < docChildren.getLength()) {
            String appenderName;
            Node docChild = docChildren.item(i);
            if (docChild.getNodeType() == 1 && docChild.getNodeName().equals("appender") && (appenderName = this.subst(((Element)docChild).getAttribute("name"))).equals(name)) {
                this.appenderCache.put(name, docChild);
                return docChild;
            }
            ++i;
        }
        System.err.println("About to return null for an appender - code to deal with this probably hasn't been written yet");
        System.err.println("If this has happened without manual alteration of the log4j config file and still persists after loading");
        System.err.println("the default values for logging please mail suzy@upb.de and tell me what you did!");
        System.err.println("Problems caused by unexpected stuff in log4j config files will be solved soon, code still under construction");
        return null;
    }

    private String getParam(String name, Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element paramEl;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("param") && this.subst((paramEl = (Element)child).getAttribute("name")).equalsIgnoreCase(name)) {
                return this.subst(paramEl.getAttribute("value"));
            }
            ++i;
        }
        return null;
    }

    private void setParam(String name, String value, Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element paramEl;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("param") && this.subst((paramEl = (Element)child).getAttribute("name")).equalsIgnoreCase(name)) {
                try {
                    paramEl.setAttribute("value", value);
                }
                catch (DOMException domEx) {
                    System.err.println("Error thrown whilst trying to update a parameter element:" + domEx);
                }
            }
            ++i;
        }
    }

    private String subst(String val) {
        return OptionConverter.substVars((String)val, null);
    }
}

