/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class GeneralPreferences
extends AbstractPreferences {
    public static final String PROPERTY_NAME = "General.";
    public static final String WORKSPACE_FOLDER = "WorkspaceFolder";
    public static final String TEMPORARY_FOLDER = "TemporaryFolder";
    public static final String VIEW_FILTER_FOLDER = "ViewFilterFolder";
    private static final String JDK_FOLDER = "JDKFolder";
    private static final String JDK_FOLDER_IGNORE = "JDKFolderIgnore";
    public static final String USE_EXT_EDITOR = "UseExtEditor";
    public static final String EXTERNAL_EDITOR = "ExternalEditor";
    public static final String REPOSITORY_ACTIVATED = "RepositoryActivated";
    public static final String RECOVER_ACTIVATED = "RecoverActivated";
    public static final String FPR_ACTIVATED = "FPRActivated";
    public static final String CREATE_PROJECT_BACKUP = "CreateProjectBackup";
    public static final String EXPORT_TO_WORKSPACE_FOLDER = "ExportToWorkspaceFolder";
    public static final String EXPORT_TO_PROJECT_FOLDER = "ExportToProjectFolder";
    public static final String EXPORT_TO_TEMPORARY_FOLDER = "ExportToTemporaryFolder";
    public static final String COMMAND_LINE_PARSING = "CommandLineParsing";
    public static final String PROCESS_HISTORY = "ProcessHistory";
    public static final String LOOK_AND_FEEL = "LookAndFeel";
    private static final String DEF_WORKSPACE_FOLDER = System.getProperty("user.home");
    private static final String DEF_TEMPORARY_FOLDER = System.getProperty("java.io.tmpdir");
    private static final String DEF_VIEW_FILTER_FOLDER = String.valueOf(DEF_WORKSPACE_FOLDER) + System.getProperty("file.separator") + "filters";
    private static final String DEF_JDK_FOLDER = "";
    private static final boolean DEF_JDK_FOLDER_IGNORE = false;
    private static final boolean DEF_USE_EXT_EDITOR = false;
    private static final String DEF_EXTERNAL_EDITOR = "";
    private static final boolean DEF_REPOSITORY_ACTIVATED = false;
    private static final boolean DEF_RECOVER_ACTIVATED = false;
    private static final boolean DEF_FPR_ACTIVATED = true;
    private static final boolean DEF_CREATE_PROJECT_BACKUP = true;
    private static final boolean DEF_EXPORT_TO_WORKSPACE_FOLDER = false;
    private static final boolean DEF_EXPORT_TO_PROJECT_FOLDER = true;
    private static final boolean DEF_EXPORT_TO_TEMPORARY_FOLDER = false;
    private static final boolean DEF_COMMAND_LINE_PARSING = true;
    private static final String DEF_LOOK_AND_FEEL = "Metal";
    private static GeneralPreferences theOptionsGeneral;

    private GeneralPreferences() {
    }

    public static GeneralPreferences get() {
        if (theOptionsGeneral == null) {
            theOptionsGeneral = new GeneralPreferences();
        }
        return theOptionsGeneral;
    }

    public void setDefaults() {
        PreferencesProperties options = PreferencesProperties.get();
        options.putSetting("General.WorkspaceFolder", DEF_WORKSPACE_FOLDER);
        options.putSetting("General.TemporaryFolder", DEF_TEMPORARY_FOLDER);
        options.putSetting("General.ViewFilterFolder", DEF_VIEW_FILTER_FOLDER);
        options.putSetting("General.JDKFolder", "");
        options.putSetting("General.JDKFolderIgnore", false);
        options.putSetting("General.UseExtEditor", false);
        options.putSetting("General.ExternalEditor", "");
        options.putSetting("General.RepositoryActivated", false);
        options.putSetting("General.CreateProjectBackup", true);
        options.putSetting("General.ExportToWorkspaceFolder", false);
        options.putSetting("General.ExportToProjectFolder", true);
        options.putSetting("General.ExportToTemporaryFolder", false);
        options.putSetting("General.CommandLineParsing", true);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().removePropertyChangeListener(propertyName, listener);
    }

    public void setWorkspaceFolder(String value) {
        PreferencesProperties.get().putSetting("General.WorkspaceFolder", value);
        this.setModified(true);
    }

    public String getWorkspaceFolder() {
        return PreferencesProperties.get().getSetting("General.WorkspaceFolder", DEF_WORKSPACE_FOLDER);
    }

    public void setTemporaryFolder(String value) {
        PreferencesProperties.get().putSetting("General.TemporaryFolder", value);
        this.setModified(true);
    }

    public String getTemporaryFolder() {
        return PreferencesProperties.get().getSetting("General.TemporaryFolder", DEF_TEMPORARY_FOLDER);
    }

    public void setViewFilterFolder(String value) {
        PreferencesProperties.get().putSetting("General.ViewFilterFolder", value);
        this.setModified(true);
    }

    public String getViewFilterFolder() {
        return PreferencesProperties.get().getSetting("General.ViewFilterFolder", DEF_VIEW_FILTER_FOLDER);
    }

    public void setJDKFolder(String value) {
        PreferencesProperties.get().putSetting("General.JDKFolder", value);
        this.setModified(true);
    }

    public String getJDKFolder() {
        String checkedJdkFolder;
        String jdkFolder = PreferencesProperties.get().getSetting("General.JDKFolder", "");
        if (!jdkFolder.equals(checkedJdkFolder = this.checkJDKFolder(jdkFolder))) {
            this.setJDKFolder(checkedJdkFolder);
            PreferencesProperties.saveAll();
        }
        return checkedJdkFolder;
    }

    public void setJDKFolderIgnored(boolean value) {
        PreferencesProperties.get().putSetting("General.JDKFolderIgnore", value);
        this.setModified(true);
    }

    private String checkJDKFolder(String jdkFolder) {
        if (!this.isJDKFolderIgnored()) {
            File toolsjar;
            File jdk;
            Object message = jdkFolder.length() > 0 ? ((jdk = new File(jdkFolder)).isDirectory() ? ((toolsjar = new File(String.valueOf(jdkFolder) + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + "tools.jar")).exists() ? null : "The file 'tools.jar' was not found in the library folder of the JDK. Please specify the path\nto a valid JDK (in Fujaba under Options/Preferences). Some plugins (e.g. DOBS) and the default") : "The JDK folder that was specified (in Fujaba under Options/Preferences) does not exist! Please specify the path\nto a valid JDK. Some plugins (e.g. DOBS) and the default compiler require the tools.jar that comes with the JDK.") : "The JDK folder is not set. Please specify the path to a valid JDK (in Fujaba under Options/Preferences).\nSome plugins (e.g. DOBS) and the default compiler require the tools.jar that comes with the JDK.";
            if (message != null) {
                String specify = "Specify now";
                String ignoreForever = "Ignore forever";
                String ignore = "Ignore";
                Object[] choices = new String[]{"Specify now", "Ignore forever", "Ignore"};
                int choice = JOptionPane.showOptionDialog(FrameMain.get(), message, "JDK Folder", 0, 3, null, choices, "Specify now");
                if (choice == 0) {
                    File file = new File(System.getProperty("user.dir"), "*.*");
                    JFileChooser fileChooser = new JFileChooser(file);
                    fileChooser.setFileSelectionMode(1);
                    File dir = new File(jdkFolder);
                    if (dir.isDirectory()) {
                        fileChooser.setCurrentDirectory(dir);
                    }
                    if (fileChooser.showOpenDialog(FrameMain.get().getFrame()) == 0) {
                        file = fileChooser.getSelectedFile();
                        if (file.exists()) {
                            jdkFolder = this.checkJDKFolder(file.getPath());
                        }
                    } else {
                        jdkFolder = this.checkJDKFolder(jdkFolder);
                    }
                } else if (choice == 1) {
                    this.setJDKFolderIgnored(true);
                    PreferencesProperties.saveAll();
                }
            }
        }
        return jdkFolder;
    }

    public boolean isJDKFolderIgnored() {
        return Boolean.valueOf(PreferencesProperties.get().getSetting("General.JDKFolderIgnore", "false"));
    }

    public void setUseExtEditor(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.UseExtEditor", false) != value) {
            options.putSetting("General.UseExtEditor", value);
            this.setModified(true);
        }
    }

    public boolean isUseExtEditor() {
        return PreferencesProperties.get().getBoolSetting("General.UseExtEditor", false);
    }

    public void setExternalEditor(String value) {
        PreferencesProperties.get().putSetting("General.ExternalEditor", value);
        this.setModified(true);
    }

    public String getExternalEditor() {
        return PreferencesProperties.get().getSetting("General.ExternalEditor", "");
    }

    public void setRepositoryActivated(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.RepositoryActivated", false) != value) {
            options.putSetting("General.RepositoryActivated", value);
            this.setModified(true);
        }
    }

    public boolean isRepositoryActivated() {
        return PreferencesProperties.get().getBoolSetting("General.RepositoryActivated", false);
    }

    public void setRecoverActivated(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.RecoverActivated", false) != value) {
            options.putSetting("General.RecoverActivated", value);
            this.setModified(true);
        }
    }

    public boolean isRecoverActivated() {
        return PreferencesProperties.get().getBoolSetting("General.RecoverActivated", false);
    }

    public void setFPRActivated(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.FPRActivated", true) != value) {
            options.putSetting("General.FPRActivated", value);
            this.setModified(true);
        }
    }

    public boolean isFPRActivated() {
        return PreferencesProperties.get().getBoolSetting("General.FPRActivated", true);
    }

    public void setCreateProjectBackup(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.CreateProjectBackup", true) != value) {
            options.putSetting("General.CreateProjectBackup", value);
            this.setModified(true);
        }
    }

    public boolean isCreateProjectBackup() {
        return PreferencesProperties.get().getBoolSetting("General.CreateProjectBackup", true);
    }

    public void setExportToWorkspaceFolder(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.ExportToWorkspaceFolder", false) != value) {
            options.putSetting("General.ExportToWorkspaceFolder", value);
            this.setModified(true);
        }
    }

    public boolean isExportToWorkspaceFolder() {
        return PreferencesProperties.get().getBoolSetting("General.ExportToWorkspaceFolder", false);
    }

    public void setExportToProjectFolder(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.ExportToProjectFolder", true) != value) {
            options.putSetting("General.ExportToProjectFolder", value);
            this.setModified(true);
        }
    }

    public boolean isExportToProjectFolder() {
        return PreferencesProperties.get().getBoolSetting("General.ExportToProjectFolder", true);
    }

    public void setExportToTemporaryFolder(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.ExportToTemporaryFolder", false) != value) {
            options.putSetting("General.ExportToTemporaryFolder", value);
            this.setModified(true);
        }
    }

    public boolean isExportToTemporaryFolder() {
        return PreferencesProperties.get().getBoolSetting("General.ExportToTemporaryFolder", false);
    }

    public void setCommandLineParsing(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("General.CommandLineParsing", true) != value) {
            options.putSetting("General.CommandLineParsing", value);
            this.setModified(true);
        }
    }

    public boolean isCommandLineParsing() {
        return PreferencesProperties.get().getBoolSetting("General.CommandLineParsing", true);
    }

    public void setProcessHistory(Vector value) {
        PreferencesProperties.get().putSetting("General.ProcessHistory", value);
        this.setModified(true);
    }

    public Vector getProcessHistory() {
        return PreferencesProperties.get().getVectorSetting("General.ProcessHistory");
    }

    public void setLookAndFeel(String value) {
        PreferencesProperties.get().putSetting("General.LookAndFeel", value);
        this.setModified(true);
    }

    public String getLookAndFeel() {
        return PreferencesProperties.get().getSetting("General.LookAndFeel", DEF_LOOK_AND_FEEL);
    }

    public String getExportFolder() {
        if (this.isExportToWorkspaceFolder()) {
            return this.getWorkspaceFolder();
        }
        if (this.isExportToProjectFolder()) {
            return UMLProject.get().getRootDir();
        }
        return this.getTemporaryFolder();
    }
}

