/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.JavaPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class CodeGenPreferences
extends AbstractPreferences {
    public static final String PROPERTY_PREFIX = "CodeGenTarget.";
    private Map selectedCodeGenTargetNames = new HashMap();
    private static CodeGenPreferences theInstance = null;

    private CodeGenPreferences(boolean init) {
        Vector v = JavaPreferences.get().getCodeGenTargetName();
        int i = 0;
        while (i < v.size()) {
            String target = (String)v.get(i);
            if (target.equals("rtjava")) {
                this.selectedCodeGenTargetNames.put("java", new Boolean(false));
            } else {
                this.selectedCodeGenTargetNames.put(target, new Boolean(false));
            }
            ++i;
        }
        this.selectedCodeGenTargetNames.put("java", new Boolean(false));
        if (init) {
            this.setDefaults(true);
            this.load();
        }
    }

    public Map getSelectedCodeGenTargetNames() {
        return this.selectedCodeGenTargetNames;
    }

    public void setDefaults() {
        this.setDefaults(false);
    }

    private void setDefaults(boolean temporarily) {
        Iterator iter = this.selectedCodeGenTargetNames.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.selectedCodeGenTargetNames.put(key, new Boolean(false));
        }
        if (!temporarily) {
            this.save();
        }
    }

    public void load() {
        Iterator iter = this.selectedCodeGenTargetNames.keySet().iterator();
        boolean success = false;
        while (iter.hasNext()) {
            String targetName = (String)iter.next();
            boolean bool = PreferencesProperties.get().getBoolSetting(PROPERTY_PREFIX + targetName);
            if (!bool) continue;
            success = true;
            this.selectedCodeGenTargetNames.put(targetName, new Boolean(bool));
        }
        if (!success) {
            Vector defaultTargets = PreferencesProperties.get().getVectorSetting("Java.CodeGenTargetName");
            int i = 0;
            while (i < defaultTargets.size()) {
                String target = (String)defaultTargets.get(i);
                if (target.equals("rtjava")) {
                    this.selectedCodeGenTargetNames.put("java", new Boolean(true));
                } else {
                    this.selectedCodeGenTargetNames.put(target, new Boolean(true));
                }
                ++i;
            }
        }
    }

    public void save() {
        Iterator iter = this.selectedCodeGenTargetNames.keySet().iterator();
        while (iter.hasNext()) {
            String targetName = (String)iter.next();
            Boolean bool = (Boolean)this.selectedCodeGenTargetNames.get(targetName);
            PreferencesProperties.get().putSetting(PROPERTY_PREFIX + targetName, bool);
        }
        PreferencesProperties.get().putSetting("Java.CodeGenTargetName0", CodeGenFactory.get().getCurrentTarget().getName());
    }

    public static CodeGenPreferences get() {
        if (theInstance == null) {
            theInstance = new CodeGenPreferences(true);
        }
        return theInstance;
    }
}

