/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.mpEdit.DocInterface;
import de.uni_paderborn.fujaba.mpEdit.DocMan;
import de.uni_paderborn.fujaba.mpEdit.DocOwnerInterface;
import de.uni_paderborn.fujaba.mpEdit.EditorInterface;
import de.uni_paderborn.fujaba.mpEdit.EditorOwnerInterface;
import de.uni_paderborn.fujaba.mpEdit.KeyMap;
import de.uni_paderborn.fujaba.mpEdit.KeyMapFile;
import de.uni_paderborn.fujaba.mpEdit.KeyMapStd;
import de.uni_paderborn.fujaba.mpEdit.PropMan;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Logger;

public class mpEDIT
implements EditorInterface {
    private static final transient Logger log;
    private ResourceBundle strings;
    private PropMan propMan;
    private Properties props;
    private Vector docs;
    private Vector beans;
    private KeyMap keyMap;
    private EditorOwnerInterface editorOwner;
    private int untitled_count;
    private Dimension screenDim;
    private Dimension windowSize;
    private int windowOffset;
    private Point lastPlace;
    private boolean highlightingEnabled = true;
    private FrameMain frameMain;
    public static final String stringsResourceName = "de.uni_paderborn.fujaba.mpEdit.stringsResourceBundle";
    String openDir = ".";
    private static final String keytableFilename = "keys.set";
    private Vector searchPatterns = new Vector();
    String saveDir = ".";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.mpEdit.mpEDIT");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public mpEDIT(FrameMain main) {
        this.init(main);
    }

    public mpEDIT(FrameMain main, boolean highlightingEnabled) {
        this.setHighlightingEnabled(highlightingEnabled);
        this.init(main);
    }

    private void init(FrameMain main) {
        this.searchPatterns.addElement("Search1");
        this.searchPatterns.addElement("Search2");
        this.propMan = new PropMan();
        this.props = this.propMan.getProperties();
        this.strings = ResourceBundle.getBundle(stringsResourceName, Locale.getDefault());
        this.keyMap = new KeyMapStd();
        this.screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.windowSize = new Dimension(this.screenDim.width * 2 / 3, this.screenDim.height * 2 / 3);
        this.windowOffset = this.screenDim.height / 21;
        this.docs = new Vector(5, 5);
        this.frameMain = main;
    }

    public void setHighlightingEnabled(boolean value) {
        this.highlightingEnabled = value;
    }

    public boolean getHighlightingEnabled() {
        return this.highlightingEnabled;
    }

    public EditorOwnerInterface getOwner() {
        return this.editorOwner;
    }

    public int getUntitled() {
        return ++this.untitled_count;
    }

    public synchronized DocInterface newDoc(DocOwnerInterface o) {
        DocMan doc = (DocMan)this.newDoc();
        if (doc != null) {
            doc.setOwner(o);
        }
        return doc;
    }

    public synchronized DocInterface newDoc() {
        DocMan doc = new DocMan(this, this.strings, this.props);
        TextFrame textFrame = doc.newFrame(this.getPlace(this.windowSize), this.windowSize);
        doc.setUntitled(++this.untitled_count);
        textFrame.setVisible(true);
        this.docs.addElement(doc);
        return doc;
    }

    public synchronized void openDocDialog(DocMan doc, TextFrame textFrame) {
        String filename = this.getFileForOpen(textFrame);
        if (filename != null) {
            boolean newdoc = doc.isBusy();
            if (newdoc) {
                doc = new DocMan(this, this.strings, this.props);
                textFrame = doc.newFrame(this.getPlace(this.windowSize), this.windowSize);
            } else if (this.editorOwner != null) {
                this.editorOwner.closingDoc(doc);
            }
            doc.openDoc(textFrame, filename);
            if (this.editorOwner != null) {
                this.editorOwner.openedDoc(doc);
            }
            if (newdoc) {
                textFrame.setVisible(true);
                this.docs.addElement(doc);
            }
        }
    }

    public synchronized DocInterface openDoc(DocOwnerInterface o, String filename) {
        DocMan doc = (DocMan)this.openDoc(filename);
        if (doc != null) {
            doc.setOwner(o);
        }
        return doc;
    }

    public synchronized DocInterface openDoc(String filename) {
        DocMan doc = null;
        File file = new File(filename);
        if (file.isFile()) {
            doc = new DocMan(this, this.strings, this.props);
            TextFrame frame = doc.newFrame(this.getPlace(this.windowSize), this.windowSize);
            doc.openDoc(frame, filename);
            frame.setVisible(true);
            this.docs.addElement(doc);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("File not found: " + filename));
        }
        return doc;
    }

    public synchronized void openOneDoc() {
        if (this.docs.size() == 0) {
            this.newDoc();
        }
    }

    public synchronized void closeDoc(DocMan doc) {
        int max = this.docs.size();
        int i = 0;
        while (i < max) {
            if (doc == (DocMan)this.docs.elementAt(i)) {
                this.docs.removeElementAt(i);
                --max;
                break;
            }
            ++i;
        }
        if (this.editorOwner != null) {
            this.editorOwner.closingDoc(doc);
        }
        if (max == 0 && this.editorOwner != null) {
            this.editorOwner.lastFileClosed();
        }
    }

    public Dimension getWindowSize() {
        return this.windowSize;
    }

    public synchronized Point getPlace(Dimension size) {
        Point place = null;
        if (this.lastPlace == null) {
            place = new Point(20, 20);
        } else {
            place = new Point(this.lastPlace);
            place.y += this.windowOffset;
            place.x += this.windowOffset;
            if (place.x + size.width > this.screenDim.width) {
                place.x = 20;
            }
            if (place.y + size.height > this.screenDim.height) {
                place.y = 20;
            }
        }
        this.lastPlace = place;
        return place;
    }

    private String getFileForOpen(TextFrame textFrame) {
        String prompt = this.strings.getString("DialogOpen");
        FileDialog d = new FileDialog((Frame)textFrame, prompt, 0);
        d.setFile("*");
        d.setDirectory(this.openDir);
        d.setVisible(true);
        this.openDir = d.getDirectory();
        String filename = d.getFile();
        String pathname = String.valueOf(this.openDir) + filename;
        d.dispose();
        if (filename != null) {
            return pathname;
        }
        return null;
    }

    public String getKeyAction(int modifiers, int keys) {
        return this.keyMap.getAction(modifiers, keys);
    }

    public void loadKeytable() {
        block2: {
            try {
                FileReader fr = new FileReader(keytableFilename);
                this.keyMap = new KeyMapFile(fr);
            }
            catch (FileNotFoundException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)"No keys.set file");
            }
        }
    }

    public void saveKeytable() {
        block2: {
            try {
                FileWriter fw = new FileWriter(keytableFilename, false);
                this.keyMap.writeTo(fw);
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)"Cannot save keys.set file");
            }
        }
    }

    public void addSearchPattern(String patt) {
        int i = this.searchPatterns.indexOf(patt);
        if (i != this.searchPatterns.size() - 1) {
            if (i >= 0) {
                this.searchPatterns.removeElementAt(i);
            }
            this.searchPatterns.addElement(patt);
        }
    }

    public String[] getSearchPatterns() {
        Object[] newArray = new String[this.searchPatterns.size()];
        this.searchPatterns.copyInto(newArray);
        return newArray;
    }

    public String getLatestSearchPattern() {
        return (String)this.searchPatterns.lastElement();
    }

    public void setSaveDir(String dir) {
        this.saveDir = dir;
    }

    public String getSaveDir() {
        return this.saveDir;
    }

    public FrameMain getFrameMain() {
        return this.frameMain;
    }

    public void updateProperties(Properties p) {
        this.props = p;
        int i = this.docs.size();
        while (i-- > 0) {
            DocMan doc = (DocMan)this.docs.elementAt(i);
            doc.setProperties(this.props);
            doc.applyProperties();
        }
        this.propMan.writeProperties(p);
    }

    public Vector getBeans() {
        return this.beans;
    }

    public void closeDocs(boolean bail) {
        int i = this.docs.size();
        while (--i >= 0) {
            DocMan d = (DocMan)this.docs.elementAt(i);
            d.closeDoc(bail);
        }
    }
}

