/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.DocMan;
import de.uni_paderborn.fujaba.mpEdit.MpAction;
import de.uni_paderborn.fujaba.mpEdit.TextCanvas;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import de.uni_paderborn.fujaba.mpEdit.mpEDIT;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class TextMenu
extends JMenuBar
implements ActionListener,
ClipboardOwner {
    private static final transient Logger log;
    private mpEDIT mpEdit;
    private TextFrame textFrame;
    private TextCanvas textCanvas;
    private DocMan docMan;
    private ResourceBundle strings;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu optionMenu;
    private JMenu windowMenu;
    private JMenu helpMenu;
    private Clipboard clipboard;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.mpEdit.TextMenu");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public TextMenu(mpEDIT mpe, ResourceBundle str, DocMan doc, TextFrame tf) {
        this.mpEdit = mpe;
        this.strings = str;
        this.docMan = doc;
        this.textFrame = tf;
        this.textCanvas = this.textFrame.getCanvas();
        this.clipboard = this.textFrame.getToolkit().getSystemClipboard();
        this.makeFileMenu();
        this.makeEditMenu();
        this.makeOptionMenu();
        this.makeWindowMenu();
        this.makeHelpMenu();
        this.docMan.addTextMenu(this);
        this.textCanvas.setTextMenu(this);
    }

    private JMenuItem makeMenuItem(String actionId) {
        MpAction action = this.textCanvas.getMpAction(actionId);
        if (action == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Non existent action requested for menu: " + actionId));
            }
            return new JMenuItem("UNKNOWN!!!");
        }
        JMenuItem mi = new JMenuItem(action.getName());
        mi.addActionListener(action);
        action.addPropertyChangeListener(new MenuItemControl(mi));
        return mi;
    }

    private void makeFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.fileMenu.add(this.makeMenuItem("document-save"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.makeMenuItem("document-print-dialog"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.makeMenuItem("frame-close"));
        this.add(this.fileMenu);
    }

    private void makeEditMenu() {
        this.editMenu = new JMenu("Edit");
        this.editMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.editMenu.add(this.makeMenuItem("undo"));
        this.editMenu.add(this.makeMenuItem("redo"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.makeMenuItem("selection-copy"));
        this.editMenu.add(this.makeMenuItem("selection-cut"));
        this.editMenu.add(this.makeMenuItem("buffer-paste"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.makeMenuItem("find-dialog"));
        this.editMenu.add(this.makeMenuItem("replace-dialog"));
        this.editMenu.add(this.makeMenuItem("goto-dialog"));
        this.add(this.editMenu);
    }

    private void makeOptionMenu() {
        this.optionMenu = new JMenu("Options");
        this.optionMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.optionMenu.add(this.makeMenuItem("properties-dialog"));
        this.add(this.optionMenu);
    }

    private void makeWindowMenu() {
        this.windowMenu = new JMenu("Window");
        this.windowMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.windowMenu.add(this.makeMenuItem("frame-clone"));
        this.add(this.windowMenu);
    }

    private void makeHelpMenu() {
        this.helpMenu = new JMenu("Help");
        this.helpMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.helpMenu.add(this.makeMenuItem("help-about-dialog"));
        this.add(this.helpMenu);
    }

    public boolean toolButtonIgnore() {
        long time = this.textFrame.getActiveMillis();
        if (time == 0L) {
            return true;
        }
        return System.currentTimeMillis() - time < 100L;
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd == null) {
            return;
        }
    }

    public void CloseFindDialog(String pat) {
        this.mpEdit.addSearchPattern(pat);
    }

    public void CloseReplaceDialog(String pat, String rep) {
        this.mpEdit.addSearchPattern(pat);
        this.mpEdit.addSearchPattern(rep);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    ResourceBundle getStrings() {
        return this.strings;
    }

    Clipboard getClipboard() {
        return this.clipboard;
    }

    private class MenuItemControl
    implements PropertyChangeListener {
        JMenuItem menuItem;

        public MenuItemControl(JMenuItem mi) {
            this.menuItem = mi;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                this.menuItem.setEnabled((Boolean)evt.getNewValue());
            } else if (evt.getPropertyName().equals("Name")) {
                this.menuItem.setText((String)evt.getNewValue());
            }
        }
    }
}

