/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.DocMan;
import de.uni_paderborn.fujaba.mpEdit.Ruler;
import de.uni_paderborn.fujaba.mpEdit.TextCanvas;
import de.uni_paderborn.fujaba.mpEdit.TextMenu;
import de.uni_paderborn.fujaba.mpEdit.TextPosition;
import de.uni_paderborn.fujaba.mpEdit.mpEDIT;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JScrollBar;

public class TextFrame
extends JFrame
implements WindowListener {
    mpEDIT mpEdit;
    ResourceBundle strings;
    DocMan docMan;
    private JScrollBar horiz;
    private JScrollBar vert;
    private TextMenu textMenu;
    private TextCanvas textCanvas;
    long activeMillis = 0L;

    public TextFrame(mpEDIT mpe, ResourceBundle str, Properties pr, DocMan doc, Ruler ruler) {
        super.setTitle("mpEDIT");
        this.mpEdit = mpe;
        this.strings = str;
        this.docMan = doc;
        this.vert = new JScrollBar(1);
        this.getContentPane().add("East", this.vert);
        this.horiz = new JScrollBar(0);
        this.getContentPane().add("South", this.horiz);
        this.textCanvas = new TextCanvas(mpe, doc, this, this.horiz, this.vert, ruler);
        this.getContentPane().add("Center", this.textCanvas);
        this.textMenu = new TextMenu(this.mpEdit, this.strings, this.docMan, this);
        this.setJMenuBar(this.textMenu);
        this.addWindowListener(this);
    }

    public TextCanvas getCanvas() {
        return this.textCanvas;
    }

    public Point getPlace(Dimension size) {
        return this.mpEdit.getPlace(size);
    }

    public void clearCanvas() {
        this.textCanvas.clear();
    }

    public void redoCanvas() {
        this.textCanvas.redoCanvas();
        this.textCanvas.repaint();
    }

    public void legalizeCursor() {
        this.textCanvas.legalizeCursor();
    }

    public void release_cursor() {
        this.textCanvas.release_cursor();
    }

    public void pause_cursor() {
        this.textCanvas.pause_cursor();
    }

    public void setPos(TextPosition tp) {
        this.textCanvas.setPos(tp);
    }

    public void showLine(int line) {
        this.textCanvas.Goto(line + 1);
    }

    public void setReadOnly(boolean readOnly) {
        this.textCanvas.setReadOnly(readOnly);
    }

    public void setTitle(String name) {
        super.setTitle("mpEDIT - " + name);
    }

    public long getActiveMillis() {
        return this.activeMillis;
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
        this.activeMillis = System.currentTimeMillis();
    }

    public void windowDeactivated(WindowEvent event) {
        this.activeMillis = 0L;
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.docMan.closeFrame(this);
    }
}

