/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.DocMan;
import de.uni_paderborn.fujaba.mpEdit.TextPosition;
import java.awt.FontMetrics;

public class Ruler {
    private DocMan docMan;
    private FontMetrics fontMetrics;
    private int tabSize = 4;
    private char[] before;
    private char[] after;
    private boolean hasTabs;
    private int beforeMax;
    private int afterMax;
    private int lineLast;

    public Ruler(DocMan dm) {
        this.docMan = dm;
        this.lineLast = -1;
    }

    public synchronized void setFontMetrics(FontMetrics fm) {
        if (fm == this.fontMetrics) {
            return;
        }
        this.fontMetrics = fm;
        this.lineLast = -1;
    }

    public synchronized void setTabSize(int ts) {
        if (ts == this.tabSize) {
            return;
        }
        this.tabSize = ts;
        this.lineLast = -1;
    }

    public synchronized void invalidate(int first, int last) {
        if (this.lineLast >= first && this.lineLast <= last) {
            this.lineLast = -1;
        }
    }

    private void fillBuffers(int line_no) {
        this.before = this.docMan.getLine(line_no).toCharArray();
        int max = this.before.length;
        int i = 0;
        int j = 0;
        while (i < max) {
            if (this.before[i] == '\t') {
                ++j;
            }
            ++i;
        }
        if (j == 0) {
            this.hasTabs = false;
            this.after = this.before;
            j = max;
        } else {
            this.hasTabs = true;
            this.after = new char[max + j * (this.tabSize - 1)];
            i = 0;
            j = 0;
            while (i < max) {
                char c = this.before[i];
                if (c == '\t') {
                    int tabs = this.tabSize - j % this.tabSize;
                    while (tabs-- > 0) {
                        this.after[j++] = 32;
                    }
                } else {
                    this.after[j++] = c;
                }
                ++i;
            }
        }
        this.lineLast = line_no;
        this.beforeMax = this.before.length;
        this.afterMax = j;
    }

    public synchronized int length(int line, int column) {
        int uColumn;
        boolean readline;
        boolean bl = readline = line != this.lineLast;
        if (this.fontMetrics == null) {
            return -1;
        }
        if (column == 0) {
            return 0;
        }
        if (readline) {
            this.fillBuffers(line);
        }
        if (this.hasTabs) {
            uColumn = 1000000;
            int j = 0;
            int i = 0;
            while (i < this.beforeMax) {
                if (i == column) {
                    uColumn = j;
                    break;
                }
                char c = this.before[i];
                if (c == '\t') {
                    int tabs = this.tabSize - j % this.tabSize;
                    while (tabs-- > 0) {
                        ++j;
                    }
                } else {
                    ++j;
                }
                ++i;
            }
            this.afterMax = j;
            this.lineLast = line;
        } else {
            uColumn = column;
        }
        if (uColumn > this.afterMax) {
            uColumn = this.afterMax;
        }
        return this.fontMetrics.charsWidth(this.after, 0, uColumn);
    }

    public synchronized TextPosition position(int line, int x) {
        boolean readline;
        boolean bl = readline = line != this.lineLast;
        if (this.fontMetrics == null) {
            return new TextPosition(0, 0, 0);
        }
        if (readline) {
            this.fillBuffers(line);
        }
        int temp = 0;
        int pix = 0;
        int diff = x;
        int j = 0;
        int i = 0;
        while (i < this.beforeMax) {
            char c = this.before[i];
            if (c == '\t') {
                int tabs = this.tabSize - j % this.tabSize;
                while (tabs-- > 0) {
                    ++j;
                }
            } else {
                ++j;
            }
            int odiff = diff;
            temp = this.fontMetrics.charsWidth(this.after, 0, j);
            diff = Math.abs(x - temp);
            if (diff >= odiff) break;
            pix = temp;
            ++i;
        }
        return new TextPosition(line, i, pix);
    }
}

