/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.NotFoundDialog;
import de.uni_paderborn.fujaba.mpEdit.TextCanvas;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import de.uni_paderborn.fujaba.mpEdit.TextMenu;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ReplaceDialog
extends JDialog
implements WindowListener,
ActionListener {
    private JButton fbutton;
    private JButton rbutton;
    private JButton cbutton;
    private JTextField pattern;
    private JTextField replace;
    private TextFrame textFrame;
    private TextCanvas textCanvas;
    private TextMenu textMenu;
    private ResourceBundle strings;
    private String pat;
    private String rep;
    private boolean foundOnce = false;

    public ReplaceDialog(TextFrame tf, TextMenu tm, ResourceBundle str, String title) {
        super(tf, title, false);
        this.setBackground(Color.lightGray);
        this.textMenu = tm;
        this.strings = str;
        this.textFrame = tf;
        this.textCanvas = this.textFrame.getCanvas();
        String[] searchStrs = this.textFrame.getCanvas().getSearchPatterns();
        JPanel p1 = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        p1.setLayout(gridbag);
        JLabel flabel = new JLabel(this.strings.getString("PromptFind"));
        constraints.anchor = 18;
        gridbag.setConstraints(flabel, constraints);
        this.pat = searchStrs[searchStrs.length - 2];
        this.pattern = new JTextField(this.pat, 20);
        constraints.gridwidth = 0;
        gridbag.setConstraints(this.pattern, constraints);
        p1.add(flabel);
        p1.add(this.pattern);
        JLabel rlabel = new JLabel(this.strings.getString("PromptReplace"));
        constraints.anchor = 17;
        constraints.gridwidth = 1;
        gridbag.setConstraints(rlabel, constraints);
        this.rep = searchStrs[searchStrs.length - 1];
        this.replace = new JTextField(this.rep, 20);
        constraints.gridwidth = 0;
        gridbag.setConstraints(this.replace, constraints);
        p1.add(rlabel);
        p1.add(this.replace);
        this.getContentPane().add("Center", p1);
        JPanel p3 = new JPanel();
        this.fbutton = new JButton(this.strings.getString("ButtonFindNext"));
        this.fbutton.addActionListener(this);
        p3.add(this.fbutton);
        this.rbutton = new JButton(this.strings.getString("ButtonReplace"));
        this.rbutton.addActionListener(this);
        p3.add(this.rbutton);
        this.cbutton = new JButton(this.strings.getString("ButtonClose"));
        this.cbutton.addActionListener(this);
        p3.add(this.cbutton);
        this.getContentPane().add("South", p3);
        this.pack();
        Dimension size = this.getSize();
        this.setLocation(this.textFrame.getPlace(size));
        this.addWindowListener(this);
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.textMenu.CloseReplaceDialog(this.pattern.getText(), this.replace.getText());
        this.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.cbutton) {
            this.textMenu.CloseReplaceDialog(this.pattern.getText(), this.replace.getText());
            this.dispose();
            return;
        }
        if (evt.getSource() == this.fbutton) {
            this.foundOnce = this.textCanvas.find(this.pattern.getText());
        } else if (evt.getSource() == this.rbutton) {
            String selection;
            if (!this.foundOnce && (selection = this.textCanvas.copy(false, false)) != null) {
                this.foundOnce = selection.equals(this.pattern.getText());
            }
            if (this.foundOnce) {
                this.textCanvas.paste(this.replace.getText());
            }
            this.foundOnce = this.textCanvas.find(this.pattern.getText());
        }
        if (!this.foundOnce) {
            NotFoundDialog nf = new NotFoundDialog(this.textFrame, this.strings);
            nf.show();
        }
    }
}

