/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.DocMan;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PropDialog
extends JDialog
implements WindowListener,
ActionListener {
    DocMan docMan;
    JButton ok;
    JButton cancel;
    JTextField tabField = new JTextField(3);
    JComboBox fontChoice = new JComboBox();
    JComboBox styleChoice = new JComboBox();
    JComboBox sizeChoice = new JComboBox();
    ButtonGroup checkGroup = new ButtonGroup();
    JCheckBox syntax;
    JCheckBox hiding;
    JTextField hideLevel = new JTextField(3);
    JRadioButton checkThisDoc;
    JRadioButton checkAllDocs;

    public PropDialog(TextFrame textFrame, ResourceBundle strings, DocMan dm, String title) {
        super(textFrame, title, true);
        this.docMan = dm;
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel p = new JPanel();
        p.add(new JLabel(strings.getString("PromptFont")));
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontChoice.setEditable(false);
        int i = 0;
        while (i < fontNames.length) {
            this.fontChoice.addItem(fontNames[i]);
            ++i;
        }
        this.fontChoice.setSelectedItem(this.docMan.getProperty("mpEDIT.font.name"));
        p.add(this.fontChoice);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(15, 15, 15, 15);
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        this.getContentPane().add((Component)p, constraints);
        p = new JPanel();
        p.add(new JLabel(strings.getString("PromptStyle")));
        this.styleChoice.setEditable(false);
        this.styleChoice.addItem(strings.getString("ChoicePlain"));
        this.styleChoice.addItem(strings.getString("ChoiceBold"));
        this.styleChoice.addItem(strings.getString("ChoiceItalic"));
        this.styleChoice.addItem(strings.getString("ChoiceBoldItalic"));
        this.styleChoice.setSelectedItem(this.docMan.getFontStyle());
        p.add(this.styleChoice);
        constraints.gridx = 1;
        this.getContentPane().add((Component)p, constraints);
        p = new JPanel();
        p.add(new JLabel(strings.getString("PromptSize")));
        this.sizeChoice.setEditable(false);
        this.sizeChoice.addItem("8");
        this.sizeChoice.addItem("9");
        this.sizeChoice.addItem("10");
        this.sizeChoice.addItem("11");
        this.sizeChoice.addItem("12");
        this.sizeChoice.addItem("14");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("18");
        this.sizeChoice.addItem("24");
        this.sizeChoice.addItem("36");
        this.sizeChoice.addItem("48");
        this.sizeChoice.setSelectedItem(this.docMan.getProperty("mpEDIT.font.size"));
        p.add(this.sizeChoice);
        constraints.gridx = 2;
        this.getContentPane().add((Component)p, constraints);
        p = new JPanel();
        p.add(new JLabel(strings.getString("PromptTab")));
        this.tabField.setText(this.docMan.getProperty("mpEDIT.tab.size"));
        p.add(this.tabField);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        this.getContentPane().add((Component)p, constraints);
        p = new JPanel(new GridBagLayout());
        GridBagConstraints myconstraints = new GridBagConstraints();
        this.hiding = new JCheckBox(strings.getString("HideSourcecode"));
        this.hiding.setSelected(Boolean.valueOf(this.docMan.getProperty("mpEDIT.hide")));
        this.hideLevel.setText(this.docMan.getProperty("mpEDIT.hide.level"));
        this.syntax = new JCheckBox(strings.getString("PromptSyntax"));
        this.syntax.setSelected(Boolean.valueOf(this.docMan.getProperty("mpEDIT.hilite")));
        this.syntax.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropDialog.this.hiding.setEnabled(PropDialog.this.syntax.isSelected());
                if (PropDialog.this.syntax.isSelected()) {
                    PropDialog.this.hideLevel.setText(PropDialog.this.docMan.getProperty("mpEDIT.hide.level"));
                }
            }
        });
        p.add((Component)this.syntax, myconstraints);
        myconstraints.gridy = 1;
        p.add((Component)this.hiding, myconstraints);
        p.add((Component)new JLabel(strings.getString("HideLevel")), myconstraints);
        p.add((Component)this.hideLevel, myconstraints);
        constraints.gridy = -1;
        this.getContentPane().add((Component)p, constraints);
        p = new JPanel();
        this.checkThisDoc = new JRadioButton(strings.getString("CheckThisDoc"));
        this.checkAllDocs = new JRadioButton(strings.getString("CheckAllDocs"));
        this.checkGroup = new ButtonGroup();
        this.checkGroup.add(this.checkThisDoc);
        this.checkGroup.add(this.checkAllDocs);
        p.add(new JLabel(strings.getString("PromptLocal")));
        p.add(this.checkThisDoc);
        p.add(this.checkAllDocs);
        constraints.gridy = 3;
        this.getContentPane().add((Component)p, constraints);
        constraints.gridy = 4;
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 10;
        this.ok = new JButton(strings.getString("ButtonOk"));
        this.ok.addActionListener(this);
        this.getContentPane().add((Component)this.ok, constraints);
        constraints.gridx = 2;
        this.cancel = new JButton(strings.getString("ButtonCancel"));
        this.cancel.addActionListener(this);
        this.getContentPane().add((Component)this.cancel, constraints);
        this.pack();
        Dimension size = this.getSize();
        this.setLocation(textFrame.getPlace(size));
        this.addWindowListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ok) {
            boolean all = this.checkAllDocs.isSelected();
            if (!all) {
                this.docMan.splitProperties();
            }
            this.docMan.setProperty("mpEDIT.font.name", (String)this.fontChoice.getSelectedItem());
            this.docMan.setFontStyle((String)this.styleChoice.getSelectedItem());
            this.docMan.setProperty("mpEDIT.font.size", (String)this.sizeChoice.getSelectedItem());
            this.docMan.setProperty("mpEDIT.tab.size", this.tabField.getText());
            this.docMan.setProperty("mpEDIT.hilite", String.valueOf(this.syntax.isSelected()));
            this.docMan.setProperty("mpEDIT.hide", String.valueOf(this.hiding.isSelected()));
            this.docMan.setProperty("mpEDIT.hide.level", this.hideLevel.getText());
            this.docMan.updateProperties(all);
            this.docMan.scan();
        }
        this.dispose();
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }
}

